/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.monitor;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.avalon.excalibur.monitor.Modifiable;

public abstract class Resource
implements Modifiable {
    protected static final String MODIFIED = "last-modified";
    private final Set m_propertyListeners = Collections.synchronizedSet(new HashSet());
    protected PropertyChangeSupport m_eventSupport = new PropertyChangeSupport(this);
    private final String m_resourceKey;
    protected long m_previousModified = 0L;

    public Resource(String resourceKey) throws Exception {
        if (null == resourceKey) {
            throw new NullPointerException("resourceKey");
        }
        this.m_resourceKey = resourceKey;
    }

    public final String getResourceKey() {
        return this.m_resourceKey;
    }

    public abstract long lastModified();

    public void testModifiedAfter(long time) {
        if (this.getPreviousModified() > time) {
            return;
        }
        long lastModified = this.lastModified();
        if (lastModified > this.getPreviousModified() || lastModified > time) {
            this.fireAndSetModifiedTime(lastModified);
        }
    }

    protected void fireAndSetModifiedTime(long lastModified) {
        this.getEventSupport().firePropertyChange(MODIFIED, new Long(this.getPreviousModified()), new Long(lastModified));
        this.setPreviousModified(lastModified);
    }

    public void addPropertyChangeListenersFrom(Resource other) {
        PropertyChangeListener[] listeners = other.m_propertyListeners.toArray(new PropertyChangeListener[0]);
        int i = 0;
        while (i < listeners.length) {
            this.addPropertyChangeListener(listeners[i]);
            ++i;
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getEventSupport().addPropertyChangeListener(listener);
        this.m_propertyListeners.add(listener);
    }

    protected void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.getEventSupport().addPropertyChangeListener(property, listener);
        this.m_propertyListeners.add(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getEventSupport().removePropertyChangeListener(listener);
        this.m_propertyListeners.remove(listener);
    }

    protected void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.getEventSupport().removePropertyChangeListener(property, listener);
        this.m_propertyListeners.remove(listener);
    }

    public final boolean hasListeners() {
        return this.getEventSupport().hasListeners(this.getResourceKey());
    }

    public void removeAllPropertyChangeListeners() {
        PropertyChangeListener[] listeners = this.m_propertyListeners.toArray(new PropertyChangeListener[0]);
        int i = 0;
        while (i < listeners.length) {
            this.removePropertyChangeListener(listeners[i]);
            ++i;
        }
    }

    protected boolean hasListeners(String property) {
        return this.getEventSupport().hasListeners(property);
    }

    protected final long getPreviousModified() {
        return this.m_previousModified;
    }

    protected final void setPreviousModified(long previousModified) {
        this.m_previousModified = previousModified;
    }

    protected final PropertyChangeSupport getEventSupport() {
        return this.m_eventSupport;
    }

    public String toString() {
        return this.m_resourceKey;
    }
}

