/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import org.apache.cocoon.components.elementprocessor.types.NumericConverter;
import org.apache.cocoon.components.elementprocessor.types.Validator;

public class VerticalAlignment {
    private int _alignment;
    private static final int _top = 1;
    private static final int _bottom = 2;
    private static final int _center = 4;
    private static final int _justify = 8;
    private static final Validator _validator = new Validator(){

        public IOException validate(Number number) {
            int value = number.intValue();
            return value >= 0 && value <= 15 ? null : new IOException("\"" + number + "\" is out of range");
        }
    };

    public VerticalAlignment(String value) throws IOException {
        this._alignment = NumericConverter.extractInteger(value, _validator).intValue();
    }

    public boolean isTop() {
        return (this._alignment & 1) == 1;
    }

    public boolean isBottom() {
        return (this._alignment & 2) == 2;
    }

    public boolean isCenter() {
        return (this._alignment & 4) == 4;
    }

    public boolean isJustify() {
        return (this._alignment & 8) == 8;
    }

    public short getCode() {
        return (short)this._alignment;
    }
}

