/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout.hyphenation;

import java.io.Serializable;

public class CharVector
implements Cloneable,
Serializable {
    private static final int DEFAULT_BLOCK_SIZE = 2048;
    private int BLOCK_SIZE;
    private char[] array;
    private int n;

    public CharVector() {
        this(2048);
    }

    public CharVector(int capacity) {
        this.BLOCK_SIZE = capacity > 0 ? capacity : 2048;
        this.array = new char[this.BLOCK_SIZE];
        this.n = 0;
    }

    public CharVector(char[] a) {
        this.BLOCK_SIZE = 2048;
        this.array = a;
        this.n = a.length;
    }

    public CharVector(char[] a, int capacity) {
        this.BLOCK_SIZE = capacity > 0 ? capacity : 2048;
        this.array = a;
        this.n = a.length;
    }

    public int alloc(int size) {
        int index = this.n;
        int len = this.array.length;
        if (this.n + size >= len) {
            char[] aux = new char[len + this.BLOCK_SIZE];
            System.arraycopy(this.array, 0, aux, 0, len);
            this.array = aux;
        }
        this.n += size;
        return index;
    }

    public int capacity() {
        return this.array.length;
    }

    public void clear() {
        this.n = 0;
    }

    public Object clone() {
        CharVector cv = new CharVector((char[])this.array.clone(), this.BLOCK_SIZE);
        cv.n = this.n;
        return cv;
    }

    public char get(int index) {
        return this.array[index];
    }

    public char[] getArray() {
        return this.array;
    }

    public int length() {
        return this.n;
    }

    public void put(int index, char val) {
        this.array[index] = val;
    }

    public void trimToSize() {
        if (this.n < this.array.length) {
            char[] aux = new char[this.n];
            System.arraycopy(this.array, 0, aux, 0, this.n);
            this.array = aux;
        }
    }
}

