/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.xscript;

import java.util.Stack;
import org.apache.cocoon.components.xscript.NPU;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StringBufferContentHandler
extends DefaultHandler {
    private static Object marker = new Object();
    private Stack namespaces = new Stack();
    private StringBuffer stringBuffer;

    public StringBufferContentHandler(StringBuffer stringBuffer) {
        this.stringBuffer = stringBuffer;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.push(new NPU(prefix, uri));
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaces.pop();
    }

    public void startElement(String uri, String loc, String qName, Attributes a) throws SAXException {
        int lastNamespaceIndex = 0;
        lastNamespaceIndex = this.namespaces.size() - 1;
        while (lastNamespaceIndex >= 0 && this.namespaces.elementAt(lastNamespaceIndex) != marker) {
            --lastNamespaceIndex;
        }
        if (lastNamespaceIndex < 0) {
            lastNamespaceIndex = 0;
        } else if (this.namespaces.elementAt(lastNamespaceIndex) == marker) {
            ++lastNamespaceIndex;
        }
        this.namespaces.push(marker);
        this.stringBuffer.append("<").append(qName);
        int i = 0;
        int len = a.getLength();
        while (i < len) {
            String attrName = a.getQName(i);
            if (attrName.startsWith("xmlns:")) {
                String name = a.getLocalName(i);
                boolean found = false;
                int j = this.namespaces.size() - 1;
                while (j >= lastNamespaceIndex) {
                    Object obj = this.namespaces.elementAt(j);
                    if (obj != marker) {
                        NPU npu = (NPU)obj;
                        if (name.equals(npu.prefix)) {
                            found = true;
                            break;
                        }
                    }
                    --j;
                }
                if (!found) {
                    this.namespaces.push(new NPU(name, a.getValue(i)));
                }
            } else {
                this.stringBuffer.append(" ").append(a.getQName(i)).append("=\"");
                StringBufferContentHandler.escape(this.stringBuffer, a.getValue(i));
                this.stringBuffer.append("\"");
            }
            ++i;
        }
        if (this.namespaces.size() != 0) {
            int i2 = this.namespaces.size() - 1;
            while (i2 >= lastNamespaceIndex) {
                Object obj = this.namespaces.elementAt(i2);
                if (obj != marker) {
                    NPU npu = (NPU)obj;
                    if ("".equals(npu.prefix)) {
                        this.stringBuffer.append(" xmlns").append("=\"").append(npu.uri).append("\"");
                    } else {
                        this.stringBuffer.append(" xmlns:").append(npu.prefix).append("=\"").append(npu.uri).append("\"");
                    }
                }
                --i2;
            }
        }
        this.stringBuffer.append(">");
    }

    public void endElement(String uri, String loc, String qName) throws SAXException {
        Object obj;
        this.stringBuffer.append("</").append(qName).append(">");
        while ((obj = this.namespaces.pop()) != marker) {
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        StringBufferContentHandler.escape(this.stringBuffer, ch, start, len);
    }

    private static void escape(StringBuffer buffer, String s) {
        char[] ch = s.toCharArray();
        StringBufferContentHandler.escape(buffer, ch, 0, ch.length);
    }

    private static void escape(StringBuffer buffer, char[] ch, int start, int len) {
        int i = start;
        while (i < start + len) {
            switch (ch[i]) {
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                default: {
                    buffer.append(ch[i]);
                }
            }
            ++i;
        }
    }
}

