/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.oai.util;

import org.apache.avalon.framework.logger.Logger;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: Apr 28, 2003
 * Time: 2:36:57 PM
 * To change this template use Options | File Templates.
 */
public class OAIUtilities {

    /**Returns true if a string is not null or empty
     *
     * @param s The string to verify
     */
    public static boolean checkString(String s) {
        if (s != null && !s.trim().equals(""))
            return true;
        else
            return false;
    }

    /**Verifies the super.getLog() and logs a message
     *
     * @param logger    The super.getLog()
     * @param s         The message
     */
    public static void logInfo(Logger logger, String s) {
        if (logger != null && s != null)
            logger.info(s);
        else {//?:what else can we do besides go system out
        }
    }

    /**Verifies the super.getLog() and logs a message
     *
     * @param logger    The super.getLog()
     * @param s         The message (maybe null)
     * @param e         The exception (maybe null)
     */
    public static void logDebug(Logger logger, String s, Exception e) {
        if (logger != null) {
            if (s != null) {
                if (e != null) {
                    logger.debug(s, e);
                } else
                    logger.debug(s);
            } else if (e != null && (e.getMessage() != null & e.fillInStackTrace() != null)) {
                logger.debug(e.getMessage(), e.fillInStackTrace());
            }
        } else {//?:what else can we do besides go system out
        }
    }

    /**Verifies the super.getLog() and logs a message
     *
     * @param logger    The super.getLog()
     * @param s         The message (maybe null)
     * @param e         The exception (maybe null)
     */
    public static void logError(Logger logger, String s, Exception e) {
        if (logger != null) {
            if (s != null) {
                if (e != null) {
                    logger.error(s, e);
                } else
                    logger.error(s);
            } else if (e != null && (e.getMessage() != null & e.fillInStackTrace() != null)) {
                logger.error(e.getMessage(), e.fillInStackTrace());
            }
        } else {//?:what else can we do besides go system out
        }
    }

    /**Verifies the super.getLog() and logs a message
     *
     * @param logger    The super.getLog()
     * @param s         The message (maybe null)
     * @param e         The exception (maybe null)
     */
    public static void logWarn(Logger logger, String s, Exception e) {
        if (logger != null) {
            if (s != null) {
                if (e != null) {
                    logger.warn(s, e);
                } else
                    logger.warn(s);
            } else if (e != null)
                logger.warn(e.getMessage(), e);

        } else {//?:what else can we do besides go system out
        }
    }

    /**Verifies the super.getLog() and logs an exception
     *
     * @param logger    The super.getLog()
     * @param e         The exception (maybe null)
     */
    public static void logException(Logger logger, Exception e) {
        if (logger != null && e != null && (e.getMessage() != null && e.fillInStackTrace() != null))
            logger.error(e.getMessage(), e.fillInStackTrace());
        else {//?:what else can we do besides go system out
        }
    }


    public static class Date {
        public static String formatDate(java.util.Date date) {
            // return formatDate(date, "yyyy/MM/dd HH:mm:ss");
            return formatUtcISO8601Date(date);
        }

        public static String formatUtcISO8601Date(java.util.Date date) {
            return formatDate(date, "yyyy-MM-dd'T'HH:mm:ss") + "Z";
        }

        public static java.util.Date getUtcIso8601Date() {
            GregorianCalendar cal = new GregorianCalendar();
            java.util.Date theDate = null;
            int offset = cal.get(Calendar.ZONE_OFFSET) + cal.get(Calendar.DST_OFFSET);
            // Convert to UTC
            theDate = new java.util.Date(cal.getTime().getTime() - offset);
            return theDate;
        }

        /** Formats a date according to the specified format.
         *
         * @param date The date to format.
         * @param format The desired format.
         * @return The formated date.
         */
        public static String formatDate(java.util.Date date, String format) {
            //TODO : next method would return null for an invalid date ?! -pb
            if (date == null || format == null) return "";

            SimpleDateFormat df = new SimpleDateFormat(format);
            try {
                return df.format(date);
            } catch (Exception e) {
                return "";
            }
        }
    }

    //TODO:why is this happening
    public static String normalizeHttpRequestParameterName(String origName) {
        String prefix = "amp;";
        if (origName == null || !origName.startsWith(prefix))
            return origName;
        else
            return origName.substring(prefix.length());

    }


}
