/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils;

import fr.gouv.culture.sdx.application.Application;
import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.framework.FrameworkImpl;
import fr.gouv.culture.sdx.search.lucene.query.Query;
import fr.gouv.culture.sdx.search.lucene.query.RemoteIndex;
import fr.gouv.culture.sdx.utils.SAXUtils;
import fr.gouv.culture.sdx.utils.SdxObject;
import fr.gouv.culture.sdx.utils.jvm.URLCoderWrapper;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Naming;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.avalon.excalibur.io.FileUtil;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.lucene.search.BooleanQuery;

public class Utilities {
    public static File getSystemTempDir() {
        String javaIoTmpDir = System.getProperty("java.io.tmpdir");
        if (Utilities.checkString(javaIoTmpDir)) {
            return new File(javaIoTmpDir);
        }
        return null;
    }

    public static File checkDirectory(String dirPath, Logger logger) throws SDXException {
        if (!Utilities.checkString(dirPath)) {
            throw new SDXException(logger, 100, null, null);
        }
        File dir = new File(dirPath);
        if (dir == null) {
            throw new SDXException(logger, 101, null, null);
        }
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                String[] args = new String[2];
                args[0] = dir.getAbsolutePath();
                throw new SDXException(logger, 102, args, null);
            }
            LoggingUtils.logInfo(logger, "\tThe Directory and any necessary parent directories \"" + dir.getAbsolutePath() + "\" were successfully created.");
        } else {
            LoggingUtils.logInfo(logger, "\tThe Directory \"" + dir.toString() + "\" exists.");
        }
        if (!dir.isDirectory()) {
            String[] args = new String[2];
            args[0] = dir.getAbsolutePath();
            throw new SDXException(logger, 103, args, null);
        }
        if (!dir.canRead()) {
            String[] args = new String[2];
            args[0] = dir.getAbsolutePath();
            throw new SDXException(logger, 104, args, null);
        }
        if (!dir.canWrite()) {
            String[] args = new String[2];
            args[0] = dir.getAbsolutePath();
            SDXException sdxE = new SDXException(null, 105, args, null);
            LoggingUtils.logWarn(logger, sdxE.getMessage(), null);
        }
        return dir;
    }

    public static void checkDocument(Logger logger, Document doc) throws SDXException {
        if (doc == null) {
            throw new SDXException(logger, 5000, null, null);
        }
        if (!Utilities.checkString(doc.getId())) {
            String[] args = new String[1];
            if (doc.getURL() != null) {
                args[0] = doc.getURL().toString();
            }
            throw new SDXException(logger, 5001, args, null);
        }
    }

    public static void checkOutputStream(Logger logger, OutputStream os) throws SDXException {
        if (os == null) {
            throw new SDXException(logger, 213, null, null);
        }
    }

    public static void checkXmlConsumer(Logger logger, XMLConsumer consumer) throws SDXException {
        if (consumer == null) {
            throw new SDXException(logger, 214, null, null);
        }
    }

    public static File resolveFile(Logger logger, String confLocation, Context context, String path, boolean isConfDirectory) throws SDXException {
        String currentDir = confLocation;
        if (!Utilities.checkString(path)) {
            throw new SDXException(null, 107, null, null);
        }
        File file = null;
        try {
            if (path.startsWith("file:/")) {
                file = FileUtil.toFile((URL)new URL(path));
            }
        }
        catch (MalformedURLException e) {
            String[] args = new String[]{path};
            throw new SDXException(logger, 112, args, e);
        }
        if (file != null && file.exists()) {
            return file;
        }
        if (file != null && isConfDirectory) {
            return Utilities.checkDirectory(file.getAbsolutePath(), logger);
        }
        if (context != null) {
            try {
                if (confLocation.indexOf("sdx.xconf") > -1 || confLocation.indexOf(new File(Utilities.getStringFromContext("sdx.framework.confPath", context)).toURL().toExternalForm()) > -1) {
                    currentDir = Utilities.getStringFromContext("sdx.framework.confPath", context);
                } else if (confLocation.indexOf("application.xconf") > -1 || confLocation.indexOf(new File(Utilities.getStringFromContext("sdx.application.confDirPath", context)).toURL().toExternalForm()) > -1) {
                    currentDir = Utilities.getStringFromContext("sdx.application.confDirPath", context);
                } else {
                    String tmp = currentDir;
                    int endIdx = tmp.lastIndexOf("/");
                    if (endIdx < 0) {
                        endIdx = tmp.length();
                    }
                    currentDir = FileUtil.toFile((URL)new URL(tmp.substring(0, endIdx))).getCanonicalPath();
                }
            }
            catch (IOException e) {
                String[] args = new String[]{path};
                throw new SDXException(null, 108, args, e);
            }
            file = path.startsWith("/") ? new File(Utilities.getStringFromContext("sdx.framework.rootPath", context), path.substring(1)) : FileUtil.resolveFile((File)new File(currentDir), (String)path);
        }
        if (file != null && file.exists()) {
            return file;
        }
        if (file != null && isConfDirectory) {
            return Utilities.checkDirectory(file.getAbsolutePath(), logger);
        }
        if (!(path.startsWith("file:/") | path.startsWith("http:/"))) {
            File fileUpload = new File(currentDir);
            String tmp = fileUpload.getParent();
            if ((tmp = Utilities.replaceAllSubString(tmp, "\\\\", "/")).lastIndexOf(47) != tmp.length()) {
                tmp = tmp + '/';
            }
            file = new File(tmp + path);
        }
        if (file != null && file.exists()) {
            return file;
        }
        String[] args = new String[]{path};
        throw new SDXException(logger, 108, args, null);
    }

    public static boolean checkString(String s) {
        return s != null && !s.trim().equals("");
    }

    public static Locale buildLocale(Configuration conf, Locale defaultLocale) {
        String xmlLang = conf.getAttribute("xml:lang", null);
        String variant = conf.getAttribute("variant", null);
        return Utilities.buildLocale(xmlLang, variant, defaultLocale);
    }

    public static Locale buildLocale(String xmlLang, String variant, Locale defaultLocale) {
        Locale locale = null;
        String country = "";
        String lang = "";
        if (defaultLocale == null) {
            defaultLocale = Locale.getDefault();
        }
        if (Utilities.checkString(xmlLang)) {
            int hypenIndex = xmlLang.indexOf("-");
            if (hypenIndex > 0) {
                lang = xmlLang.substring(0, hypenIndex);
                country = xmlLang.substring(hypenIndex + 1);
            } else {
                lang = xmlLang;
            }
        }
        locale = Utilities.checkString(lang) ? (Utilities.checkString(country) ? (Utilities.checkString(variant) ? new Locale(lang, country, variant) : new Locale(lang, country)) : new Locale(lang, "")) : defaultLocale;
        return locale;
    }

    public static String attId(String baseId, String relId) {
        return baseId + "_" + relId;
    }

    public static URL attUrl(URL refURL, String path) throws MalformedURLException {
        String attUrl = path;
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            if (refURL != null && Utilities.checkString(refURL.toExternalForm())) {
                try {
                    File f = FileUtil.toFile((URL)refURL);
                    URL resultURL = null;
                    if (f != null) {
                        resultURL = FileUtil.resolveFile((File)FileUtil.toFile((URL)refURL).getParentFile(), (String)attUrl).toURL();
                    } else if (f == null) {
                        URL baseURL = new URL(refURL.toString().substring(0, refURL.toString().lastIndexOf("/") + 1));
                        resultURL = new URL(baseURL, attUrl);
                    }
                    return resultURL;
                }
                catch (MalformedURLException e1) {
                    try {
                        return new URL(refURL, attUrl);
                    }
                    catch (MalformedURLException e2) {
                        throw new MalformedURLException(e.getMessage() + "\n" + e1.getMessage() + "\n" + e2.getMessage());
                    }
                }
            }
            throw e;
        }
    }

    public static String getStringFromContext(String key, Context context) {
        String value = null;
        if (Utilities.checkString(key) && context != null) {
            try {
                value = (String)context.get((Object)key);
            }
            catch (ContextException e) {
                value = null;
            }
        }
        return value;
    }

    public static Object getObjectFromContext(String key, Context context) {
        Object value = null;
        if (Utilities.checkString(key) && context != null) {
            try {
                value = context.get((Object)key);
            }
            catch (ContextException e) {
                value = null;
            }
        }
        return value;
    }

    public static String buildRmiName(String rmiHost, int rmiPort, String appId, String dbId) {
        String rmiName = null;
        if (Utilities.checkString(rmiHost) && Utilities.checkString(appId) && Utilities.checkString(dbId)) {
            rmiName = "//" + rmiHost + ":" + Integer.toString(rmiPort) + "/" + appId + "_" + dbId;
        }
        return rmiName;
    }

    public static RemoteIndex getRemoteIndex(Logger logger, String remoteIndexName) throws SDXException {
        RemoteIndex rIndex = null;
        try {
            rIndex = (RemoteIndex)Naming.lookup(remoteIndexName);
        }
        catch (Exception e) {
            String[] args = new String[]{remoteIndexName};
            throw new SDXException(logger, 110, args, e);
        }
        return rIndex;
    }

    public static String joinStrings(String[] strings, String delimiter) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        if (delimiter == null) {
            delimiter = "";
        }
        String newString = null;
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] == null) {
                strings[i] = "";
            }
            newString = i == 0 ? strings[i] : newString + delimiter + strings[i];
        }
        return newString;
    }

    public static Application getApplication(ServiceManager manager, Context context) throws SDXException {
        Application app = null;
        String appId = Utilities.getStringFromContext("sdx.application.id", context);
        FrameworkImpl frame = null;
        if (Utilities.checkString(appId)) {
            try {
                frame = (FrameworkImpl)manager.lookup("fr.gouv.culture.sdx.framework.Framework");
                if (frame != null) {
                    app = frame.getApplicationById(appId);
                }
            }
            catch (ServiceException e) {
                throw new SDXException(null, 0, null, e);
            }
            finally {
                manager.release((Object)frame);
            }
        }
        return app;
    }

    public static String encodeURL(String url, String encoding) {
        try {
            return URLCoderWrapper.encode(url, encoding);
        }
        catch (Exception e) {
            try {
                return URLCoderWrapper.encode(url, "UTF-8");
            }
            catch (Exception e1) {
                return url;
            }
        }
    }

    public static String decodeURL(String url, String encoding) {
        try {
            return URLCoderWrapper.decode(url, encoding);
        }
        catch (Exception e) {
            try {
                return URLCoderWrapper.decode(url, "UTF-8");
            }
            catch (Exception e1) {
                return url;
            }
        }
    }

    public static String prefixNodeNameSDX(String elemName) {
        return SAXUtils.prefixNodeName("sdx", elemName);
    }

    public static File createTempDirectory(Logger logger, String prefix, String suffix, File parentDir) throws SDXException {
        try {
            Utilities.checkDirectory(parentDir.getAbsolutePath(), logger);
            File tmpFile = File.createTempFile(prefix, suffix, parentDir);
            if (!tmpFile.delete()) {
                throw new SDXException(logger, 0, null, null);
            }
            while (tmpFile.isDirectory()) {
                tmpFile = Utilities.createTempDirectory(logger, prefix, suffix, parentDir);
            }
            return Utilities.checkDirectory(tmpFile.getAbsolutePath(), logger);
        }
        catch (IOException e) {
            throw new SDXException(logger, 0, null, e);
        }
    }

    public static SdxObject setUpSdxObject(SdxObject sdxObj, Logger logger, Context context, ServiceManager manager) throws ConfigurationException {
        try {
            sdxObj.enableLogging(logger);
            sdxObj.contextualize(context);
            sdxObj.service(manager);
        }
        catch (ContextException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        return sdxObj;
    }

    public static void isObjectUnique(Hashtable objs, String key, Object obj) throws SDXException {
        String l_key = key;
        if (!Utilities.checkString(l_key) && obj != null && obj instanceof SdxObject) {
            l_key = ((SdxObject)obj).getId();
        }
        if (objs != null && objs.containsKey(l_key)) {
            String[] l_args = new String[2];
            l_args[0] = "";
            if (obj != null) {
                l_args[0] = obj.toString();
            }
            l_args[1] = l_key;
            throw new SDXException(null, 46, l_args, null);
        }
    }

    public static void isObjectUnique(Context objs, String key, Object obj) throws SDXException {
        String l_key = key;
        if (!Utilities.checkString(l_key) && obj != null && obj instanceof SdxObject) {
            l_key = ((SdxObject)obj).getId();
        }
        try {
            Object l_obj = objs.get((Object)l_key);
            if (l_obj != null) {
                String[] l_args = new String[2];
                l_args[0] = l_obj.toString();
                if (obj != null) {
                    l_args[0] = obj.toString();
                }
                l_args[1] = l_key;
                throw new SDXException(null, 46, l_args, null);
            }
        }
        catch (ContextException e) {
            // empty catch block
        }
    }

    public static Object getObjectForClassName(Logger logger, String fullClassName, String packageNamePrefix, String shortName, String classNameSuffix) throws ConfigurationException {
        String l_className = fullClassName;
        Class<?> l_objClass = null;
        Object l_obj = null;
        try {
            try {
                l_objClass = Class.forName(l_className);
            }
            catch (ClassNotFoundException e) {
                l_className = packageNamePrefix + shortName.substring(0, 1).toUpperCase() + shortName.substring(1, shortName.length());
                try {
                    l_objClass = Class.forName(l_className);
                }
                catch (ClassNotFoundException e1) {
                    l_className = l_className + classNameSuffix;
                    try {
                        l_objClass = Class.forName(l_className);
                    }
                    catch (ClassNotFoundException e2) {
                        l_className = packageNamePrefix + shortName.toUpperCase() + classNameSuffix;
                        try {
                            l_objClass = Class.forName(l_className);
                        }
                        catch (ClassNotFoundException e3) {
                            throw e;
                        }
                    }
                }
            }
            l_obj = l_objClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        if (l_obj == null) {
            String[] args = new String[]{shortName};
            SDXException l_sdxE = new SDXException(null, 220, args, null);
            throw new ConfigurationException(l_sdxE.getMessage(), (Throwable)((Object)l_sdxE));
        }
        return l_obj;
    }

    public static String getElementName(String classNameSuffix) {
        return classNameSuffix.substring(0, 1).toLowerCase() + classNameSuffix.substring(1, classNameSuffix.length());
    }

    public static Context createNewReadOnlyContext(Context context) {
        DefaultContext l_context = new DefaultContext(context);
        l_context.makeReadOnly();
        return l_context;
    }

    public static BooleanQuery newBooleanQuery() {
        BooleanQuery l_bq = new BooleanQuery();
        BooleanQuery.setMaxClauseCount((int)Query.LUCENE_BOOLEAN_QUERY_MAX_CLAUSES);
        return l_bq;
    }

    public static boolean copyFile(File srcFile, File dstDir) throws IOException {
        if (srcFile == null || dstDir == null) {
            return false;
        }
        if (!srcFile.isFile() || !dstDir.isDirectory()) {
            return false;
        }
        int BUFFER_SIZE = 1024;
        byte[] bArray = new byte[1024];
        int getSize = 1024;
        File targetFile = new File(dstDir.getAbsolutePath() + File.separator + srcFile.getName());
        targetFile.delete();
        targetFile.createNewFile();
        FileInputStream streamToCopy = new FileInputStream(srcFile);
        FileOutputStream streamTarget = new FileOutputStream(targetFile);
        for (long bufPointer = 0L; bufPointer < srcFile.length(); bufPointer += 1024L) {
            getSize = srcFile.length() - bufPointer < 1024L ? (int)(srcFile.length() - bufPointer) : 1024;
            streamToCopy.read(bArray, 0, getSize);
            streamTarget.write(bArray, 0, getSize);
        }
        streamTarget.close();
        streamToCopy.close();
        return true;
    }

    public static void safeCopy(File src, File dst) {
        if (src == null || dst == null || !src.exists()) {
            return;
        }
        try {
            FileUtil.deleteDirectory((String)dst.getAbsolutePath());
        }
        catch (IOException e) {
            // empty catch block
        }
        src.renameTo(dst);
        if (!dst.exists()) {
            File[] content = src.listFiles();
            boolean copyCheck = true;
            for (int i = 0; content != null && i < content.length && copyCheck; ++i) {
                if (!content[i].isFile()) continue;
                try {
                    copyCheck = Utilities.copyFile(content[i], dst);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                if (copyCheck) {
                    FileUtil.deleteDirectory((File)src);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static boolean isNameMatchIndexFiles(String name) {
        long value = 0L;
        try {
            value = Long.parseLong(name);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return value >= 0L && value <= 9999L;
    }

    public static String replaceAllSubString(String source, String what, String with) {
        StringBuffer result = new StringBuffer(source);
        int i = source.indexOf(what);
        int length_what = what.length();
        int length_with = with.length();
        while (i != -1) {
            result = result.replace(i, i + length_what, with);
            i = result.toString().indexOf(what, i + length_with);
        }
        return result.toString();
    }
}

