/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.oai.util;

import fr.gouv.culture.sdx.utils.Utilities;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.apache.avalon.framework.logger.Logger;

public class OAIUtilities {
    public static boolean checkString(String s) {
        return s != null && !"".equals(s) && !"".equals(s.trim());
    }

    public static void logInfo(Logger logger, String s) {
        if (logger != null && Utilities.checkString(s)) {
            logger.info(s);
        }
    }

    public static void logDebug(Logger logger, String s) {
        OAIUtilities.logDebug(logger, s, null);
    }

    public static void logDebug(Logger logger, String s, Exception e) {
        if (logger != null) {
            if (Utilities.checkString(s)) {
                if (e != null) {
                    logger.debug(s, (Throwable)e);
                } else {
                    logger.debug(s);
                }
            } else if (e != null && e.getMessage() != null & e.fillInStackTrace() != null) {
                logger.debug(e.getMessage(), e.fillInStackTrace());
            }
        }
    }

    public static void logError(Logger logger, String s) {
        OAIUtilities.logError(logger, s, null);
    }

    public static void logError(Logger logger, String s, Exception e) {
        if (logger != null) {
            if (Utilities.checkString(s)) {
                if (e != null) {
                    logger.error(s, (Throwable)e);
                } else {
                    logger.error(s);
                }
            } else if (e != null && e.getMessage() != null & e.fillInStackTrace() != null) {
                logger.error(e.getMessage(), e.fillInStackTrace());
            }
        }
    }

    public static void logWarn(Logger logger, String s) {
        OAIUtilities.logWarn(logger, s, null);
    }

    public static void logWarn(Logger logger, String s, Exception e) {
        if (logger != null) {
            if (Utilities.checkString(s)) {
                if (e != null) {
                    logger.warn(s, (Throwable)e);
                } else {
                    logger.warn(s);
                }
            } else if (e != null) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void logException(Logger logger, Exception e) {
        if (logger != null && e != null && e.getMessage() != null && e.fillInStackTrace() != null) {
            logger.error(e.getMessage(), e.fillInStackTrace());
        }
    }

    public static String normalizeHttpRequestParameterName(String origName) {
        String prefix = "amp;";
        if (origName == null || !origName.startsWith(prefix)) {
            return origName;
        }
        return origName.substring(prefix.length());
    }

    public static class Date {
        public static String formatDate(java.util.Date date) {
            return Date.formatUtcISO8601Date(date);
        }

        public static String formatUtcISO8601Date(java.util.Date date) {
            return Date.formatDate(date, "yyyy-MM-dd'T'HH:mm:ss") + "Z";
        }

        public static java.util.Date getUtcIso8601Date() {
            GregorianCalendar cal = new GregorianCalendar();
            java.util.Date theDate = null;
            int offset = cal.get(15) + cal.get(16);
            theDate = new java.util.Date(cal.getTime().getTime() - (long)offset);
            return theDate;
        }

        public static String formatDate(java.util.Date date, String format) {
            if (date == null || format == null) {
                return "";
            }
            SimpleDateFormat df = new SimpleDateFormat(format);
            try {
                return df.format(date);
            }
            catch (Exception e) {
                return "";
            }
        }
    }
}

