/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.queryparser;

import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer;
import fr.gouv.culture.sdx.search.lucene.analysis.DefaultAnalyzer;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.search.lucene.queryparser.CharStream;
import fr.gouv.culture.sdx.search.lucene.queryparser.FastCharStream;
import fr.gouv.culture.sdx.search.lucene.queryparser.ParseException;
import fr.gouv.culture.sdx.search.lucene.queryparser.QueryParser;
import fr.gouv.culture.sdx.search.lucene.queryparser.Token;
import fr.gouv.culture.sdx.search.lucene.queryparser.TokenMgrError;
import fr.gouv.culture.sdx.search.lucene.queryparser.ZeroPositionIncrementTokenQueryParserConstants;
import fr.gouv.culture.sdx.search.lucene.queryparser.ZeroPositionIncrementTokenQueryParserTokenManager;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.UnanalyzedQuery;
import org.apache.lucene.search.WildcardQuery;

public class ZeroPositionIncrementTokenQueryParser
implements QueryParser,
ZeroPositionIncrementTokenQueryParserConstants {
    private static final int CONJ_NONE = 0;
    private static final int CONJ_AND = 1;
    private static final int CONJ_OR = 2;
    private static final int MOD_NONE = 0;
    private static final int MOD_NOT = 10;
    private static final int MOD_REQ = 11;
    public static final int DEFAULT_OPERATOR_OR = 0;
    public static final int DEFAULT_OPERATOR_AND = 1;
    private int operator = 0;
    boolean lowercaseWildcardTerms = true;
    public SearchLocations sLocs = null;
    Analyzer analyzer;
    String field;
    int phraseSlop = 0;
    Locale locale = Locale.getDefault();
    public ZeroPositionIncrementTokenQueryParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[24];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static Query parse(String query, String field, Analyzer analyzer) throws ParseException {
        ZeroPositionIncrementTokenQueryParser parser = new ZeroPositionIncrementTokenQueryParser(field, analyzer);
        return parser.parse(query);
    }

    public ZeroPositionIncrementTokenQueryParser() {
        this(new FastCharStream(new StringReader("")));
    }

    public ZeroPositionIncrementTokenQueryParser(String f, Analyzer a) {
        this(new FastCharStream(new StringReader("")));
        this.analyzer = a;
        this.field = f;
    }

    public void setUp(String f, Analyzer a) {
        this.analyzer = a;
        this.field = f;
    }

    public void setUp(Analyzer a, int phraseSlop, int operator) {
        this.analyzer = a;
        this.setPhraseSlop(phraseSlop);
        this.setOperator(operator);
    }

    public void setUp(String f, Analyzer a, int phraseSlop, int operator) {
        this.field = f;
        this.setUp(a, phraseSlop, operator);
    }

    public void setUp(String f, Analyzer a, SearchLocations sl, int phraseSlop, int operator) {
        this.field = f;
        this.sLocs = sl;
        this.setUp(a, phraseSlop, operator);
    }

    public Query parse(String query) throws ParseException {
        this.ReInit(new FastCharStream(new StringReader(query)));
        try {
            return this.Query(this.field);
        }
        catch (TokenMgrError tme) {
            throw new ParseException(tme.getMessage());
        }
        catch (BooleanQuery.TooManyClauses tmc) {
            throw new ParseException("Too many boolean clauses");
        }
    }

    public void setPhraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public int getPhraseSlop() {
        return this.phraseSlop;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setLowercaseWildcardTerms(boolean lowercaseWildcardTerms) {
        this.lowercaseWildcardTerms = lowercaseWildcardTerms;
    }

    public boolean getLowercaseWildcardTerms() {
        return this.lowercaseWildcardTerms;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void addClause(Vector clauses, int conj, int mods, Query q) {
        boolean required;
        boolean prohibited;
        BooleanClause c;
        if (conj == 1 && (c = (BooleanClause)clauses.elementAt(clauses.size() - 1)).getOccur() != BooleanClause.Occur.MUST_NOT) {
            c.setOccur(BooleanClause.Occur.MUST);
        }
        if (this.operator == 1 && conj == 2 && (c = (BooleanClause)clauses.elementAt(clauses.size() - 1)).getOccur() != BooleanClause.Occur.MUST_NOT) {
            c.setOccur(BooleanClause.Occur.SHOULD);
        }
        if (q == null) {
            return;
        }
        if (this.operator == 0) {
            prohibited = mods == 10;
            boolean bl = required = mods == 11;
            if (conj == 1 && !prohibited) {
                required = true;
            }
        } else {
            prohibited = mods == 10;
            boolean bl = required = !prohibited && conj != 2;
        }
        if (required) {
            clauses.addElement(new BooleanClause(q, BooleanClause.Occur.MUST));
        } else if (prohibited) {
            clauses.addElement(new BooleanClause(q, BooleanClause.Occur.MUST_NOT));
        } else {
            clauses.addElement(new BooleanClause(q, BooleanClause.Occur.SHOULD));
        }
    }

    protected Query getFieldQuery(String field, Analyzer analyzer, String queryText) throws ParseException {
        PhraseQuery q;
        org.apache.lucene.analysis.Token t;
        TokenStream source = analyzer.tokenStream(field, new StringReader(queryText));
        Vector<org.apache.lucene.analysis.Token> v = new Vector<org.apache.lucene.analysis.Token>();
        int positionCount = 0;
        boolean severalTokensAtSamePosition = false;
        while (true) {
            try {
                t = source.next();
            }
            catch (IOException e) {
                t = null;
            }
            if (t == null) break;
            v.addElement(t);
            if (t.getPositionIncrement() == 1) {
                ++positionCount;
                continue;
            }
            severalTokensAtSamePosition = true;
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (v.size() == 0) {
            return null;
        }
        if (v.size() == 1) {
            t = (org.apache.lucene.analysis.Token)v.elementAt(0);
            return new TermQuery(new Term(field, t.termText()));
        }
        if (severalTokensAtSamePosition) {
            PhraseQuery currentQuery;
            int i;
            if (positionCount == 1) {
                q = new BooleanQuery();
                for (int i2 = 0; i2 < v.size(); ++i2) {
                    t = (org.apache.lucene.analysis.Token)v.elementAt(i2);
                    TermQuery currentQuery2 = new TermQuery(new Term(field, t.termText()));
                    q.add((Query)currentQuery2, BooleanClause.Occur.SHOULD);
                }
                return q;
            }
            q = new BooleanQuery();
            Vector queriesSoFar = new Vector();
            Vector<PhraseQuery> newQueries = new Vector<PhraseQuery>();
            int currentPosition = 0;
            for (i = 0; i < v.size(); ++i) {
                int j;
                t = (org.apache.lucene.analysis.Token)v.elementAt(i);
                if (t.getPositionIncrement() == 1) {
                    queriesSoFar.removeAllElements();
                    for (j = 0; j < newQueries.size(); ++j) {
                        queriesSoFar.add(newQueries.elementAt(j));
                    }
                    newQueries.removeAllElements();
                    ++currentPosition;
                }
                if (currentPosition == 1) {
                    currentQuery = new PhraseQuery();
                    currentQuery.setSlop(this.phraseSlop);
                    currentQuery.add(new Term(field, t.termText()));
                    newQueries.add(currentQuery);
                    continue;
                }
                for (j = 0; j < queriesSoFar.size(); ++j) {
                    PhraseQuery previousQuery = (PhraseQuery)queriesSoFar.elementAt(j);
                    Term[] terms = previousQuery.getTerms();
                    currentQuery = new PhraseQuery();
                    currentQuery.setSlop(this.phraseSlop);
                    for (int k = 0; k < terms.length; ++k) {
                        currentQuery.add(terms[k]);
                    }
                    currentQuery.add(new Term(field, t.termText()));
                    newQueries.add(currentQuery);
                }
            }
            for (i = 0; i < newQueries.size(); ++i) {
                currentQuery = (PhraseQuery)newQueries.elementAt(i);
                q.add((Query)currentQuery, BooleanClause.Occur.SHOULD);
            }
            return q;
        }
        q = new PhraseQuery();
        q.setSlop(this.phraseSlop);
        for (int i = 0; i < v.size(); ++i) {
            q.add(new Term(field, ((org.apache.lucene.analysis.Token)v.elementAt(i)).termText()));
        }
        return q;
    }

    protected Query getUnanalyzedQuery(String field, String queryText) {
        return new UnanalyzedQuery(new Term(field, queryText));
    }

    protected Query getRangeQuery(String field, Analyzer analyzer, String part1, String part2, boolean inclusive) throws ParseException {
        try {
            Date d1 = fr.gouv.culture.sdx.utils.Date.parseDate(part1);
            Date d2 = fr.gouv.culture.sdx.utils.Date.parseDate(part2);
            part1 = DateField.dateToString(d1);
            part2 = DateField.dateToString(d2);
        }
        catch (Exception e) {
            // empty catch block
        }
        return new RangeQuery(new Term(field, part1), new Term(field, part2), inclusive);
    }

    protected Query getBooleanQuery(Vector clauses) throws ParseException {
        BooleanQuery query = new BooleanQuery();
        for (int i = 0; i < clauses.size(); ++i) {
            query.add((BooleanClause)clauses.elementAt(i));
        }
        return query;
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if (this.lowercaseWildcardTerms) {
            termStr = termStr.toLowerCase();
        }
        Term t = new Term(field, termStr);
        return new WildcardQuery(t);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        if (this.lowercaseWildcardTerms) {
            termStr = termStr.toLowerCase();
        }
        Term t = new Term(field, termStr);
        return new PrefixQuery(t);
    }

    protected Query getFuzzyQuery(String field, String termStr) throws ParseException {
        Term t = new Term(field, termStr);
        return new FuzzyQuery(t);
    }

    private String discardEscapeChar(String input) {
        char[] caSource = input.toCharArray();
        char[] caDest = new char[caSource.length];
        int j = 0;
        for (int i = 0; i < caSource.length; ++i) {
            if (caSource[i] == '\\' && (i <= 0 || caSource[i - 1] != '\\')) continue;
            caDest[j++] = caSource[i];
        }
        return new String(caDest, 0, j);
    }

    public static void main(String[] args) throws Exception {
        ZeroPositionIncrementTokenQueryParser qp = new ZeroPositionIncrementTokenQueryParser("field", new DefaultAnalyzer());
        Query q = qp.parse(args[0]);
        System.out.println(q.toString("field"));
    }

    public final int Conjunction() throws ParseException {
        int ret = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        ret = 1;
                        break block0;
                    }
                    case 8: {
                        this.jj_consume_token(8);
                        ret = 2;
                        break block0;
                    }
                }
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        return ret;
    }

    public final int Modifiers() throws ParseException {
        int ret = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: {
                        this.jj_consume_token(10);
                        ret = 11;
                        break block0;
                    }
                    case 11: {
                        this.jj_consume_token(11);
                        ret = 10;
                        break block0;
                    }
                    case 9: {
                        this.jj_consume_token(9);
                        ret = 10;
                        break block0;
                    }
                }
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        return ret;
    }

    public final Query Query(String field) throws ParseException {
        Vector clauses = new Vector();
        Query firstQuery = null;
        int mods = this.Modifiers();
        Query q = this.Clause(field);
        this.addClause(clauses, 0, mods, q);
        if (mods == 0) {
            firstQuery = q;
        }
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 16: 
                case 17: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            int conj = this.Conjunction();
            mods = this.Modifiers();
            q = this.Clause(field);
            this.addClause(clauses, conj, mods, q);
        }
        if (clauses.size() == 1 && firstQuery != null) {
            return firstQuery;
        }
        return this.getBooleanQuery(clauses);
    }

    /*
     * WARNING - void declaration
     */
    public final Query Clause(String field) throws ParseException {
        void var2_4;
        Token fieldToken = null;
        Token boost = null;
        if (this.jj_2_1(2)) {
            fieldToken = this.jj_consume_token(18);
            this.jj_consume_token(14);
            field = this.discardEscapeChar(fieldToken.image);
        }
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                Query q = this.Term(field);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                Query q = this.Query(field);
                this.jj_consume_token(13);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        boost = this.jj_consume_token(25);
                        break block1;
                    }
                }
                this.jj_la1[5] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (boost != null) {
            float f = 1.0f;
            try {
                f = Float.valueOf(boost.image).floatValue();
                var2_4.setBoost(f);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return var2_4;
    }

    /*
     * WARNING - void declaration
     */
    public final Query Term(String field) throws ParseException {
        void var11_13;
        Token boost = null;
        Token slop = null;
        boolean prefix = false;
        boolean wildcard = false;
        boolean fuzzy = false;
        boolean rangein = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: 
            case 21: 
            case 22: 
            case 25: {
                Query q;
                Token term;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        term = this.jj_consume_token(18);
                        break;
                    }
                    case 21: {
                        term = this.jj_consume_token(21);
                        prefix = true;
                        break;
                    }
                    case 22: {
                        term = this.jj_consume_token(22);
                        wildcard = true;
                        break;
                    }
                    case 25: {
                        term = this.jj_consume_token(25);
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: {
                        this.jj_consume_token(19);
                        fuzzy = true;
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                    }
                }
                block19 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        boost = this.jj_consume_token(25);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 19: {
                                this.jj_consume_token(19);
                                fuzzy = true;
                                break block19;
                            }
                        }
                        this.jj_la1[9] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                    }
                }
                String termImage = this.discardEscapeChar(term.image);
                if (wildcard) {
                    q = this.getWildcardQuery(field, termImage);
                    break;
                }
                if (prefix) {
                    q = this.getPrefixQuery(field, this.discardEscapeChar(term.image.substring(0, term.image.length() - 1)));
                    break;
                }
                if (fuzzy) {
                    q = this.getFuzzyQuery(field, termImage);
                    break;
                }
                q = this.getFieldQuery(field, this.analyzer, termImage);
                break;
            }
            case 23: {
                Token goop2;
                Token goop1;
                this.jj_consume_token(23);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        goop1 = this.jj_consume_token(29);
                        break;
                    }
                    case 28: {
                        goop1 = this.jj_consume_token(28);
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: {
                        this.jj_consume_token(26);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        goop2 = this.jj_consume_token(29);
                        break;
                    }
                    case 28: {
                        goop2 = this.jj_consume_token(28);
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(27);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        boost = this.jj_consume_token(25);
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                    }
                }
                goop1.image = goop1.kind == 28 ? goop1.image.substring(1, goop1.image.length() - 1) : this.discardEscapeChar(goop1.image);
                goop2.image = goop2.kind == 28 ? goop2.image.substring(1, goop2.image.length() - 1) : this.discardEscapeChar(goop2.image);
                Query q = this.getRangeQuery(field, this.analyzer, goop1.image, goop2.image, true);
                break;
            }
            case 24: {
                void var6_17;
                void var5_15;
                this.jj_consume_token(24);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 33: {
                        Token goop1 = this.jj_consume_token(33);
                        break;
                    }
                    case 32: {
                        Token goop1 = this.jj_consume_token(32);
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        this.jj_consume_token(30);
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 33: {
                        Token goop2 = this.jj_consume_token(33);
                        break;
                    }
                    case 32: {
                        Token goop2 = this.jj_consume_token(32);
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(31);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        boost = this.jj_consume_token(25);
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                    }
                }
                var5_15.image = var5_15.kind == 32 ? var5_15.image.substring(1, var5_15.image.length() - 1) : this.discardEscapeChar(var5_15.image);
                var6_17.image = var6_17.kind == 32 ? var6_17.image.substring(1, var6_17.image.length() - 1) : this.discardEscapeChar(var6_17.image);
                Query q = this.getRangeQuery(field, this.analyzer, var5_15.image, var6_17.image, false);
                break;
            }
            case 16: {
                Token term = this.jj_consume_token(16);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        slop = this.jj_consume_token(20);
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        boost = this.jj_consume_token(25);
                        break;
                    }
                    default: {
                        this.jj_la1[20] = this.jj_gen;
                    }
                }
                int s1 = 0;
                if (slop != null) {
                    try {
                        s1 = Float.valueOf(slop.image.substring(1)).intValue();
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                Query q = this.getFieldQuery(field, this.analyzer, term.image.substring(1, term.image.length() - 1));
                if (s1 == 0) break;
                if (q instanceof PhraseQuery) {
                    ((PhraseQuery)q).setSlop(s1);
                    break;
                }
                if (!(q instanceof BooleanQuery)) break;
                BooleanClause[] bc = ((BooleanQuery)q).getClauses();
                for (int i = 0; i < bc.length; ++i) {
                    if (!(bc[i].getQuery() instanceof PhraseQuery)) continue;
                    ((PhraseQuery)bc[i].getQuery()).setSlop(s1);
                }
                break;
            }
            case 17: {
                Token term = this.jj_consume_token(17);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        slop = this.jj_consume_token(20);
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        boost = this.jj_consume_token(25);
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                    }
                }
                Query q = this.getUnanalyzedQuery(field, term.image.substring(1, term.image.length() - 1));
                if (slop == null || !(q instanceof PhraseQuery)) break;
                try {
                    int s = Float.valueOf(slop.image.substring(1)).intValue();
                    ((PhraseQuery)q).setSlop(s);
                }
                catch (Exception ignored) {}
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (boost != null) {
            float f = 1.0f;
            try {
                f = Float.valueOf(boost.image).floatValue();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (var11_13 != null) {
                var11_13.setBoost(f);
            }
        }
        return var11_13;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(14);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{384, 384, 3584, 3584, 65478528, 32768, 65474560, 40108032, 524288, 524288, 32768, 0x30000000, 0x4000000, 0x30000000, 32768, 0, 0x40000000, 0, 32768, 0x100000, 32768, 0x100000, 32768, 65470464};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0};
    }

    public ZeroPositionIncrementTokenQueryParser(CharStream stream) {
        int i;
        this.token_source = new ZeroPositionIncrementTokenQueryParserTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 24; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CharStream stream) {
        int i;
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 24; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ZeroPositionIncrementTokenQueryParser(ZeroPositionIncrementTokenQueryParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 24; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ZeroPositionIncrementTokenQueryParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 24; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[34];
        for (i = 0; i < 34; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 24; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 34; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ZeroPositionIncrementTokenQueryParser.jj_la1_0();
        ZeroPositionIncrementTokenQueryParser.jj_la1_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

