<?xml version="1.0"?>
<!--
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
-->
<!--                                                                      -->
<!-- =========================== INDEXATION ============================= -->
<!--                                                                      -->
<!--     One of the speciality of SDX is the "a priori" indexation.   	  -->
<!--     This way gives powerfull and optimized searching on a known      -->
<!--     collection of documents, following a precise schema (or DTD,     -->
<!--     Document Type Definition).                                       -->
<!--                                                                      -->
<!--     Here you can define what will be in your fields.                 -->
<!--     XSL syntax gives you all the necessary tools to extract          -->
<!--     contents from documents for fields.                              -->
<!--                                                                      -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdx="http://www.culture.gouv.fr/ns/sdx/sdx">
    <xsl:param name="jour"/>
    <xsl:variable name="id" select="/*/@id"/>
    <!--
	 root template, matches the root element of your documents -->
    <xsl:template match="/projet">
        <!-- output root element, creates an SDX document with the given @id attribute  -->
        <sdx:document id="{$id}">
            <!--  For a full text field, we "apply-templates" accross the whole document, except that we need a space between the each element's text ; that's why it's called "fulltext" mode  -->
            <sdx:field code="contenu">
                <xsl:apply-templates mode="fulltext"/>
            </sdx:field>
            <!-- title is then indexed -->
            <xsl:apply-templates select="titre"/>
            <xsl:apply-templates select="adresses/adresse"/>
            <xsl:apply-templates select="images/image"/>
            <xsl:if test="$jour">
                <sdx:field code="jour">
                    <xsl:value-of select="$jour"/>
                </sdx:field>
            </xsl:if>
        </sdx:document>
    </xsl:template>
    <!-- attached a document -->
    <xsl:template match="image">
        <xsl:message>attach <xsl:value-of select="@src"/>
        </xsl:message>
        <sdx:attachedDocument id="{$id}" attid="img" url="{@src}" mimetype="{@mime-type}"/>
    </xsl:template>
    <!-- specific templates of the projet.dtd -->
    <xsl:template match="titre">
        <sdx:field code="titre">
            <xsl:value-of select="normalize-space(.)"/>
        </sdx:field>
    </xsl:template>
    <xsl:template match="adresse">
        <sdx:field code="url">
            <xsl:value-of select="normalize-space(.)"/>
        </sdx:field>
    </xsl:template>
    <!-- a very simple template, puts a space between all elements
	and cut extra spaces and break-lines  -->
    <xsl:template match="*" mode="fulltext">
        <xsl:apply-templates select="*|text()" mode="fulltext"/>
    </xsl:template>
    <xsl:template match="text()" mode="fulltext">
        <xsl:value-of select="normalize-space(.)"/>
        <xsl:if test="normalize-space(.) !=''">
            <xsl:text>&#32;</xsl:text>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
