/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.ComposedJXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.binding.ValueJXPathBinding;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;

public class RepeaterJXPathBinding
extends JXPathBindingBase {
    private final String repeaterId;
    private final String repeaterPath;
    private final String rowPath;
    private final String rowPathForInsert;
    private final JXPathBindingBase rowBinding;
    private final JXPathBindingBase insertRowBinding;
    private final JXPathBindingBase deleteRowBinding;
    private final ComposedJXPathBindingBase identityBinding;

    public RepeaterJXPathBinding(JXPathBindingBuilderBase.CommonAttributes commonAtts, String repeaterId, String repeaterPath, String rowPath, String rowPathForInsert, JXPathBindingBase[] childBindings, JXPathBindingBase insertBinding, JXPathBindingBase[] deleteBindings, JXPathBindingBase[] identityBindings) {
        super(commonAtts);
        this.repeaterId = repeaterId;
        this.repeaterPath = repeaterPath;
        this.rowPath = rowPath;
        this.rowPathForInsert = rowPathForInsert;
        this.rowBinding = new ComposedJXPathBindingBase(JXPathBindingBuilderBase.CommonAttributes.DEFAULT, childBindings);
        this.rowBinding.setParent(this);
        this.insertRowBinding = insertBinding;
        if (this.insertRowBinding != null) {
            this.insertRowBinding.setParent(this);
        }
        if (deleteBindings != null) {
            this.deleteRowBinding = new ComposedJXPathBindingBase(JXPathBindingBuilderBase.CommonAttributes.DEFAULT, deleteBindings);
            this.deleteRowBinding.setParent(this);
        } else {
            this.deleteRowBinding = null;
        }
        this.identityBinding = new ComposedJXPathBindingBase(JXPathBindingBuilderBase.CommonAttributes.DEFAULT, identityBindings);
        if (this.identityBinding != null) {
            this.identityBinding.setParent(this);
        }
    }

    public void doLoad(Widget frmModel, JXPathContext jxpc) throws BindingException {
        Repeater repeater = (Repeater)this.selectWidget(frmModel, this.repeaterId);
        if (repeater == null) {
            throw new BindingException("The repeater with the ID [" + this.repeaterId + "] referenced in the binding does not exist in the form definition.");
        }
        repeater.removeRows();
        int initialSize = repeater.getSize();
        JXPathContext repeaterContext = jxpc.getRelativeContext(jxpc.getPointer(this.repeaterPath));
        Iterator rowPointers = repeaterContext.iteratePointers(this.rowPath);
        while (rowPointers.hasNext()) {
            Repeater.RepeaterRow thisRow = initialSize > 0 ? repeater.getRow(--initialSize) : repeater.addRow();
            Pointer jxp = (Pointer)rowPointers.next();
            JXPathContext rowContext = repeaterContext.getRelativeContext(jxp);
            this.identityBinding.loadFormFromModel((Widget)thisRow, rowContext);
            this.rowBinding.loadFormFromModel((Widget)thisRow, rowContext);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("done loading rows " + this.toString());
        }
    }

    public void doSave(Widget frmModel, JXPathContext jxpc) throws BindingException {
        Repeater repeater = (Repeater)this.selectWidget(frmModel, this.repeaterId);
        JXPathContext repeaterContext = jxpc.getRelativeContext(jxpc.getPointer(this.repeaterPath));
        HashSet<List> updatedRows = new HashSet<List>();
        ArrayList<Repeater.RepeaterRow> rowsToInsert = new ArrayList<Repeater.RepeaterRow>();
        int formRowCount = repeater.getSize();
        int i = 0;
        while (i < formRowCount) {
            Repeater.RepeaterRow thisRow = repeater.getRow(i);
            List identity = this.getIdentity(thisRow);
            if (this.hasNonNullElements(identity)) {
                Iterator rowPointers = repeaterContext.iteratePointers(this.rowPath);
                boolean found = false;
                while (rowPointers.hasNext()) {
                    Pointer jxp = (Pointer)rowPointers.next();
                    JXPathContext rowContext = repeaterContext.getRelativeContext(jxp);
                    List contextIdentity = this.getIdentity(rowContext);
                    if (!ListUtils.isEqualList((Collection)identity, (Collection)contextIdentity)) continue;
                    this.rowBinding.saveFormToModel((Widget)thisRow, rowContext);
                    updatedRows.add(identity);
                    found = true;
                    break;
                }
                if (!found) {
                    rowsToInsert.add(thisRow);
                    updatedRows.add(identity);
                }
            } else {
                rowsToInsert.add(thisRow);
            }
            ++i;
        }
        Iterator rowPointers = repeaterContext.iteratePointers(this.rowPath);
        ArrayList<JXPathContext> rowsToDelete = new ArrayList<JXPathContext>();
        while (rowPointers.hasNext()) {
            Pointer jxp = (Pointer)rowPointers.next();
            JXPathContext rowContext = repeaterContext.getRelativeContext((Pointer)jxp.clone());
            List contextIdentity = this.getIdentity(rowContext);
            if (this.isIdentityInUpdatedRows(updatedRows, contextIdentity)) continue;
            rowsToDelete.add(rowContext);
        }
        if (rowsToDelete.size() > 0) {
            if (this.deleteRowBinding != null) {
                int i2 = rowsToDelete.size() - 1;
                while (i2 >= 0) {
                    this.deleteRowBinding.saveFormToModel(frmModel, rowsToDelete.get(i2));
                    --i2;
                }
            } else if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("RepeaterBinding has detected rows to delete, but misses the <on-delete-row> binding to do it.");
            }
        }
        int indexCount = 1;
        rowPointers = repeaterContext.iteratePointers(this.rowPathForInsert);
        while (rowPointers.hasNext()) {
            rowPointers.next();
            ++indexCount;
        }
        if (rowsToInsert.size() > 0) {
            if (this.insertRowBinding != null) {
                Iterator rowIterator = rowsToInsert.iterator();
                while (rowIterator.hasNext()) {
                    Repeater.RepeaterRow thisRow = (Repeater.RepeaterRow)rowIterator.next();
                    this.insertRowBinding.saveFormToModel((Widget)repeater, repeaterContext);
                    Pointer newRowContextPointer = repeaterContext.createPath(this.rowPathForInsert + "[" + indexCount + "]");
                    JXPathContext newRowContext = repeaterContext.getRelativeContext(newRowContextPointer);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("inserted row at " + newRowContextPointer.asPath());
                    }
                    this.rowBinding.saveFormToModel((Widget)thisRow, newRowContext);
                    this.getLogger().debug("bound new row");
                    ++indexCount;
                }
            } else if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("RepeaterBinding has detected rows to insert, but misses the <on-insert-row> binding to do it.");
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("done saving rows " + this.toString());
        }
    }

    private boolean isIdentityInUpdatedRows(Set identitySet, List identity) {
        Iterator iter = identitySet.iterator();
        while (iter.hasNext()) {
            List identityFromSet = (List)iter.next();
            if (!ListUtils.isEqualList((Collection)identityFromSet, (Collection)identity)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNonNullElements(List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (iter.next() == null) continue;
            return true;
        }
        return false;
    }

    private List getIdentity(JXPathContext rowContext) {
        ArrayList<Object> identity = new ArrayList<Object>();
        JXPathBindingBase[] childBindings = this.identityBinding.getChildBindings();
        if (childBindings != null) {
            int size = childBindings.length;
            int i = 0;
            while (i < size) {
                ValueJXPathBinding vBinding = (ValueJXPathBinding)childBindings[i];
                Object value = rowContext.getValue(vBinding.getXPath());
                if (value != null && vBinding.getConvertor() != null) {
                    if (value instanceof String) {
                        ConversionResult conversionResult = vBinding.getConvertor().convertFromString((String)value, vBinding.getConvertorLocale(), null);
                        value = conversionResult.isSuccessful() ? conversionResult.getResult() : null;
                    } else if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("Convertor ignored on backend-value which isn't of type String.");
                    }
                }
                identity.add(value);
                ++i;
            }
        }
        return identity;
    }

    private List getIdentity(Repeater.RepeaterRow row) {
        ArrayList<Object> identity = new ArrayList<Object>();
        JXPathBindingBase[] childBindings = this.identityBinding.getChildBindings();
        if (childBindings != null) {
            int size = childBindings.length;
            int i = 0;
            while (i < size) {
                String fieldId = ((ValueJXPathBinding)childBindings[i]).getFieldId();
                Widget widget = row.getChild(fieldId);
                Object value = widget.getValue();
                identity.add(value);
                ++i;
            }
        }
        return identity;
    }

    public String toString() {
        return "RepeaterJXPathBinding [widget=" + this.repeaterId + ", xpath=" + this.repeaterPath + "]";
    }

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        if (this.deleteRowBinding != null) {
            this.deleteRowBinding.enableLogging(logger);
        }
        if (this.insertRowBinding != null) {
            this.insertRowBinding.enableLogging(logger);
        }
        this.rowBinding.enableLogging(logger);
        if (this.identityBinding != null) {
            this.identityBinding.enableLogging(logger);
        }
    }
}

