/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.xscript;

import java.util.Stack;
import org.apache.cocoon.components.xscript.NPU;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StringBufferContentHandler
extends DefaultHandler {
    private static Object marker = new Object();
    private Stack namespaces = new Stack();
    private StringBuffer stringBuffer;

    public StringBufferContentHandler(StringBuffer stringBuffer) {
        this.stringBuffer = stringBuffer;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.push(new NPU(prefix, uri));
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaces.pop();
    }

    public void startElement(String uri, String loc, String qName, Attributes a) throws SAXException {
        int i;
        int lastNamespaceIndex = 0;
        for (lastNamespaceIndex = this.namespaces.size() - 1; lastNamespaceIndex >= 0 && this.namespaces.elementAt(lastNamespaceIndex) != marker; --lastNamespaceIndex) {
        }
        if (lastNamespaceIndex < 0) {
            lastNamespaceIndex = 0;
        } else if (this.namespaces.elementAt(lastNamespaceIndex) == marker) {
            ++lastNamespaceIndex;
        }
        this.namespaces.push(marker);
        this.stringBuffer.append("<").append(qName);
        int len = a.getLength();
        for (i = 0; i < len; ++i) {
            String attrName = a.getQName(i);
            if (attrName.startsWith("xmlns:")) {
                String name = a.getLocalName(i);
                boolean found = false;
                for (int j = this.namespaces.size() - 1; j >= lastNamespaceIndex; --j) {
                    Object obj = this.namespaces.elementAt(j);
                    if (obj == marker) continue;
                    NPU npu = (NPU)obj;
                    if (!name.equals(npu.prefix)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.namespaces.push(new NPU(name, a.getValue(i)));
                continue;
            }
            this.stringBuffer.append(" ").append(a.getQName(i)).append("=\"");
            StringBufferContentHandler.escape(this.stringBuffer, a.getValue(i));
            this.stringBuffer.append("\"");
        }
        if (this.namespaces.size() != 0) {
            for (i = this.namespaces.size() - 1; i >= lastNamespaceIndex; --i) {
                Object obj = this.namespaces.elementAt(i);
                if (obj == marker) continue;
                NPU npu = (NPU)obj;
                if ("".equals(npu.prefix)) {
                    this.stringBuffer.append(" xmlns").append("=\"").append(npu.uri).append("\"");
                    continue;
                }
                this.stringBuffer.append(" xmlns:").append(npu.prefix).append("=\"").append(npu.uri).append("\"");
            }
        }
        this.stringBuffer.append(">");
    }

    public void endElement(String uri, String loc, String qName) throws SAXException {
        Object obj;
        this.stringBuffer.append("</").append(qName).append(">");
        while ((obj = this.namespaces.pop()) != marker) {
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        StringBufferContentHandler.escape(this.stringBuffer, ch, start, len);
    }

    private static void escape(StringBuffer buffer, String s) {
        char[] ch = s.toCharArray();
        StringBufferContentHandler.escape(buffer, ch, 0, ch.length);
    }

    private static void escape(StringBuffer buffer, char[] ch, int start, int len) {
        block5: for (int i = start; i < start + len; ++i) {
            switch (ch[i]) {
                case '<': {
                    buffer.append("&lt;");
                    continue block5;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block5;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block5;
                }
                default: {
                    buffer.append(ch[i]);
                }
            }
        }
    }
}

