/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.extended;

import net.sourceforge.chaperon.model.extended.Pattern;
import net.sourceforge.chaperon.model.extended.PatternIterator;
import net.sourceforge.chaperon.model.extended.PatternSet;

public abstract class PatternList
extends Pattern {
    private PatternListEntry first = null;
    private PatternListEntry last = null;
    private int count = 0;

    public void addPattern(Pattern pattern) {
        this.last = this.first == null ? (this.first = new PatternListEntry(pattern, null)) : (this.last.next = new PatternListEntry(pattern, this.last));
        ++this.count;
    }

    public Pattern getPattern(int index) {
        int i = 0;
        PatternListEntry entry = this.first;
        while (entry != null) {
            if (i == index) {
                return entry.pattern;
            }
            entry = entry.next;
            ++i;
        }
        return null;
    }

    public PatternIterator getPattern() {
        return new PatternListEntryIterator(this.first);
    }

    public Pattern[] getPatternAsArray() {
        Pattern[] pattern = new Pattern[this.count];
        int i = 0;
        PatternListEntry entry = this.first;
        while (entry != null) {
            pattern[i] = entry.pattern;
            entry = entry.next;
            ++i;
        }
        return pattern;
    }

    public int getPatternCount() {
        return this.count;
    }

    public void update() {
        super.update();
        PatternListEntry entry = this.first;
        while (entry != null) {
            entry.pattern.update();
            entry = entry.next;
        }
        boolean nullable = true;
        PatternListEntry entry2 = this.first;
        while (entry2 != null) {
            nullable &= entry2.pattern.isNullable();
            entry2 = entry2.next;
        }
        this.setNullable(nullable);
        PatternListEntry entry3 = this.first;
        while (entry3 != null) {
            PatternIterator firstPattern = entry3.pattern.getFirstPattern();
            while (firstPattern.hasNext()) {
                this.addFirstPattern(firstPattern.next());
            }
            if (!entry3.pattern.isNullable()) break;
            entry3 = entry3.next;
        }
        PatternListEntry entry4 = this.last;
        while (entry4 != null) {
            PatternIterator lastPattern = entry4.pattern.getLastPattern();
            while (lastPattern.hasNext()) {
                this.addLastPattern(lastPattern.next());
            }
            if (!entry4.pattern.isNullable()) break;
            entry4 = entry4.previous;
        }
        PatternListEntry entry5 = this.first;
        while (entry5 != null) {
            PatternListEntry entry22 = entry5.next;
            while (entry22 != null) {
                PatternIterator i = entry5.pattern.getLastPattern();
                while (i.hasNext()) {
                    Pattern lastPattern = i.next();
                    PatternIterator j = entry22.pattern.getFirstPattern();
                    while (j.hasNext()) {
                        Pattern firstPattern = j.next();
                        lastPattern.addSuccessor(firstPattern);
                    }
                }
                if (!entry22.pattern.isNullable()) break;
                entry22 = entry22.next;
            }
            entry5 = entry5.next;
        }
    }

    public PatternSet getAllPattern() {
        PatternSet set = new PatternSet();
        set.addPattern(this);
        PatternListEntry entry = this.first;
        while (entry != null) {
            set.addPattern(entry.pattern.getAllPattern());
            entry = entry.next;
        }
        return set;
    }

    public char[] getLimits() {
        return new char[0];
    }

    public boolean contains(char minimum, char maximum) {
        return false;
    }

    public boolean contains(char c) {
        return false;
    }

    public String getSymbol() {
        return null;
    }

    public String toString() {
        return this.toString(null, null);
    }

    public String toString(PatternSet previous, PatternSet next) {
        StringBuffer buffer = new StringBuffer();
        if (previous != null && previous.contains(this)) {
            if (next != null && next.contains(this)) {
                buffer.append("." + this.toString() + ".");
            } else {
                buffer.append(this.toString() + ".");
            }
        } else if (next != null && next.contains(this)) {
            buffer.append("." + this.toString());
        }
        if (this.count > 1) {
            buffer.append("(");
            PatternListEntry entry = this.first;
            while (entry != null) {
                if (entry != this.first) {
                    buffer.append(" ");
                }
                buffer.append(entry.pattern.toString(previous, next));
                entry = entry.next;
            }
            buffer.append(")");
        } else if (this.count == 1) {
            buffer.append(this.first.pattern.toString(previous, next));
        }
        return buffer.toString();
    }

    private class PatternListEntryIterator
    implements PatternIterator {
        private PatternListEntry entry;

        private PatternListEntryIterator(PatternListEntry entry) {
            this.entry = entry;
        }

        public boolean hasNext() {
            return this.entry != null;
        }

        public Pattern next() {
            Pattern pattern = this.entry.pattern;
            this.entry = this.entry.next;
            return pattern;
        }
    }

    private class PatternListEntry {
        public final Pattern pattern;
        public PatternListEntry previous = null;
        public PatternListEntry next = null;

        private PatternListEntry(Pattern pattern, PatternListEntry previous) {
            this.pattern = pattern;
            this.previous = previous;
        }
    }
}

