/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.lexicon;

import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.pattern.Pattern;
import net.sourceforge.chaperon.model.symbol.Symbol;
import net.sourceforge.chaperon.model.symbol.Terminal;

public class Lexeme {
    private Symbol symbol = null;
    private Pattern definition = null;
    private String location = null;

    public Lexeme() {
    }

    public Lexeme(Symbol symbol) {
        this.setSymbol(symbol);
    }

    public void setSymbol(Symbol symbol) {
        this.symbol = symbol;
    }

    public void setSymbolName(String name) {
        this.symbol = name != null && name.length() > 0 ? new Terminal(name) : null;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public String getSymbolName() {
        if (this.symbol != null) {
            return this.symbol.getName();
        }
        return null;
    }

    public void setDefinition(Pattern definition) {
        this.definition = definition;
    }

    public Pattern getDefinition() {
        return this.definition;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public Violations validate() {
        Violations violations = new Violations();
        if (this.definition == null) {
            if (this.symbol != null) {
                violations.addViolation("Lexeme " + this.symbol + " contains no definition", this.location);
            } else {
                violations.addViolation("Lexeme contains no definition", this.location);
            }
        }
        if (this.symbol != null && this.symbol.getName().equals("error")) {
            violations.addViolation("Symbol with name \"error\" is not allowed", this.location);
        }
        return violations;
    }

    public String toString() {
        if (this.symbol != null) {
            return this.symbol.toString() + " : \"" + this.definition + "\"";
        }
        return "/* noname */ : \"" + this.definition + "\"";
    }

    public Object clone() throws CloneNotSupportedException {
        Lexeme clone = new Lexeme();
        clone.symbol = this.symbol;
        if (this.definition != null) {
            clone.definition = (Pattern)this.definition.clone();
        }
        clone.location = this.location;
        return clone;
    }
}

