/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.serializers;

import org.apache.cocoon.components.serializers.XHTMLSerializer;
import org.apache.cocoon.components.serializers.encoding.HTMLEncoder;
import org.apache.cocoon.components.serializers.util.DocType;
import org.apache.cocoon.components.serializers.util.SGMLDocType;
import org.xml.sax.SAXException;

public class HTMLSerializer
extends XHTMLSerializer {
    public static final DocType HTML401_DOCTYPE_COMPATIBLE = new SGMLDocType("HTML", "-//W3C//DTD HTML 4.01 Transitional//EN", null);
    public static final DocType HTML401_DOCTYPE_STRICT = new SGMLDocType("HTML", "-//W3C//DTD HTML 4.01//EN", "http://www.w3.org/TR/html4/strict.dtd");
    public static final DocType HTML401_DOCTYPE_TRANSITIONAL = new SGMLDocType("HTML", "-//W3C//DTD HTML 4.01 Transitional//EN", "http://www.w3.org/TR/html4/loose.dtd");
    public static final DocType HTML401_DOCTYPE_FRAMESET = new SGMLDocType("HTML", "-//W3C//DTD HTML 4.01 Frameset//EN", "http://www.w3.org/TR/html4/frameset.dtd");
    private static final HTMLEncoder HTML_ENCODER = new HTMLEncoder();
    private static final String[][] NAMESPACES = new String[0][0];

    public HTMLSerializer() {
        super(HTML_ENCODER);
    }

    private boolean checkNamespace(String nsuri) {
        if (nsuri.length() == 0) {
            return true;
        }
        return "http://www.w3.org/1999/xhtml".equals(nsuri);
    }

    public void head() throws SAXException {
    }

    public void body(String nsuri, String local, String qual) throws SAXException {
        String name = local.toUpperCase();
        if (!this.checkNamespace(nsuri)) {
            throw new SAXException("Unsupported namespace \"" + nsuri + "\" " + "for HTML root element \"" + qual + "\"" + this.getLocation());
        }
        this.doctype = this.doctype == null ? HTML401_DOCTYPE_COMPATIBLE : (XHTMLSerializer.XHTML1_DOCTYPE_STRICT.equals(this.doctype) ? HTML401_DOCTYPE_STRICT : (XHTMLSerializer.XHTML1_DOCTYPE_TRANSITIONAL.equals(this.doctype) ? HTML401_DOCTYPE_TRANSITIONAL : (XHTMLSerializer.XHTML1_DOCTYPE_FRAMESET.equals(this.doctype) ? HTML401_DOCTYPE_FRAMESET : new DocType(this.doctype.getName().toUpperCase(), this.doctype.getPublicId(), this.doctype.getSystemId()))));
        super.body("http://www.w3.org/1999/xhtml", name, name);
    }

    public void startElementImpl(String nsuri, String local, String qual, String[][] namespaces, String[][] attributes) throws SAXException {
        String name = local.toUpperCase();
        if (!this.checkNamespace(nsuri)) {
            throw new SAXException("Unsupported namespace \"" + nsuri + "\" " + "for HTML element \"" + qual + "\"" + this.getLocation());
        }
        int length = 0;
        int x = 0;
        while (x < attributes.length) {
            if (this.checkNamespace(attributes[x][0])) {
                ++length;
            }
            ++x;
        }
        String[][] at = new String[length][4];
        length = 0;
        int x2 = 0;
        while (x2 < attributes.length) {
            if (this.checkNamespace(attributes[x2][0])) {
                String at_name = attributes[x2][1].toLowerCase();
                at[length][0] = "http://www.w3.org/1999/xhtml";
                at[length][1] = at_name;
                at[length][2] = at_name;
                at[length][3] = attributes[x2][3];
                ++length;
            }
            ++x2;
        }
        super.startElementImpl("http://www.w3.org/1999/xhtml", name, name, NAMESPACES, at);
    }

    public void endElementImpl(String nsuri, String local, String qual) throws SAXException {
        this.closeElement(false);
        String name = local.toUpperCase();
        if (!this.checkNamespace(nsuri)) {
            throw new SAXException("Unsupported namespace \"" + nsuri + "\" " + "for HTML element \"" + qual + "\"" + this.getLocation());
        }
        if (name.equals("AREA")) {
            return;
        }
        if (name.equals("BASE")) {
            return;
        }
        if (name.equals("BASEFONT")) {
            return;
        }
        if (name.equals("BR")) {
            return;
        }
        if (name.equals("COL")) {
            return;
        }
        if (name.equals("FRAME")) {
            return;
        }
        if (name.equals("HR")) {
            return;
        }
        if (name.equals("IMG")) {
            return;
        }
        if (name.equals("INPUT")) {
            return;
        }
        if (name.equals("ISINDEX")) {
            return;
        }
        if (name.equals("LINK")) {
            return;
        }
        if (name.equals("META")) {
            return;
        }
        if (name.equals("PARAM")) {
            return;
        }
        super.endElementImpl("http://www.w3.org/1999/xhtml", name, name);
    }
}

