/*
 * Decompiled with CFR 0.152.
 */
package org.tempuri.javacImpl.eclipse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.tempuri.javac.JavaClassReader;
import org.tempuri.javac.JavaClassReaderFactory;
import org.tempuri.javac.JavaClassWriter;
import org.tempuri.javac.JavaClassWriterFactory;
import org.tempuri.javac.JavaCompiler;
import org.tempuri.javac.JavaCompilerErrorHandler;
import org.tempuri.javac.JavaSourceReader;
import org.tempuri.javac.JavaSourceReaderFactory;

public class JavaCompilerImpl
implements JavaCompiler {
    boolean target14 = false;
    boolean source14 = false;
    boolean debug = true;
    String sourceEncoding;
    static final String[] versions = new String[]{"1.1", "1.2", "1.3"};

    static void checkVersion(String version, String errorMessage) throws IllegalArgumentException {
        int i = 0;
        while (i < versions.length) {
            if (versions[i].equals(version)) {
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException(errorMessage);
    }

    public void setTargetVersion(String targetVersion) throws IllegalArgumentException {
        if (targetVersion.equals("1.4")) {
            this.target14 = true;
        } else {
            JavaCompilerImpl.checkVersion(targetVersion, "illegal target release: " + targetVersion);
            this.target14 = false;
        }
    }

    public void setSourceEncoding(String encoding) {
        this.sourceEncoding = encoding;
    }

    public void setDebug(boolean value) {
        this.debug = true;
    }

    public void setSourceVersion(String sourceVersion) throws IllegalArgumentException {
        if (sourceVersion.equals("1.4")) {
            this.source14 = true;
        } else {
            JavaCompilerImpl.checkVersion(sourceVersion, "illegal source release: " + sourceVersion);
            this.source14 = false;
        }
    }

    public static String makeClassName(String name) {
        if (name.endsWith(".java")) {
            name = name.substring(0, name.length() - 5);
        } else if (name.endsWith(".class")) {
            name = name.substring(0, name.length() - 6);
        }
        name = name.replace('\\', '.');
        name = name.replace('/', '.');
        return name;
    }

    public void compile(String[] classNames, final JavaSourceReaderFactory sourceReaderFactory, final JavaClassReaderFactory classReaderFactory, final JavaClassWriterFactory classWriterFactory, final JavaCompilerErrorHandler errorHandler) {
        INameEnvironment env = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                String result = "";
                String sep = "";
                int i = 0;
                while (i < compoundTypeName.length) {
                    result = result + sep;
                    result = result + new String(compoundTypeName[i]);
                    sep = ".";
                    ++i;
                }
                return this.findType(result);
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                String result = "";
                String sep = "";
                int i = 0;
                while (i < packageName.length) {
                    result = result + sep;
                    result = result + new String(packageName[i]);
                    sep = ".";
                    ++i;
                }
                result = result + sep;
                result = result + new String(typeName);
                return this.findType(result);
            }

            /*
             * WARNING - void declaration
             */
            private NameEnvironmentAnswer findType(String className) {
                try {
                    JavaSourceReader sourceReader = sourceReaderFactory.getSourceReader(className);
                    if (sourceReader != null) {
                        class CompilationUnit
                        implements ICompilationUnit {
                            String className;
                            private final /* synthetic */ JavaSourceReaderFactory val$sourceReaderFactory;
                            private final /* synthetic */ JavaCompilerErrorHandler val$errorHandler;

                            CompilationUnit(JavaSourceReaderFactory val$sourceReaderFactory, JavaCompilerErrorHandler val$errorHandler, String className) {
                                this.val$sourceReaderFactory = val$sourceReaderFactory;
                                this.val$errorHandler = val$errorHandler;
                                this.className = className;
                            }

                            public char[] getFileName() {
                                return this.className.toCharArray();
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public char[] getContents() {
                                char[] result = null;
                                try {
                                    JavaSourceReader sourceReader = this.val$sourceReaderFactory.getSourceReader(this.className);
                                    if (sourceReader == null) {
                                        return null;
                                    }
                                    Reader reader = sourceReader.getReader();
                                    if (reader != null) {
                                        int count;
                                        char[] chars = new char[8192];
                                        StringBuffer buf = new StringBuffer();
                                        while ((count = reader.read(chars, 0, chars.length)) > 0) {
                                            void var6_7;
                                            buf.append(chars, 0, (int)var6_7);
                                        }
                                        result = new char[buf.length()];
                                        buf.getChars(0, result.length, result, 0);
                                    }
                                }
                                catch (IOException e) {
                                    this.val$errorHandler.handleError(this.className, -1, -1, (Object)e.getMessage());
                                }
                                return result;
                            }

                            public char[] getMainTypeName() {
                                int dot = this.className.lastIndexOf(46);
                                if (dot > 0) {
                                    return this.className.substring(dot + 1).toCharArray();
                                }
                                return this.className.toCharArray();
                            }

                            public char[][] getPackageName() {
                                StringTokenizer izer = new StringTokenizer(this.className, ".");
                                char[][] result = new char[izer.countTokens() - 1][];
                                int i = 0;
                                while (i < result.length) {
                                    String tok = izer.nextToken();
                                    result[i] = tok.toCharArray();
                                    ++i;
                                }
                                return result;
                            }
                        }
                        CompilationUnit compilationUnit = new CompilationUnit(sourceReaderFactory, errorHandler, className);
                        return new NameEnvironmentAnswer((ICompilationUnit)compilationUnit);
                    }
                    JavaClassReader classReader = classReaderFactory.getClassReader(className);
                    if (classReader != null) {
                        int count;
                        byte[] buf = new byte[8192];
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(buf.length);
                        InputStream is = classReader.getInputStream();
                        while ((count = is.read(buf, 0, buf.length)) > 0) {
                            void var7_10;
                            baos.write(buf, 0, (int)var7_10);
                        }
                        baos.flush();
                        byte[] classBytes = baos.toByteArray();
                        char[] fileName = classReader.getClassName().toCharArray();
                        ClassFileReader classFileReader = new ClassFileReader(classBytes, fileName, true);
                        return new NameEnvironmentAnswer((IBinaryType)classFileReader);
                    }
                }
                catch (IOException exc) {
                    errorHandler.handleError(className, -1, -1, (Object)exc.getMessage());
                }
                catch (ClassFormatException exc) {
                    errorHandler.handleError(className, -1, -1, (Object)exc.getMessage());
                }
                return null;
            }

            private boolean isPackage(String result) {
                JavaClassReader classReader = null;
                try {
                    classReader = classReaderFactory.getClassReader(result);
                }
                catch (IOException exc) {
                    errorHandler.handleError(result, -1, -1, (Object)exc.getMessage());
                }
                if (classReader == null) {
                    JavaSourceReader sourceReader = null;
                    try {
                        sourceReader = sourceReaderFactory.getSourceReader(result);
                    }
                    catch (IOException exc) {
                        errorHandler.handleError(result, -1, -1, (Object)exc.getMessage());
                    }
                    if (sourceReader == null) {
                        return true;
                    }
                }
                return false;
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                String str;
                String result = "";
                String sep = "";
                if (parentPackageName != null) {
                    int i = 0;
                    while (i < parentPackageName.length) {
                        result = result + sep;
                        String str2 = new String(parentPackageName[i]);
                        result = result + str2;
                        sep = ".";
                        ++i;
                    }
                }
                if (Character.isUpperCase((str = new String(packageName)).charAt(0)) && !this.isPackage(result)) {
                    return false;
                }
                result = result + sep;
                result = result + str;
                return this.isPackage(result);
            }

            public void cleanup() {
            }
        };
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        if (this.sourceEncoding != null) {
            settings.put("org.eclipse.jdt.core.encoding", this.sourceEncoding);
        }
        if (this.debug) {
            settings.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        }
        if (this.source14) {
            settings.put("org.eclipse.jdt.core.compiler.source", "1.4");
        }
        if (this.target14) {
            settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
        }
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        ICompilerRequestor requestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                try {
                    if (result.hasProblems()) {
                        IProblem[] problems = result.getProblems();
                        int i = 0;
                        while (i < problems.length) {
                            IProblem problem = problems[i];
                            String name = new String(problems[i].getOriginatingFileName());
                            errorHandler.handleError(name, problem.getSourceLineNumber(), -1, (Object)problem.getMessage());
                            ++i;
                        }
                    } else {
                        ClassFile[] classFiles = result.getClassFiles();
                        int i = 0;
                        while (i < classFiles.length) {
                            ClassFile classFile = classFiles[i];
                            char[][] compoundName = classFile.getCompoundName();
                            String className = "";
                            String sep = "";
                            int j = 0;
                            while (j < compoundName.length) {
                                className = className + sep;
                                className = className + new String(compoundName[j]);
                                sep = ".";
                                ++j;
                            }
                            JavaClassWriter writer = classWriterFactory.getClassWriter(className);
                            byte[] bytes = classFile.getBytes();
                            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                            writer.writeClass((InputStream)bais);
                            ++i;
                        }
                    }
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                }
            }
        };
        ICompilationUnit[] compilationUnits = new ICompilationUnit[classNames.length];
        int i = 0;
        while (i < compilationUnits.length) {
            String className = classNames[i];
            compilationUnits[i] = new CompilationUnit(sourceReaderFactory, errorHandler, className);
            ++i;
        }
        Compiler compiler = new Compiler(env, policy, settings, requestor, (IProblemFactory)problemFactory);
        compiler.compile(compilationUnits);
    }
}

