/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.NegateExpression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.SequenceIterable;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class ArithmeticExpression10
extends BinaryExpression {
    private Calculator calculator;

    public ArithmeticExpression10(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public boolean isBackwardsCompatible() {
        return true;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        if (Literal.isEmptySequence(this.operand0)) {
            return new Literal(DoubleValue.NaN);
        }
        if (Literal.isEmptySequence(this.operand1)) {
            return new Literal(DoubleValue.NaN);
        }
        Expression expression = this.operand0;
        Expression expression2 = this.operand1;
        this.operand0 = this.operand0.typeCheck(staticContext, itemType);
        this.operand1 = this.operand1.typeCheck(staticContext, itemType);
        SequenceType sequenceType = SequenceType.OPTIONAL_ATOMIC;
        RoleLocator roleLocator = new RoleLocator(1, Token.tokens[this.operator], 0, null);
        roleLocator.setSourceLocator(this);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, sequenceType, true, roleLocator, staticContext);
        ItemType itemType2 = this.operand0.getItemType(typeHierarchy);
        if (itemType2 instanceof EmptySequenceTest) {
            return Literal.makeLiteral(DoubleValue.NaN);
        }
        AtomicType atomicType = (AtomicType)itemType2.getPrimitiveItemType();
        this.operand0 = this.createConversionCode(this.operand0, typeHierarchy, atomicType, staticContext);
        atomicType = (AtomicType)this.operand0.getItemType(typeHierarchy).getPrimitiveItemType();
        RoleLocator roleLocator2 = new RoleLocator(1, Token.tokens[this.operator], 1, null);
        roleLocator2.setSourceLocator(this);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, sequenceType, true, roleLocator2, staticContext);
        ItemType itemType3 = this.operand1.getItemType(typeHierarchy);
        if (itemType3 instanceof EmptySequenceTest) {
            return Literal.makeLiteral(DoubleValue.NaN);
        }
        AtomicType atomicType2 = (AtomicType)itemType3.getPrimitiveItemType();
        this.operand1 = this.createConversionCode(this.operand1, typeHierarchy, atomicType2, staticContext);
        atomicType2 = (AtomicType)this.operand1.getItemType(typeHierarchy).getPrimitiveItemType();
        if (this.operand0 != expression) {
            this.adoptChildExpression(this.operand0);
        }
        if (this.operand1 != expression2) {
            this.adoptChildExpression(this.operand1);
        }
        if (this.operator == 199) {
            SequenceIterable sequenceIterable;
            if (this.operand1 instanceof Literal && (sequenceIterable = ((Literal)this.operand1).getValue()) instanceof NumericValue) {
                return Literal.makeLiteral(((NumericValue)sequenceIterable).negate());
            }
            sequenceIterable = new NegateExpression(this.operand1);
            ((NegateExpression)sequenceIterable).setBackwardsCompatible(false);
            return ((NegateExpression)sequenceIterable).typeCheck(staticContext, itemType);
        }
        boolean bl = !atomicType.equals(BuiltInAtomicType.ANY_ATOMIC) && !atomicType2.equals(BuiltInAtomicType.ANY_ATOMIC);
        this.calculator = Calculator.getCalculator(atomicType.getFingerprint(), atomicType2.getFingerprint(), ArithmeticExpression.mapOpCode(this.operator), bl);
        if (this.calculator == null) {
            DynamicError dynamicError = new DynamicError("Arithmetic operator is not defined for arguments of types (" + atomicType.getDescription() + ", " + atomicType2.getDescription() + ")");
            dynamicError.setLocator(this);
            dynamicError.setErrorCode("XPTY0004");
            throw dynamicError;
        }
        try {
            if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
                return Literal.makeLiteral(Value.asValue(this.evaluateItem(staticContext.makeEarlyEvaluationContext())));
            }
        }
        catch (DynamicError dynamicError) {
            // empty catch block
        }
        return this;
    }

    private Expression createConversionCode(Expression expression, TypeHierarchy typeHierarchy, AtomicType atomicType, StaticContext staticContext) {
        Expression expression2;
        if (Cardinality.allowsMany(expression.getCardinality())) {
            expression2 = new FirstItemExpression(expression);
            expression2.setParentExpression(this);
            expression = expression2;
        }
        if (!typeHierarchy.isSubType(atomicType, BuiltInAtomicType.DOUBLE)) {
            expression2 = (NumberFn)SystemFunction.makeSystemFunction("number", 1, staticContext.getNamePool());
            expression2.setParentExpression(expression.getParentExpression());
            Expression[] expressionArray = new Expression[]{expression};
            ((FunctionCall)expression2).setArguments(expressionArray);
            expression = expression2;
        }
        return expression;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        ItemType itemType;
        if (this.calculator == null) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        ItemType itemType2 = this.operand0.getItemType(typeHierarchy);
        if (!(itemType2 instanceof AtomicType)) {
            itemType2 = itemType2.getAtomizedItemType();
        }
        if (!((itemType = this.operand1.getItemType(typeHierarchy)) instanceof AtomicType)) {
            itemType = itemType.getAtomizedItemType();
        }
        return this.calculator.getResultType((AtomicType)itemType2.getPrimitiveItemType(), (AtomicType)itemType.getPrimitiveItemType());
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.operand0.evaluateItem(xPathContext);
        if (atomicValue == null) {
            return DoubleValue.NaN;
        }
        AtomicValue atomicValue2 = (AtomicValue)this.operand1.evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            return DoubleValue.NaN;
        }
        return this.calculator.compute(atomicValue, atomicValue2, xPathContext);
    }
}

