/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterIterator;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PositionIterator;
import net.sf.saxon.expr.PositionRange;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.SequenceIterable;
import net.sf.saxon.expr.SliceExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Last;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.Value;

public final class FilterExpression
extends Expression {
    private Expression start;
    private Expression filter;
    private boolean filterIsPositional;
    private boolean filterIsSingletonBoolean;
    private boolean filterIsIndependentNumeric;

    public FilterExpression(Expression expression, Expression expression2) {
        this.start = expression;
        this.filter = expression2;
        this.adoptChildExpression(expression);
        this.adoptChildExpression(expression2);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.start.getItemType(typeHierarchy);
    }

    public Expression getBaseExpression() {
        return this.start;
    }

    public Expression getFilter() {
        return this.filter;
    }

    public boolean isPositional(TypeHierarchy typeHierarchy) {
        return FilterExpression.isPositionalFilter(this.filter, typeHierarchy);
    }

    public boolean isSimpleBooleanFilter() {
        return this.filterIsSingletonBoolean;
    }

    public boolean isIndependentNumericFilter() {
        return this.filterIsIndependentNumeric;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.start = this.start.simplify(staticContext);
        this.filter = this.filter.simplify(staticContext);
        if (Literal.isEmptySequence(this.start)) {
            return this.start;
        }
        if (this.filter instanceof Literal && !(((Literal)this.filter).getValue() instanceof NumericValue)) {
            try {
                if (this.filter.effectiveBooleanValue(staticContext.makeEarlyEvaluationContext())) {
                    Expression.setParentExpression(this.start, this.getParentExpression());
                    return this.start;
                }
                return new Literal(EmptySequence.getInstance());
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw StaticError.makeStaticError(xPathException);
            }
        }
        if (this.filter instanceof Last) {
            this.filter = new IsLastExpression(true);
            this.adoptChildExpression(this.filter);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        SequenceIterable sequenceIterable;
        Expression expression;
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        Expression expression2 = this.start.typeCheck(staticContext, itemType);
        if (expression2 != this.start) {
            this.start = expression2;
            this.adoptChildExpression(expression2);
        }
        if ((expression = this.filter.typeCheck(staticContext, this.start.getItemType(typeHierarchy))) != this.filter) {
            this.filter = expression;
            this.adoptChildExpression(expression);
        }
        if ((expression = ExpressionTool.unsortedIfHomogeneous(staticContext.getConfiguration().getOptimizer(), this.filter, false)) != this.filter) {
            this.filter = expression;
            this.adoptChildExpression(expression);
        }
        if (Literal.isConstantOne(this.filter)) {
            FirstItemExpression firstItemExpression = new FirstItemExpression(this.start);
            firstItemExpression.setParentExpression(this.getParentExpression());
            firstItemExpression.setLocationId(this.getLocationId());
            return firstItemExpression;
        }
        if (this.filter instanceof Literal) {
            sequenceIterable = ((Literal)this.filter).getValue();
            if (sequenceIterable instanceof NumericValue) {
                if (!((NumericValue)sequenceIterable).isWholeNumber() || ((NumericValue)sequenceIterable).compareTo(0L) <= 0) return new Literal(EmptySequence.getInstance());
                this.filter = new PositionRange(this.filter, this.filter);
            } else {
                try {
                    this.filter = Literal.makeLiteral(BooleanValue.get(((Literal)this.filter).getValue().effectiveBooleanValue()));
                }
                catch (XPathException xPathException) {
                    if (xPathException.getLocator() != null) throw xPathException;
                    xPathException.setLocator(this);
                    throw xPathException;
                }
            }
        }
        if (this.filter instanceof PositionRange) {
            sequenceIterable = (PositionRange)this.filter;
            if (((PositionRange)sequenceIterable).isFirstPositionOnly()) {
                FirstItemExpression firstItemExpression = new FirstItemExpression(this.start);
                firstItemExpression.setParentExpression(this.getParentExpression());
                firstItemExpression.setLocationId(this.getLocationId());
                return firstItemExpression;
            }
            TailExpression tailExpression = ((PositionRange)sequenceIterable).makeTailExpression(this.start);
            if (tailExpression != null) {
                tailExpression.setParentExpression(this.getParentExpression());
                tailExpression.setLocationId(this.getLocationId());
                return tailExpression;
            }
        }
        this.filterIsPositional = FilterExpression.isPositionalFilter(this.filter, typeHierarchy);
        this.filterIsSingletonBoolean = this.filter.getCardinality() == 16384 && this.filter.getItemType(typeHierarchy).equals(BuiltInAtomicType.BOOLEAN);
        this.filterIsIndependentNumeric = typeHierarchy.isSubType(this.filter.getItemType(typeHierarchy), BuiltInAtomicType.NUMERIC) && (this.filter.getDependencies() & 6) == 0 && !Cardinality.allowsMany(this.filter.getCardinality());
        this.resetStaticProperties();
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        Expression expression = this.start.optimize(optimizer, staticContext, itemType);
        if (expression != this.start) {
            this.start = expression;
            this.adoptChildExpression(expression);
        }
        Expression expression2 = this.filter;
        Expression expression3 = this.filter.optimize(optimizer, staticContext, this.start.getItemType(typeHierarchy));
        if (expression3 != this.filter) {
            this.filter = expression3;
            this.adoptChildExpression(expression3);
        }
        if ((expression3 = ExpressionTool.unsortedIfHomogeneous(optimizer, this.filter, false)) != this.filter) {
            this.filter = expression3;
            this.adoptChildExpression(expression3);
        }
        if (this.filter instanceof Literal && ((Literal)this.filter).getValue() instanceof Int64Value && ((Int64Value)((Literal)this.filter).getValue()).longValue() == 1L) {
            FirstItemExpression firstItemExpression = new FirstItemExpression(this.start);
            firstItemExpression.setLocationId(this.getLocationId());
            firstItemExpression.setParentExpression(this.getParentExpression());
            return firstItemExpression;
        }
        if (this.filter instanceof Literal && ((Literal)this.filter).getValue() instanceof BooleanValue) {
            if (((BooleanValue)((Literal)this.filter).getValue()).getBooleanValue()) {
                Expression.setParentExpression(this.start, this.getParentExpression());
                return this.start;
            }
            return new Literal(EmptySequence.getInstance());
        }
        if (this.filter instanceof PositionRange) {
            PositionRange positionRange = (PositionRange)this.filter;
            if (positionRange.isFirstPositionOnly()) {
                FirstItemExpression firstItemExpression = new FirstItemExpression(this.start);
                firstItemExpression.setLocationId(this.getLocationId());
                firstItemExpression.setParentExpression(this.getParentExpression());
                return firstItemExpression;
            }
            TailExpression tailExpression = positionRange.makeTailExpression(this.start);
            if (tailExpression != null) {
                tailExpression.setParentExpression(this.getParentExpression());
                tailExpression.setLocationId(this.getLocationId());
                return tailExpression;
            }
        }
        this.filterIsPositional = FilterExpression.isPositionalFilter(this.filter, typeHierarchy);
        boolean bl = this.filterIsSingletonBoolean = this.filter.getCardinality() == 16384 && this.filter.getItemType(typeHierarchy).equals(BuiltInAtomicType.BOOLEAN);
        if (!this.filterIsPositional) {
            Expression expression4;
            int n;
            int n2 = optimizer.isIndexableFilter(this.filter);
            if (n2 == 0 && this.filter != expression2 && (n = optimizer.isIndexableFilter(expression2)) != 0) {
                n2 = n;
                this.filter = expression2;
                this.adoptChildExpression(expression2);
            }
            if (n2 != 0 && (expression4 = optimizer.tryIndexedFilter(this, staticContext, n2 > 0)) != this) {
                return expression4;
            }
        }
        if (this.filterIsPositional && this.filter instanceof BooleanExpression && ((BooleanExpression)this.filter).operator == 10) {
            BooleanExpression booleanExpression = (BooleanExpression)this.filter;
            if (FilterExpression.isExplicitlyPositional(booleanExpression.operand0) && !FilterExpression.isExplicitlyPositional(booleanExpression.operand1)) {
                Expression expression5 = FilterExpression.forceToBoolean(booleanExpression.operand0, staticContext.getConfiguration());
                Expression expression6 = FilterExpression.forceToBoolean(booleanExpression.operand1, staticContext.getConfiguration());
                FilterExpression filterExpression = new FilterExpression(this.start, expression5);
                FilterExpression filterExpression2 = new FilterExpression(filterExpression, expression6);
                filterExpression2.setLocationId(this.getLocationId());
                filterExpression2.setParentExpression(this.getParentExpression());
                return filterExpression2.optimize(optimizer, staticContext, itemType);
            }
            if (FilterExpression.isExplicitlyPositional(booleanExpression.operand1) && !FilterExpression.isExplicitlyPositional(booleanExpression.operand0)) {
                Expression expression7 = FilterExpression.forceToBoolean(booleanExpression.operand0, staticContext.getConfiguration());
                Expression expression8 = FilterExpression.forceToBoolean(booleanExpression.operand1, staticContext.getConfiguration());
                FilterExpression filterExpression = new FilterExpression(this.start, expression8);
                FilterExpression filterExpression3 = new FilterExpression(filterExpression, expression7);
                filterExpression3.setLocationId(this.getLocationId());
                filterExpression3.setParentExpression(this.getParentExpression());
                return filterExpression3.optimize(optimizer, staticContext, itemType);
            }
        }
        if (this.filter instanceof PositionRange && !((PositionRange)this.filter).hasFocusDependentRange()) {
            SliceExpression sliceExpression = new SliceExpression(this.start, (PositionRange)this.filter);
            sliceExpression.setLocationId(this.getLocationId());
            sliceExpression.setParentExpression(this.getParentExpression());
            return sliceExpression;
        }
        PromotionOffer promotionOffer = new PromotionOffer(optimizer);
        promotionOffer.action = 10;
        promotionOffer.promoteDocumentDependent = (this.start.getSpecialProperties() & 0x10000) != 0;
        promotionOffer.containingExpression = this;
        expression3 = this.doPromotion(this.filter, promotionOffer);
        if (expression3 != this.filter) {
            this.filter = expression3;
            this.adoptChildExpression(expression3);
        }
        if (promotionOffer.containingExpression instanceof LetExpression) {
            promotionOffer.containingExpression = promotionOffer.containingExpression.optimize(optimizer, staticContext, itemType);
        }
        return promotionOffer.containingExpression;
    }

    private static Expression forceToBoolean(Expression expression, Configuration configuration) {
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        if (expression.getItemType(typeHierarchy).getPrimitiveType() == 514) {
            return expression;
        }
        Expression[] expressionArray = new Expression[]{expression};
        FunctionCall functionCall = SystemFunction.makeSystemFunction("boolean", 1, configuration.getNamePool());
        functionCall.setArguments(expressionArray);
        return functionCall;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        if (promotionOffer.action != 13 || !this.filterIsPositional) {
            this.start = this.doPromotion(this.start, promotionOffer);
        }
        if (promotionOffer.action == 12 || promotionOffer.action == 14) {
            this.filter = this.doPromotion(this.filter, promotionOffer);
        }
        return this;
    }

    private static boolean isPositionalFilter(Expression expression, TypeHierarchy typeHierarchy) {
        ItemType itemType = expression.getItemType(typeHierarchy);
        if (itemType.equals(BuiltInAtomicType.BOOLEAN)) {
            return FilterExpression.isExplicitlyPositional(expression);
        }
        return itemType.equals(BuiltInAtomicType.ANY_ATOMIC) || itemType instanceof AnyItemType || itemType.equals(BuiltInAtomicType.INTEGER) || itemType.equals(BuiltInAtomicType.NUMERIC) || typeHierarchy.isSubType(itemType, BuiltInAtomicType.NUMERIC) || FilterExpression.isExplicitlyPositional(expression);
    }

    private static boolean isExplicitlyPositional(Expression expression) {
        return (expression.getDependencies() & 0xC) != 0;
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.start, this.filter);
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.start == expression) {
            this.start = expression2;
            bl = true;
        }
        if (this.filter == expression) {
            this.filter = expression2;
            bl = true;
        }
        return bl;
    }

    public int computeCardinality() {
        PositionRange positionRange;
        if (this.filter instanceof Literal && ((Literal)this.filter).getValue() instanceof NumericValue) {
            return 24576;
        }
        if (this.filterIsIndependentNumeric) {
            return 24576;
        }
        if (!Cardinality.allowsMany(this.start.getCardinality())) {
            return 24576;
        }
        if (this.filter instanceof PositionRange && (positionRange = (PositionRange)this.filter).matchesAtMostOneItem()) {
            return 24576;
        }
        if (this.filter instanceof IsLastExpression && ((IsLastExpression)this.filter).getCondition()) {
            return 24576;
        }
        return 57344;
    }

    public int computeSpecialProperties() {
        return this.start.getSpecialProperties();
    }

    public boolean equals(Object object) {
        if (object instanceof FilterExpression) {
            FilterExpression filterExpression = (FilterExpression)object;
            return this.start.equals(filterExpression.start) && this.filter.equals(filterExpression.filter);
        }
        return false;
    }

    public int hashCode() {
        return "FilterExpression".hashCode() + this.start.hashCode() + this.filter.hashCode();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator;
        Expression expression = this.start;
        Value value = null;
        if (expression instanceof Literal) {
            value = ((Literal)expression).getValue();
        } else if (expression instanceof VariableReference) {
            value = Value.asValue(((VariableReference)expression).evaluateVariable(xPathContext));
            expression = new Literal(value);
        }
        if (value instanceof EmptySequence) {
            return EmptyIterator.getInstance();
        }
        ValueRepresentation valueRepresentation = null;
        if (this.filter instanceof Literal) {
            valueRepresentation = ((Literal)this.filter).getValue();
        } else if (this.filter instanceof VariableReference) {
            valueRepresentation = ((VariableReference)this.filter).evaluateVariable(xPathContext);
        }
        if (valueRepresentation != null) {
            if (valueRepresentation instanceof Value) {
                boolean bl;
                if ((valueRepresentation = ((Value)valueRepresentation).reduce()) instanceof AtomicValue && valueRepresentation instanceof NumericValue) {
                    if (((NumericValue)valueRepresentation).isWholeNumber()) {
                        int n = (int)((NumericValue)valueRepresentation).longValue();
                        if (value != null) {
                            if (value instanceof Value) {
                                return SingletonIterator.makeIterator(value.itemAt(n - 1));
                            }
                            if (value instanceof NodeInfo) {
                                if (n == 1) {
                                    return SingletonIterator.makeIterator((NodeInfo)((Object)value));
                                }
                                return EmptyIterator.getInstance();
                            }
                        }
                        if (n >= 1) {
                            SequenceIterator sequenceIterator2 = expression.iterate(xPathContext);
                            return PositionIterator.make(sequenceIterator2, n, n);
                        }
                        return EmptyIterator.getInstance();
                    }
                    return EmptyIterator.getInstance();
                }
                try {
                    bl = ((Value)valueRepresentation).effectiveBooleanValue();
                }
                catch (XPathException xPathException) {
                    if (xPathException.getLocator() == null) {
                        xPathException.setLocator(this);
                    }
                    throw xPathException;
                }
                if (bl) {
                    return this.start.iterate(xPathContext);
                }
                return EmptyIterator.getInstance();
            }
            if (valueRepresentation instanceof NodeInfo) {
                return this.start.iterate(xPathContext);
            }
        }
        if ((sequenceIterator = expression.iterate(xPathContext)) instanceof EmptyIterator) {
            return sequenceIterator;
        }
        if (this.filterIsPositional) {
            FilterIterator filterIterator = new FilterIterator(sequenceIterator, this.filter, xPathContext);
            filterIterator.setFilterIsSingletonBoolean(this.filterIsSingletonBoolean);
            return filterIterator;
        }
        return new FilterIterator.NonNumeric(sequenceIterator, this.filter, xPathContext);
    }

    public int computeDependencies() {
        return this.start.getDependencies() | this.filter.getDependencies() & 0x1E1;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "filter []");
        this.start.display(n + 1, printStream, configuration);
        this.filter.display(n + 1, printStream, configuration);
    }
}

