/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.Serializable;
import net.sf.saxon.Err;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public abstract class AtomicValue
extends Value
implements Item {
    protected AtomicType typeLabel;

    public void setTypeLabel(AtomicType atomicType) {
        this.typeLabel = atomicType;
    }

    public boolean isMultiValued() {
        return false;
    }

    public boolean hasBuiltInType() {
        return this.typeLabel.isBuiltInType();
    }

    public Comparable getXPathComparable() {
        return null;
    }

    public CharSequence getStringValueCS() {
        return this.getStringValue();
    }

    public void process(XPathContext xPathContext) throws XPathException {
        xPathContext.getReceiver().append(this, 0, 2);
    }

    public Item itemAt(int n) throws XPathException {
        return n == 0 ? this : null;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.typeLabel;
    }

    public AtomicType getTypeLabel() {
        return this.typeLabel;
    }

    public abstract BuiltInAtomicType getPrimitiveType();

    public final int getCardinality() {
        return 16384;
    }

    public final AtomicValue convert(BuiltInAtomicType builtInAtomicType, XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = this.convertPrimitive(builtInAtomicType, true, xPathContext);
        if (atomicValue instanceof ValidationErrorValue) {
            ValidationException validationException = ((ValidationErrorValue)atomicValue).getException();
            if (validationException.getErrorCodeLocalPart() == null) {
                validationException.setErrorCode("FORG0001");
            }
            throw validationException;
        }
        return atomicValue;
    }

    public abstract AtomicValue convertPrimitive(BuiltInAtomicType var1, boolean var2, XPathContext var3);

    public AtomicValue convert(AtomicType atomicType, XPathContext xPathContext, boolean bl) {
        if (atomicType instanceof BuiltInAtomicType) {
            return this.convertPrimitive((BuiltInAtomicType)atomicType, bl, xPathContext);
        }
        CharSequence charSequence = this.getStringValueCS();
        AtomicValue atomicValue = this.convertPrimitive((BuiltInAtomicType)atomicType.getPrimitiveItemType(), bl, xPathContext);
        if (atomicValue instanceof ValidationErrorValue) {
            return atomicValue;
        }
        return atomicType.setDerivedTypeLabel(atomicValue.copy(null), charSequence, bl);
    }

    public abstract AtomicValue copy(AtomicType var1);

    public final int getLength() {
        return 1;
    }

    public final SequenceIterator iterate() {
        return SingletonIterator.makeIterator(this);
    }

    public abstract String getStringValue();

    public final SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator(this);
    }

    public boolean effectiveBooleanValue() throws XPathException {
        DynamicError dynamicError = new DynamicError("Effective boolean value is not defined for an atomic value of type " + Type.displayTypeName(this));
        dynamicError.setIsTypeError(true);
        dynamicError.setErrorCode("FORG0006");
        throw dynamicError;
    }

    public AtomicValue getComponent(int n) throws XPathException {
        throw new UnsupportedOperationException("Data type does not support component extraction");
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        Serializable serializable;
        if (bl) {
            serializable = null;
            if (schemaType instanceof SimpleType) {
                serializable = (SimpleType)schemaType;
            } else if (schemaType instanceof ComplexType && ((ComplexType)schemaType).isSimpleContent()) {
                serializable = ((ComplexType)schemaType).getSimpleContentType();
            }
            if (serializable != null && !serializable.isNamespaceSensitive()) {
                ValidationException validationException = serializable.validateContent(this.getStringValueCS(), null, staticContext.getConfiguration().getNameChecker());
                if (validationException != null) {
                    throw validationException;
                }
                return;
            }
        }
        if (schemaType instanceof ComplexType && !((ComplexType)schemaType).isSimpleContent() && !((ComplexType)schemaType).isMixedContent() && !Whitespace.isWhite(this.getStringValueCS())) {
            serializable = new StaticError("Complex type " + schemaType.getDescription() + " does not allow text content " + Err.wrap(this.getStringValueCS()));
            ((XPathException)serializable).setIsTypeError(true);
            throw serializable;
        }
    }

    public String toString() {
        return this.typeLabel.toString() + " (\"" + this.getStringValueCS() + "\")";
    }
}

