/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral.javagroups;

import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.lateral.LateralCacheInfo;
import org.apache.jcs.auxiliary.lateral.LateralElementDescriptor;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.jcs.auxiliary.lateral.javagroups.JGConnectionHolder;
import org.apache.jcs.auxiliary.lateral.javagroups.behavior.IJGConstants;
import org.apache.jcs.engine.CacheElement;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.jgroups.Channel;
import org.jgroups.Message;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.RspList;

public class LateralJGSender
implements IJGConstants {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$lateral$javagroups$LateralJGSender == null ? (class$org$apache$jcs$auxiliary$lateral$javagroups$LateralJGSender = LateralJGSender.class$("org.apache.jcs.auxiliary.lateral.javagroups.LateralJGSender")) : class$org$apache$jcs$auxiliary$lateral$javagroups$LateralJGSender));
    private ILateralCacheAttributes ilca;
    private String remoteHost;
    private InetAddress address;
    int port = 1111;
    private Channel javagroups;
    private RpcDispatcher disp;
    private JGConnectionHolder holder;
    int counter = 0;
    private static final int openTimeOut = 5000;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$lateral$javagroups$LateralJGSender;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Serializable;

    public LateralJGSender(ILateralCacheAttributes lca) throws IOException {
        this.ilca = lca;
        this.init();
    }

    protected void init() throws IOException {
        try {
            log.debug((Object)"Attempting ccreate channel.");
            this.holder = JGConnectionHolder.getInstance(this.ilca);
            this.javagroups = this.holder.getChannel();
            if (this.javagroups == null) {
                throw new IOException("javagroups is null");
            }
        }
        catch (ConnectException e) {
            log.debug((Object)"Remote host refused connection.");
            throw e;
        }
        catch (Exception e) {
            log.debug((Object)("Could not connect to channel. Exception is " + e));
            throw new IOException(e.getMessage());
        }
    }

    public void send(LateralElementDescriptor led) throws IOException {
        log.debug((Object)"sending LateralElementDescriptor");
        if (led == null) {
            return;
        }
        try {
            Message send_msg = new Message(null, null, (Serializable)led);
            this.javagroups.send(send_msg);
        }
        catch (Exception e) {
            log.error((Object)("Detected problem with connection: " + e));
            throw new IOException(e.getMessage());
        }
    }

    public ICacheElement sendAndReceive(LateralElementDescriptor led) throws IOException {
        ICacheElement ice = null;
        log.debug((Object)"sendAndReceive led");
        if (led == null) {
            return null;
        }
        try {
            try {
                this.disp = this.holder.getDispatcher();
                Object[] args = new Object[]{led.ce.getCacheName(), led.ce.getKey()};
                String[] sigs = new String[]{(class$java$lang$String == null ? (class$java$lang$String = LateralJGSender.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$io$Serializable == null ? (class$java$io$Serializable = LateralJGSender.class$("java.io.Serializable")) : class$java$io$Serializable).getName()};
                MethodCall meth = new MethodCall("handleGet", args, sigs);
                RspList rsp_list = this.disp.callRemoteMethods(null, meth, 2, 1000L);
                log.debug((Object)("rsp_list = " + rsp_list));
                Vector vec = rsp_list.getResults();
                log.debug((Object)("rsp_list size = " + vec.size()));
                Iterator it = ((AbstractList)vec).iterator();
                while (it.hasNext()) {
                    ice = (ICacheElement)it.next();
                    if (ice == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        catch (Exception e) {
            log.error((Object)("Detected problem with connection: " + e));
            throw new IOException(e.getMessage());
        }
        return ice;
    }

    public void update(ICacheElement item, long requesterId) throws IOException {
        LateralElementDescriptor led = new LateralElementDescriptor(item);
        led.requesterId = requesterId;
        led.command = 1;
        this.send(led);
    }

    public void remove(String cacheName, Serializable key) throws IOException {
        this.remove(cacheName, key, LateralCacheInfo.listenerId);
    }

    public void remove(String cacheName, Serializable key, long requesterId) throws IOException {
        CacheElement ce = new CacheElement(cacheName, key, null);
        LateralElementDescriptor led = new LateralElementDescriptor(ce);
        led.requesterId = requesterId;
        led.command = 2;
        this.send(led);
    }

    public void release() throws IOException {
    }

    public void dispose(String cache) throws IOException {
    }

    public void removeAll(String cacheName) throws IOException {
        this.removeAll(cacheName, LateralCacheInfo.listenerId);
    }

    public void removeAll(String cacheName, long requesterId) throws IOException {
        CacheElement ce = new CacheElement(cacheName, (Serializable)((Object)"ALL"), null);
        LateralElementDescriptor led = new LateralElementDescriptor(ce);
        led.requesterId = requesterId;
        led.command = 3;
        this.send(led);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

