/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Checkout
extends SvnCommand {
    private SVNUrl url = null;
    private boolean recurse = true;
    private File destPath = null;
    private SVNRevision revision = SVNRevision.HEAD;

    public void execute() throws SvnAntException {
        try {
            this.svnClient.checkout(this.url, this.destPath, this.revision, this.recurse);
        }
        catch (Exception exception) {
            throw new SvnAntException("Can't checkout", exception);
        }
    }

    protected void validateAttributes() throws SvnAntValidationException {
        if (this.destPath == null) {
            this.destPath = this.getProject().getBaseDir();
        }
        if (this.url == null) {
            throw new SvnAntValidationException("url must be set");
        }
        if (this.revision == null) {
            throw SvnAntValidationException.createInvalidRevisionException();
        }
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }

    public void setDestpath(File file) {
        this.destPath = file;
    }

    public void setRevision(String string) {
        this.revision = this.getRevisionFrom(string);
    }
}

