/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.output;

import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.cocoon.components.modules.output.AbstractOutputModule;
import org.apache.cocoon.components.modules.output.OutputModule;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;

public class RequestAttributeOutputModule
extends AbstractOutputModule {
    public static final String PREFIX = OutputModule.ROLE;
    public static final String TRANS_PREFIX = PREFIX + ".RequestAttributeOutputModule.transient";
    public static final String ROLLBACK_LIST = PREFIX + ".RequestAttributeOutputModule.rollback";

    public void setAttribute(Configuration modeConf, Map objectModel, String name, Object value) {
        if (this.settings.get("isolation-level", "0").equals("1")) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Setting transient ['" + name + "'] to ['" + value + "']");
            }
            this.transientSetAttribute(objectModel, TRANS_PREFIX, name, value);
        } else {
            Request request = ObjectModelHelper.getRequest(objectModel);
            if (!this.attributeExists(objectModel, ROLLBACK_LIST, name = this.getName(name))) {
                Object tmp = request.getAttribute(name);
                this.transientSetAttribute(objectModel, ROLLBACK_LIST, name, tmp);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Setting ['" + name + "'] to ['" + value + "']");
            }
            request.setAttribute(name, value);
        }
    }

    public void rollback(Configuration modeConf, Map objectModel, Exception e) {
        this.getLogger().debug("Rollback");
        Request request = ObjectModelHelper.getRequest(objectModel);
        if (this.settings.get("isolation-level", "0").equals("1")) {
            this.rollback(objectModel, TRANS_PREFIX);
        } else {
            Map rollbackList = this.prepareCommit(objectModel, ROLLBACK_LIST);
            if (rollbackList != null) {
                Iterator i = rollbackList.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry me = i.next();
                    String key = (String)me.getKey();
                    Object val = me.getValue();
                    if (val != null) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Rolling back ['" + key + "'] to ['" + val + "']");
                        }
                        request.setAttribute(key, val);
                        continue;
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Rolling back ['" + key + "']");
                    }
                    request.removeAttribute(key);
                }
            }
        }
        String prefix = (String)this.settings.get("key-prefix", PREFIX);
        if (prefix.length() == 0) {
            request.setAttribute("errorMessage", e.getMessage());
        } else {
            request.setAttribute(prefix + ':' + "errorMessage", e.getMessage());
        }
    }

    public void commit(Configuration modeConf, Map objectModel) {
        this.getLogger().debug("Commit");
        if (this.settings.get("isolation-level", "0").equals("1")) {
            Map data = this.prepareCommit(objectModel, TRANS_PREFIX);
            if (data == null || data.isEmpty()) {
                return;
            }
            String prefix = (String)this.settings.get("key-prefix", PREFIX);
            if (prefix.length() == 0) {
                prefix = null;
            }
            Request request = ObjectModelHelper.getRequest(objectModel);
            Iterator i = data.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry me = i.next();
                String key = (String)me.getKey();
                Object value = me.getValue();
                if (prefix != null) {
                    key = prefix + ':' + key;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Committing ['" + key + "'] to ['" + value + "']");
                }
                request.setAttribute(key, value);
            }
        } else {
            this.prepareCommit(objectModel, ROLLBACK_LIST);
        }
    }

    protected String getName(String name) {
        String prefix = (String)this.settings.get("key-prefix", PREFIX);
        return prefix.length() == 0 ? name : prefix + ':' + name;
    }
}

