/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.treeprocessor.AbstractParentProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.CategoryNode;
import org.apache.cocoon.components.treeprocessor.NamedProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.TreeBuilder;

public class CategoryNodeBuilder
extends AbstractParentProcessingNodeBuilder
implements ThreadSafe {
    private static String PREFIX = CategoryNodeBuilder.class.getName() + "/";
    protected String name;

    public void configure(Configuration config) throws ConfigurationException {
        super.configure(config);
        this.name = config.getChild("category-name").getValue(config.getAttribute("name"));
    }

    protected boolean hasParameters() {
        return false;
    }

    public ProcessingNode buildNode(Configuration config) throws Exception {
        CategoryNode node = new CategoryNode();
        this.treeBuilder.setupNode(node, config);
        HashMap<String, NamedProcessingNode> category = new HashMap<String, NamedProcessingNode>();
        List children = this.buildChildNodesList(config);
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            NamedProcessingNode child = (NamedProcessingNode)iter.next();
            category.put(child.getName(), child);
        }
        node.setCategory(this.name, category);
        if (!this.treeBuilder.registerNode(PREFIX + this.name, node)) {
            throw new ConfigurationException("Only one <map:" + this.name + "> is allowed in a sitemap. Another one is declared at " + config.getLocation());
        }
        return node;
    }

    public static CategoryNode getCategoryNode(TreeBuilder builder, String categoryName) {
        return (CategoryNode)builder.getRegisteredNode(PREFIX + categoryName);
    }

    public static ProcessingNode getNamedNode(TreeBuilder builder, String categoryName, String nodeName) throws Exception {
        CategoryNode category = CategoryNodeBuilder.getCategoryNode(builder, categoryName);
        return category.getNodeByName(nodeName);
    }
}

