/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.cron;

import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.WrapperComponentManager;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.cron.QuartzJobExecutor;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.background.BackgroundEnvironment;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionException;

public class CocoonQuartzJobExecutor
extends QuartzJobExecutor {
    private Object m_key;
    private BackgroundEnvironment m_env;
    private Processor m_processor;

    protected void setup(JobDataMap data) throws JobExecutionException {
        Parameters params;
        Context envContext;
        super.setup(data);
        try {
            envContext = (Context)this.m_context.get((Object)"environment-context");
        }
        catch (ContextException e) {
            throw new JobExecutionException((Exception)((Object)e));
        }
        try {
            this.m_env = new BackgroundEnvironment(this.m_logger, envContext);
        }
        catch (MalformedURLException e) {
            throw new JobExecutionException((Exception)e);
        }
        Request req = ObjectModelHelper.getRequest((Map)this.m_env.getObjectModel());
        Map objects = (Map)data.get((Object)"QuartzJobScheduler.Map");
        if (objects != null) {
            req.setAttribute("cron-objectmap", (Object)objects);
        }
        if ((params = (Parameters)data.get((Object)"QuartzJobScheduler.Parameters")) != null) {
            req.setAttribute("cron-parameters", (Object)params);
        }
        try {
            this.m_processor = (Processor)this.m_manager.lookup(Processor.ROLE);
        }
        catch (ServiceException e) {
            throw new JobExecutionException((Exception)((Object)e));
        }
        this.m_key = CocoonComponentManager.startProcessing((Environment)this.m_env);
        CocoonComponentManager.enterEnvironment((Environment)this.m_env, (ComponentManager)new WrapperComponentManager(this.m_manager), (Processor)this.m_processor);
    }

    protected void release(JobDataMap data) {
        super.release(data);
        CocoonComponentManager.leaveEnvironment();
        CocoonComponentManager.endProcessing((Environment)this.m_env, (Object)this.m_key);
        if (this.m_manager != null) {
            this.m_manager.release((Object)this.m_processor);
        }
    }
}

