/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.profiler;

import org.apache.cocoon.components.profiler.ProfilerData;
import org.apache.cocoon.components.sax.XMLByteStreamCompiler;
import org.apache.cocoon.components.sax.XMLByteStreamInterpreter;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLPipe;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ProfilingXMLPipe
implements XMLPipe {
    private XMLConsumer consumer;
    private ProfilerData data;
    private int index;
    private long time;
    private long total;
    private XMLDeserializer deserializer;
    private XMLSerializer serializer;

    public void setup(int index, ProfilerData data) {
        this.index = index;
        this.data = data;
        this.deserializer = new XMLByteStreamInterpreter();
        this.serializer = new XMLByteStreamCompiler();
    }

    public void setConsumer(XMLConsumer consumer) {
        this.consumer = consumer;
    }

    public void startDocument() throws SAXException {
        this.time = System.currentTimeMillis();
        this.serializer.startDocument();
    }

    public void endDocument() throws SAXException {
        this.total = System.currentTimeMillis() - this.time;
        this.serializer.endDocument();
        if (this.index != -1) {
            this.data.setProcessingTime(this.index, this.total);
        }
        Object fragment = this.serializer.getSAXFragment();
        if (this.index != -1) {
            this.data.setSAXFragment(this.index, fragment);
        }
        this.deserializer.setConsumer(this.consumer);
        this.time = System.currentTimeMillis();
        this.deserializer.deserialize(fragment);
        this.total = System.currentTimeMillis() - this.time;
        if (this.index != -1 && this.index == this.data.getCount() - 2) {
            this.data.setProcessingTime(this.index + 1, this.total);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.serializer.setDocumentLocator(locator);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.serializer.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.serializer.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        this.serializer.startElement(uri, loc, raw, a);
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        this.serializer.endElement(uri, loc, raw);
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        this.serializer.characters(c, start, len);
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        this.serializer.ignorableWhitespace(c, start, len);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.serializer.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.serializer.skippedEntity(name);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.serializer.startDTD(name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        this.serializer.endDTD();
    }

    public void startEntity(String name) throws SAXException {
        this.serializer.startEntity(name);
    }

    public void endEntity(String name) throws SAXException {
        this.serializer.endEntity(name);
    }

    public void startCDATA() throws SAXException {
        this.serializer.startCDATA();
    }

    public void endCDATA() throws SAXException {
        this.serializer.endCDATA();
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        this.serializer.comment(ch, start, len);
    }
}

