/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http.server;

import java.io.UnsupportedEncodingException;

public class URLCoder {
    private URLCoder() {
    }

    private static char getDigit(int d) {
        char c = Character.forDigit(d, 16);
        if (Character.isLetter(c)) {
            c = Character.toUpperCase(c);
        }
        return c;
    }

    private static void encodeChars(String value, String encoding, StringBuffer sb) throws UnsupportedEncodingException {
        byte[] bytes = encoding == null ? value.getBytes() : value.getBytes(encoding);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append('%');
            byte b = bytes[i];
            sb.append(URLCoder.getDigit((b & 0xF0) >> 4));
            sb.append(URLCoder.getDigit(b & 0xF));
        }
    }

    private static String decodeChars(char[] chars, int start, int count, String encoding) throws UnsupportedEncodingException {
        int pos;
        byte[] bytes = new byte[count / 3];
        int bPos = 0;
        boolean bad = false;
        for (pos = start; pos < start + count; ++pos) {
            char c = chars[pos];
            if (c != '%') {
                bad = true;
                break;
            }
            int b = 0;
            if (++pos >= chars.length) {
                bad = true;
                break;
            }
            c = chars[pos];
            if (c >= 'A' && c <= 'F') {
                b = b + 10 + (c - 65);
            } else if (c >= '0' && c <= '9') {
                b = b + c - 48;
            } else {
                bad = true;
                break;
            }
            b <<= 4;
            if (++pos >= chars.length) {
                bad = true;
                break;
            }
            c = chars[pos];
            if (c >= 'A' && c <= 'F') {
                b = b + 10 + (c - 65);
            } else if (c >= '0' && c <= '9') {
                b = b + c - 48;
            } else {
                bad = true;
                break;
            }
            bytes[bPos++] = (byte)(b & 0xFF);
        }
        if (bad) {
            throw new IllegalArgumentException("Unexpected character at position " + pos);
        }
        if (encoding == null) {
            return new String(bytes);
        }
        return new String(bytes, encoding);
    }

    public static String encode(String value, String encoding) throws UnsupportedEncodingException {
        boolean changed = false;
        StringBuffer sb = new StringBuffer();
        char[] chars = value.toCharArray();
        int firstEncodeIndex = -1;
        int encodeCount = 0;
        StringBuffer encodeSb = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            boolean encode;
            char c = chars[i];
            if (c == ' ') {
                c = '+';
                changed = true;
                encode = false;
            } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '*') {
                encode = false;
            } else {
                changed = true;
                encode = true;
            }
            if (encode) {
                if (firstEncodeIndex < 0) {
                    firstEncodeIndex = i;
                }
                ++encodeCount;
                continue;
            }
            if (firstEncodeIndex >= 0) {
                URLCoder.encodeChars(new String(chars, firstEncodeIndex, encodeCount), encoding, sb);
                firstEncodeIndex = -1;
                encodeCount = 0;
            }
            sb.append(c);
        }
        if (firstEncodeIndex >= 0) {
            URLCoder.encodeChars(new String(chars, firstEncodeIndex, encodeCount), encoding, sb);
            firstEncodeIndex = -1;
            encodeCount = 0;
        }
        if (changed) {
            return sb.toString();
        }
        return value;
    }

    public static String decode(String value, String encoding) throws UnsupportedEncodingException {
        boolean changed = false;
        StringBuffer sb = new StringBuffer();
        char[] chars = value.toCharArray();
        int firstDecodeIndex = -1;
        int decodeCount = 0;
        for (int i = 0; i < chars.length; ++i) {
            boolean decode;
            char c = chars[i];
            if (c == '+') {
                c = ' ';
                decode = false;
                changed = true;
            } else if (c == '%') {
                decode = true;
                changed = true;
            } else {
                decode = false;
            }
            if (decode) {
                if (firstDecodeIndex < 0) {
                    firstDecodeIndex = i;
                }
                decodeCount += 3;
                i += 2;
                continue;
            }
            if (firstDecodeIndex >= 0) {
                sb.append(URLCoder.decodeChars(chars, firstDecodeIndex, decodeCount, encoding));
                firstDecodeIndex = -1;
                decodeCount = 0;
            }
            sb.append(c);
        }
        if (firstDecodeIndex >= 0) {
            sb.append(URLCoder.decodeChars(chars, firstDecodeIndex, decodeCount, encoding));
            firstDecodeIndex = -1;
            decodeCount = 0;
        }
        if (changed) {
            return sb.toString();
        }
        return value;
    }
}

