/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.documentbase;

import fr.gouv.culture.sdx.utils.Utilities;

public class SimpleIDGenerator extends AbstractIDGenerator {

    long currentId = 0;

    /**Generates an idea appending the given strings
     * to an incremented long class field beginning from
     * zero.
     *
     * @param prefix    The prefix for the generated id
     * @param suffix    The suffix for the generated id
     * */
    public String generate(String prefix, String suffix) {
        String id = "";

        id = String.valueOf(currentId);
        currentId++;

        if (Utilities.checkString(prefix))
            id = prefix + id;

        if (Utilities.checkString(suffix))
            id = id + suffix;

        if (!isIdUnique(id))
            return generate(prefix, suffix); //a recursive call will loop until a unique id is generated

        return id;
    }

}
