/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
/*
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: 12 nov. 2002
 * Time: 15:17:46
 * To change template for new class use
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.exception.SDXException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.logger.Logger;

public class GetDocumentsPipeline extends GenericPipeline {

    private GetDocumentsTransformation gdt = new GetDocumentsTransformation();

    public GetDocumentsPipeline() throws SDXException {
        this.addTransformation(gdt);
    }

    /** Sets the super.getLog() for the pipeline
     *
     * @param logger   The super.getLog() created from Cocoon's logkit.
     */
    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        gdt.enableLogging(logger);
    }

    /**
     * Sets the pipeline's ServiceManager.
     *
     * @param manager  The ServiceManager to use.
     * @throws org.apache.avalon.framework.service.ServiceException
     */
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        gdt.service(manager);
    }
}
