/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/

package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.SdxObject;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.xml.XMLPipe;

import java.io.File;

public interface Pipeline extends XMLPipe, SdxObject {

    /**String representation of the pipeline package name (including trailing separator "."). */
    public static final String PACKAGE_QUALNAME = "fr.gouv.culture.sdx.pipeline.";

    /**String representation of the pipeline class name suffix. */
    public static final String CLASS_NAME_SUFFIX = "Pipeline";

    /**Generates a new instance of a Pipeline object*/
    public Pipeline newInstance() throws SDXException;

    /**Set's the default pipeline parameters
     *
     * @param params The parameters for steps of the pipeline
     */
    public void setParameters(Parameters params);


    /** The parameters for this pipeline. */
    public Parameters getParameters();

    /**
     * Adds a transformation to the pipeline and sets the consumer of the last
     * transformation to be the newly added transformation.
     * @param t     The transformation to be added.
     */
    public void addTransformation(Transformation t) throws SDXException;

    /**Returns a byte array which contains the
     * data of a transformation step. The data will only be present
     * after a pipeline is executed, if no transformation data is retained
     * <code>null</code>  will be returned
     */
    public byte[] getTransformedBytes();

    /**Returns a file which contains the
     * data of a transformation step. The data will only be present
     * after a pipeline is executed, if no transformation data is retained
     * <code>null</code>  will be returned
     */
    public File getTransformedFile() throws SDXException;

}
