/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.oai;

import fr.gouv.culture.oai.AbstractOAIHarvester;
import fr.gouv.culture.oai.OAIRequest;
import fr.gouv.culture.oai.OAIRequestImpl;
import fr.gouv.culture.oai.util.OAIUtilities;
import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.IndexableDocument;
import fr.gouv.culture.sdx.document.OAIDocument;
import fr.gouv.culture.sdx.document.XMLDocument;
import fr.gouv.culture.sdx.documentbase.DocumentBase;
import fr.gouv.culture.sdx.documentbase.IDGenerator;
import fr.gouv.culture.sdx.documentbase.IndexParameters;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.oai.DocumentBaseOAIHarvester;
import fr.gouv.culture.sdx.oai.OAIEnvelopStripper;
import fr.gouv.culture.sdx.pipeline.GenericPipeline;
import fr.gouv.culture.sdx.pipeline.Pipeline;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.search.lucene.query.ComplexQuery;
import fr.gouv.culture.sdx.search.lucene.query.DateIntervalQuery;
import fr.gouv.culture.sdx.search.lucene.query.FieldQuery;
import fr.gouv.culture.sdx.search.lucene.query.Results;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.utils.Date;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import fr.gouv.culture.sdx.utils.database.Database;
import fr.gouv.culture.sdx.utils.database.DatabaseBacked;
import fr.gouv.culture.sdx.utils.database.DatabaseEntity;
import fr.gouv.culture.sdx.utils.database.Property;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.SimpleTimeScheduler;
import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.TimeScheduler;
import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.TimeTrigger;
import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.TimeTriggerFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.serialization.XMLSerializer;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLPipe;
import org.apache.commons.io.FileUtils;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractDocumentBaseOAIHarvester
extends AbstractOAIHarvester
implements DocumentBaseOAIHarvester {
    protected DocumentBase docbase = null;
    protected String docbaseId = "";
    protected Pipeline pipe = null;
    protected Database _database = null;
    protected Hashtable storedRequests = null;
    protected Hashtable storeRepositoriesRefs = null;
    protected TimeScheduler scheduler = null;
    protected IDGenerator harvesterIdGen = null;
    protected String TEMPFILE_SUFFIX = ".sdx";
    protected File tempDir = null;
    protected File tempDirBatch = null;
    protected File harvestDoc = null;
    protected FileOutputStream fileOs = null;
    protected XMLDocument urlResource = null;
    protected ArrayList deletedDocs = null;
    protected int noHarvestedDocs = 0;
    protected int noDocsDeleted = 0;
    protected Set m_docsaddedIds = null;
    protected Set m_docsToDeleteIds = null;
    protected Set m_docsdeletedids = null;
    protected boolean keepDeletedRecords = false;
    protected int noRecordsPerBatch = 250;
    protected boolean keepHarvestedRecords = false;
    protected String tempDirPath = "";
    protected String transformerFactory = "";
    protected String defaultTransformerFactory = "com.icl.saxon.TransformerFactoryImpl";
    protected String transformerIndent = "";
    protected String defaultTransformerIndent = "no";
    protected boolean indexAtHarvestEnd = true;
    protected boolean forceIndexOnHarvestError = false;
    protected static final String TRANSFORMER_FACTORY = "transformer-factory";
    protected static final String TRANSFORMER_INDENT = "transformer-indent";
    protected static final String INDEXATHARVESTEND = "index-at-harvest-end";
    protected static final String FORCEINDEXONHARVESTERROR = "force-index-on-harvest-error";
    protected static final String OAI_HARVEST_ID = "oaiHarvestId";
    protected static final String OAI_FAILED_HARVEST = "oaiFailedHarvest";
    protected static final String OAI_HARVESTER_LAST_UPDATED = "oaiHarvesterLastUpdated";
    protected static final String OAI_HARVESTER_RESUMPTION_TOKEN = "oaiHarvesterResumptionToken";
    protected static final String OAI_VERB = "oaiVerb";
    protected static final String OAI_IDENTIFIER = "oaiIdentifier";
    protected static final String OAI_METADATA_PREFIX = "oaiMetadataPrefix";
    protected static final String OAI_FROM = "oaiFrom";
    protected static final String OAI_UNTIL = "oaiUntil";
    protected static final String OAI_SET = "oaiSet";
    protected static final String NO_DOCS_DELETED = "noDocDeleted";
    protected static final String NO_DOCS_HARVESTED = "noDocHarvested";
    protected static final String ERROR_CODE = "errorCode";
    protected Hashtable filesProperties = null;
    protected XMLSerializer cBytes = null;
    protected XMLPipe oaiStripper = null;

    public AbstractDocumentBaseOAIHarvester(DocumentBase base) {
        this.docbase = base;
        if (this.docbase != null) {
            this.docbaseId = this.docbase.getId();
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        String[] args = new String[]{this.docbaseId};
        OAIUtilities.logInfo(this.logger, 10012, args);
        this.userAgent = configuration.getAttribute("userAgent", "SDX OAI Harvester");
        this.keepDeletedRecords = configuration.getAttributeAsBoolean("keepDeletedRecords", this.keepDeletedRecords);
        this.noRecordsPerBatch = configuration.getAttributeAsInteger("noRecordsPerBatch", this.noRecordsPerBatch);
        this.transformerFactory = configuration.getAttribute(TRANSFORMER_FACTORY, this.defaultTransformerFactory);
        this.transformerIndent = configuration.getAttribute(TRANSFORMER_INDENT, this.defaultTransformerIndent);
        this.indexAtHarvestEnd = configuration.getAttributeAsBoolean(INDEXATHARVESTEND, this.indexAtHarvestEnd);
        this.forceIndexOnHarvestError = configuration.getAttributeAsBoolean(FORCEINDEXONHARVESTERROR, this.forceIndexOnHarvestError);
        this.configureTempDir(configuration);
        this.configureAdminEmails(configuration);
        this.configureDataProviders(configuration);
        this.configurePipeline(configuration);
        this.configureDatabase(configuration);
        this.configureHarvestIDGenerator(configuration);
        String[] args2 = new String[]{this.docbaseId, this.getHarvesterId()};
        OAIUtilities.logInfo(this.logger, 10000, args2);
    }

    protected void configureTempDir(Configuration conf) throws ConfigurationException {
        this.keepHarvestedRecords = conf.getAttributeAsBoolean("keepHarvestedRecords", false);
        this.tempDirPath = conf.getAttribute("tempDirPath", null);
        boolean m_default = true;
        if (Utilities.checkString(this.tempDirPath)) {
            try {
                this.tempDir = Utilities.resolveFile(this.logger, conf.getLocation(), (Context)this.getContext(), this.tempDirPath, true);
                m_default = false;
            }
            catch (Exception e) {
                OAIUtilities.logError(this.logger, "Enable to initialize the temporary directory: " + this.tempDirPath + " to store harvested records. Uses default instead.", e);
                m_default = true;
            }
        }
        if (m_default || this.tempDir == null) {
            try {
                this.tempDir = (File)this.getContext().get((Object)"upload-directory");
            }
            catch (ContextException ce) {
                throw new ConfigurationException("Enable to initialize the OAI harvester default temporary directory: " + this.tempDir.getAbsolutePath(), (Throwable)ce);
            }
        }
        String childDir = Utilities.getStringFromContext("sdx.application.dirName", (Context)this.getContext()) + "_oaiHarvests" + File.separator + this.docbaseId + File.separator + Utilities.encodeURL(Long.toString(new java.util.Date().getTime()), null);
        try {
            if (this.tempDir.canWrite()) {
                this.tempDir = new File(this.tempDir, childDir);
                OAIUtilities.logDebug(this.logger, "Initialize temporary directory to store harvested records: " + this.tempDir.getAbsolutePath());
                this.tempDir = Utilities.checkDirectory(this.tempDir.getAbsolutePath(), this.logger);
            } else {
                this.logger.error("Enable to create temporary directory to store harvested records: " + this.tempDir.getAbsolutePath());
                this.tempDir = new File(Utilities.getSystemTempDir(), childDir);
                OAIUtilities.logDebug(this.logger, "Initialize temporary directory to store harvested records: " + this.tempDir.getAbsolutePath());
            }
        }
        catch (SDXException sdxe) {
            throw new ConfigurationException("Enable to initialize the OAI harvester default temporary directory: " + this.tempDir.getAbsolutePath(), (Throwable)((Object)sdxe));
        }
    }

    protected void configureDatabase(Configuration configuration) throws ConfigurationException {
        DatabaseBacked internalDb = new DatabaseBacked();
        try {
            internalDb.enableLogging(this.logger);
            internalDb.contextualize(Utilities.createNewReadOnlyContext((Context)this.getContext()));
            internalDb.service(this.manager);
            internalDb.setId(this.getHarvesterId());
            internalDb.configure(configuration);
            internalDb.init();
            this._database = internalDb.getDatabase();
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (ServiceException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        catch (ContextException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    protected void configureHarvestIDGenerator(Configuration configuration) throws ConfigurationException {
        this.harvesterIdGen = ConfigurationUtils.configureIDGenerator(this.logger, configuration);
        this.harvesterIdGen.setDatabase(this._database);
    }

    protected String getHarvesterId() {
        String hid = "sdx_oai_harvester_" + this.docbaseId;
        return hid;
    }

    protected void configureAdminEmails(Configuration configuration) throws ConfigurationException {
        ArrayList<String> locAdminEmailsList = new ArrayList<String>();
        String firstAdminEmail = configuration.getAttribute("adminEmail", null);
        Configuration[] locAdminEmails = configuration.getChildren("adminEmail");
        if (Utilities.checkString(firstAdminEmail)) {
            locAdminEmailsList.add(firstAdminEmail);
        }
        for (int i = 0; i < locAdminEmails.length; ++i) {
            String value;
            Configuration locAdminEmail = locAdminEmails[i];
            if (locAdminEmail == null || !Utilities.checkString(value = locAdminEmail.getValue())) continue;
            locAdminEmailsList.add(value);
        }
        if (locAdminEmailsList.size() <= 0) {
            ConfigurationUtils.checkConfAttributeValue("adminEmail", null, configuration.getLocation());
        }
        this.adminEmails = locAdminEmailsList.toArray(new String[0]);
        locAdminEmailsList.clear();
        locAdminEmailsList = null;
    }

    protected void configureDataProviders(Configuration configuration) throws ConfigurationException {
        Configuration[] repoRequestConfs;
        Configuration dataProvidersConf;
        if (configuration != null && (dataProvidersConf = configuration.getChild("oai-data-providers", false)) != null && (repoRequestConfs = dataProvidersConf.getChildren("oai-repository")) != null) {
            for (int x = 0; x < repoRequestConfs.length; ++x) {
                Configuration repoRequestConf = repoRequestConfs[x];
                if (repoRequestConf == null) continue;
                if (this.storedRequests == null) {
                    this.storedRequests = new Hashtable();
                }
                String repoUrl = repoRequestConf.getAttribute("url");
                String repoGranularity = repoRequestConf.getAttribute("granularity", "YYYY-MM-DDThh:mm:ssZ");
                this.checkGranularity(repoGranularity);
                this.configureStoreRepositories(repoUrl, repoRequestConf);
                Configuration updateConf = repoRequestConf.getChild("update", false);
                Configuration[] verbConfs = repoRequestConf.getChildren("oai-verb");
                if (verbConfs != null) {
                    for (int y = 0; y < verbConfs.length; ++y) {
                        try {
                            OAIRequestImpl request = null;
                            Configuration verbConf = verbConfs[y];
                            if (verbConf == null) continue;
                            String verb = verbConf.getAttribute("name");
                            String mdPrefix = verbConf.getAttribute("metadataPrefix");
                            ConfigurationUtils.checkConfAttributeValue("metadataPrefix", mdPrefix, verbConf.getLocation());
                            String verbId = verbConf.getAttribute("id");
                            ConfigurationUtils.checkConfAttributeValue("id", verbId, verbConf.getLocation());
                            if (verb.equalsIgnoreCase("GetRecord")) {
                                verb = "GetRecord";
                                Configuration[] idsConf = verbConf.getChildren("oai-identifier");
                                if (idsConf != null) {
                                    for (int z = 0; z < idsConf.length; ++z) {
                                        Configuration idConf = idsConf[z];
                                        if (idConf == null) continue;
                                        String id = idConf.getValue();
                                        request = new OAIRequestImpl();
                                        request.enableLogging(this.logger);
                                        request.setRepositoryURL(repoUrl);
                                        request.setGranularity(repoGranularity);
                                        request.setVerbString(verb);
                                        request.setMetadataPrefix(mdPrefix);
                                        request.setVerbId(verbId);
                                        request.setIdentifier(id);
                                        Utilities.isObjectUnique(this.storedRequests, request.getRequestURL(), (Object)request);
                                        this.storedRequests.put(request.getRequestURL(), request);
                                        this.configureUpdateTriggers(request.getRequestURL(), updateConf);
                                    }
                                }
                                continue;
                            }
                            if (verb.equalsIgnoreCase("ListRecords")) {
                                verb = "ListRecords";
                                String from = verbConf.getAttribute("from", null);
                                String until = verbConf.getAttribute("until", null);
                                String set = verbConf.getAttribute("set", null);
                                boolean useLastHarvestDate = verbConf.getAttributeAsBoolean("useLastHarvestDate", true);
                                request = new OAIRequestImpl();
                                request.enableLogging(this.logger);
                                request.setRepositoryURL(repoUrl);
                                request.setGranularity(repoGranularity);
                                request.setVerbString(verb);
                                request.setMetadataPrefix(mdPrefix);
                                request.setVerbId(verbId);
                                request.setFrom(from);
                                request.setUseLastHarvestDate(useLastHarvestDate);
                                request.setUntil(until);
                                request.setSetIdentifier(set);
                                Utilities.isObjectUnique(this.storedRequests, request.getRequestURL(), (Object)request);
                                this.storedRequests.put(request.getRequestURL(), request);
                                this.configureUpdateTriggers(request.getRequestURL(), updateConf);
                                continue;
                            }
                            throw new ConfigurationException("this verb action is not supported for harvesting : " + verb);
                        }
                        catch (ConfigurationException e) {
                            OAIUtilities.logWarn(this.logger, e.getMessage(), (Exception)((Object)e));
                            continue;
                        }
                        catch (SDXException e) {
                            OAIUtilities.logWarn(this.logger, e.getMessage(), (Exception)((Object)e));
                        }
                    }
                }
                this.configurePipeline(repoRequestConf);
            }
            if (this.scheduler != null) {
                this.scheduler.start();
            }
        }
    }

    protected void configureUpdateTriggers(String requestUrl, Configuration updateConf) throws ConfigurationException {
        TimeTrigger trigger;
        if (Utilities.checkString(requestUrl) && updateConf != null && (trigger = new TimeTriggerFactory().createTimeTrigger(updateConf)) != null) {
            if (this.scheduler == null) {
                this.scheduler = new SimpleTimeScheduler();
            }
            this.scheduler.addTrigger(requestUrl, trigger, this);
        }
    }

    protected void configureStoreRepositories(String repoUrl, Configuration oaiRepoConf) throws ConfigurationException {
        String ref;
        if (Utilities.checkString(repoUrl) && Utilities.checkString(ref = oaiRepoConf.getAttribute("sdxRepository", null))) {
            try {
                Repository repo = null;
                Context appRepos = (Context)this.getContext().get((Object)"sdx.application.repos");
                if (appRepos != null) {
                    repo = (Repository)appRepos.get((Object)ref);
                }
                if (repo == null) {
                    repo = this.docbase.getRepository(ref);
                }
                if (this.storeRepositoriesRefs == null) {
                    this.storeRepositoriesRefs = new Hashtable();
                }
                Utilities.isObjectUnique(this.storeRepositoriesRefs, repoUrl, (Object)repo);
                this.storeRepositoriesRefs.put(repoUrl, repo);
            }
            catch (SDXException e) {
                String[] args = new String[]{ref};
                SDXException sdxE = new SDXException(this.logger, 29, args, null);
                throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
            }
            catch (ContextException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean checkGranularity(String granularity) throws ConfigurationException {
        if (Utilities.checkString(granularity)) {
            if (granularity.equals("YYYY-MM-DDThh:mm:ssZ")) {
                return true;
            }
            if (granularity.equals("YYYY-MM-DD")) {
                return true;
            }
            String[] args = new String[]{granularity, this.repoUrl};
            SDXException sdxE = new SDXException(this.logger, 47, args, null);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
        }
        return false;
    }

    protected void configurePipeline(Configuration configuration) throws ConfigurationException {
        Configuration pipeConf = configuration.getChild(Utilities.getElementName("Pipeline"), false);
        if (pipeConf != null) {
            this.pipe = new GenericPipeline();
            this.pipe.enableLogging(this.logger);
            try {
                this.pipe.service(this.manager);
                this.pipe.contextualize((Context)super.getContext());
                this.pipe.configure(pipeConf);
            }
            catch (ServiceException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
            catch (ContextException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected File getNewTempDirBatch() throws SDXException, IOException {
        if (this.tempDir == null) {
            OAIUtilities.logWarn(this.logger, 10013, null);
        }
        File ret = null;
        String childDir = "harvest-" + Utilities.encodeURL(Long.toString(new java.util.Date().getTime()), null);
        if (Utilities.checkString(this.resumptionToken)) {
            childDir = childDir + "-resumptionToken-" + this.resumptionToken;
        }
        if (this.tempDir.canWrite()) {
            ret = new File(this.tempDir, childDir);
            String[] args = new String[]{ret.getCanonicalPath()};
            OAIUtilities.logDebug(this.logger, 10014, args);
        } else {
            String[] args = new String[]{this.tempDir.getCanonicalPath()};
            OAIUtilities.logDebug(this.logger, 10014, args);
            ret = new File(Utilities.getSystemTempDir(), childDir);
            String[] args2 = new String[]{ret.getCanonicalPath()};
            OAIUtilities.logDebug(this.logger, 10015, args2);
        }
        Utilities.checkDirectory(ret.getCanonicalPath(), this.logger);
        return ret;
    }

    protected void deleteTempDirBatch() {
        if (this.tempDirBatch != null) {
            if (!this.keepHarvestedRecords) {
                try {
                    FileUtils.deleteDirectory((File)this.tempDirBatch);
                }
                catch (IOException e) {
                    OAIUtilities.logWarn(this.logger, e.getMessage(), e);
                }
            } else {
                String[] args = new String[]{this._database.getId(), this.tempDirBatch.getAbsolutePath()};
                OAIUtilities.logDebug(this.logger, 10016, args);
            }
        }
    }

    protected void deleteTempDir() {
        if (this.tempDir != null) {
            if (!this.keepHarvestedRecords) {
                try {
                    FileUtils.deleteDirectory((File)this.tempDir);
                }
                catch (IOException e) {
                    OAIUtilities.logWarn(this.logger, e.getMessage(), e);
                }
            } else {
                String[] args = new String[]{this._database.getId(), this.tempDir.getAbsolutePath()};
                OAIUtilities.logDebug(this.logger, 10016, args);
            }
        }
    }

    protected void initTempDir() throws SDXException, IOException {
        this.tempDirBatch = this.getNewTempDirBatch();
    }

    protected String getIsoDate() {
        return Date.formatDate(Date.getUtcIso8601Date());
    }

    protected void prepareRecordCapture() throws SAXException {
        try {
            if (this.tempDirBatch == null || !this.tempDirBatch.exists()) {
                this.initTempDir();
            }
            this.harvestDoc = File.createTempFile("oaiHarvestedRecord", this.TEMPFILE_SUFFIX, this.tempDirBatch);
            this.fileOs = new FileOutputStream(this.harvestDoc);
            if (this.filesProperties == null) {
                this.filesProperties = new Hashtable();
            }
            Properties props = new Properties();
            this.filesProperties.put(this.harvestDoc.getName(), props);
            this.currentOaiStatus = null;
            this.currentOaiIdentifier = null;
            this.currentMetadtaUrlIdentifier = null;
            this.currentDatestamp = null;
            this.deleteRecord = false;
            if (this.cBytes == null) {
                this.cBytes = new XMLSerializer();
                this.cBytes.enableLogging(this.logger);
                DefaultConfiguration conf = new DefaultConfiguration("conf");
                DefaultConfiguration cfTf = new DefaultConfiguration(TRANSFORMER_FACTORY);
                cfTf.setValue(this.transformerFactory);
                conf.addChild((Configuration)cfTf);
                cfTf = new DefaultConfiguration("indent");
                cfTf.setValue(this.transformerIndent);
                conf.addChild((Configuration)cfTf);
                this.cBytes.configure((Configuration)conf);
            }
            this.cBytes.setOutputStream((OutputStream)this.fileOs);
            if (this.oaiStripper == null) {
                this.oaiStripper = new OAIEnvelopStripper();
                this.oaiStripper.setConsumer((XMLConsumer)this.cBytes);
                this.firstXmlConsumer = this.oaiStripper;
            }
            super.setConsumer((XMLConsumer)this.oaiStripper);
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
        catch (SDXException e) {
            throw new SAXException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ConfigurationException e) {
            throw new SAXException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected void captureRecord() throws Exception {
        if (this.fileOs != null && this.harvestDoc != null) {
            this.fileOs.flush();
            this.fileOs.close();
            if ("deleted".equalsIgnoreCase(this.currentOaiStatus)) {
                this.resetRecordCaptureFields(true);
            } else {
                Properties oaiProps = (Properties)this.filesProperties.get(this.harvestDoc.getName());
                if (this.currentDatestamp != null) {
                    oaiProps.setProperty("datestamp", this.currentDatestamp);
                } else {
                    oaiProps.setProperty("datestamp", "");
                }
                if (this.currentOaiIdentifier != null) {
                    oaiProps.setProperty("oaiid", this.currentOaiIdentifier);
                } else {
                    oaiProps.setProperty("oaiid", "");
                }
                if (this.currentOaiStatus != null) {
                    oaiProps.setProperty("oaistatus", this.currentOaiStatus);
                } else {
                    oaiProps.setProperty("oaistatus", "");
                }
                this.resetRecordCaptureFields(false);
            }
        }
    }

    protected void resetRecordCaptureFields(boolean deleteDoc) {
        if (this.fileOs != null) {
            try {
                this.fileOs.flush();
                this.fileOs.close();
                this.fileOs = null;
            }
            catch (IOException e) {
                OAIUtilities.logException(this.logger, e);
            }
        }
        if (this.harvestDoc != null) {
            if (deleteDoc) {
                this.harvestDoc.delete();
            }
            this.harvestDoc = null;
        }
        super.setConsumer(this.firstXmlConsumer);
    }

    protected void prepareRecordForDeletion() {
        if (this.deletedDocs == null) {
            this.deletedDocs = new ArrayList();
        }
        if (Utilities.checkString(this.currentOaiIdentifier)) {
            XMLDocument deleteDoc = null;
            try {
                deleteDoc = new XMLDocument(this.currentOaiIdentifier);
            }
            catch (SDXException e) {
                // empty catch block
            }
            if (deleteDoc != null) {
                this.deletedDocs.add(deleteDoc);
                ++this.noDocsDeleted;
                if (null == this.m_docsToDeleteIds) {
                    this.m_docsToDeleteIds = new HashSet();
                }
                this.m_docsToDeleteIds.add(this.currentOaiIdentifier);
                try {
                    if (this.harvestDoc.exists()) {
                        this.harvestDoc.delete();
                    }
                }
                catch (SecurityException se) {
                    OAIUtilities.logException(this.logger, se);
                }
            }
        }
    }

    protected boolean isStartsIndexation() {
        boolean m_index;
        boolean ret = false;
        boolean indexAtHarvestEnd = true;
        boolean forceIndexOnHarvestError = false;
        boolean bl = !indexAtHarvestEnd ? false : (m_index = OAIUtilities.checkString(this.errorCode) ? forceIndexOnHarvestError : true);
        if (m_index) {
            OAIUtilities.logInfo(this.logger, 10019, null);
            ret = true;
        } else if (!indexAtHarvestEnd) {
            OAIUtilities.logInfo(this.logger, 10020, null);
        } else if (OAIUtilities.checkString(this.errorCode)) {
            String[] args = new String[]{this.errorCode};
            OAIUtilities.logInfo(this.logger, 10021, args);
        }
        return ret;
    }

    protected boolean storeHarvestedData() throws ProcessingException, IOException, SDXException, SAXException {
        boolean dataHarvested = false;
        boolean m_startIndexation = this.isStartsIndexation();
        if (m_startIndexation && this.docbase != null) {
            if (this.deletedDocs != null && this.deletedDocs.size() > 0) {
                this.deleteOAIDocuments();
            }
            IndexableDocument[] indexDocs = null;
            if (null != this.tempDir) {
                Set m_files = this.listFilesToIndex();
                ArrayList<OAIDocument> docs = new ArrayList<OAIDocument>();
                if (null == this.m_docsaddedIds) {
                    this.m_docsaddedIds = new HashSet();
                }
                IndexParameters indexParams = this.getIndexParameters();
                String fileName = null;
                File m_file = null;
                int i = 0;
                int m_nbFiles = m_files.size();
                Iterator m_it = m_files.iterator();
                while (m_it.hasNext() && null != (m_file = (File)m_it.next())) {
                    fileName = m_file.getName();
                    Properties oaiProps = (Properties)this.filesProperties.get(fileName);
                    this.currentDatestamp = oaiProps.getProperty("datestamp");
                    this.currentOaiIdentifier = oaiProps.getProperty("oaiid");
                    this.currentOaiStatus = oaiProps.getProperty("oaistatus");
                    if (this.currentOaiStatus != null && !"deleted".equalsIgnoreCase(this.currentOaiStatus)) {
                        OAIDocument metadataDoc = new OAIDocument();
                        metadataDoc.setDateString(this.currentDatestamp);
                        metadataDoc.setIdentifier(this.currentOaiIdentifier);
                        this.m_docsaddedIds.add(this.currentOaiIdentifier);
                        try {
                            metadataDoc.setContent(m_file.toURI().toURL());
                            if (docs == null) {
                                docs = new ArrayList();
                            }
                            docs.add(metadataDoc);
                            ++this.noHarvestedDocs;
                        }
                        catch (MalformedURLException e) {
                            OAIUtilities.logException(this.logger, e);
                        }
                    }
                    ++i;
                }
                indexDocs = docs.toArray(new IndexableDocument[0]);
                if (indexDocs != null) {
                    Repository repo = null;
                    if (Utilities.checkString(this.repoUrl) && this.storeRepositoriesRefs != null) {
                        repo = (Repository)this.storeRepositoriesRefs.get(this.repoUrl);
                    }
                    this.docbase.index(indexDocs, repo, indexParams, null);
                    dataHarvested = true;
                    docs = null;
                    Object var3_3 = null;
                }
            }
        }
        return dataHarvested;
    }

    private Set listFilesToIndex() {
        return this.listFilesToIndex(null, null, null);
    }

    private Set listFilesToIndex(File dir, FilenameFilter filter, Set files) {
        files = null != files ? files : new HashSet();
        dir = null != dir ? dir : this.tempDir;
        FilenameFilter filenameFilter = filter = null != filter ? filter : new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return dir.isDirectory() || name.endsWith(".sdx");
            }
        };
        if (null != dir) {
            File[] m_files = dir.listFiles(filter);
            int l = m_files.length;
            for (int i = 0; i < l; ++i) {
                if (m_files[i].isDirectory()) {
                    this.listFilesToIndex(m_files[i], filter, files);
                    continue;
                }
                files.add(m_files[i]);
            }
        }
        return files;
    }

    protected void deleteOAIDocuments() throws IOException, ProcessingException, SDXException, SAXException {
        if (this.deletedDocs != null && this.deletedDocs.size() > 0) {
            String[] args = new String[]{this.deletedDocs.size() + ""};
            OAIUtilities.logDebug(this.logger, 10028, args);
            if (null == this.m_docsdeletedids) {
                this.m_docsdeletedids = new HashSet();
            }
            SearchLocations slocs = new SearchLocations();
            slocs.enableLogging(this.logger);
            slocs.addDocumentBase(this.docbase);
            ComplexQuery cq = new ComplexQuery();
            cq.enableLogging(this.logger);
            cq.setUp(slocs, 0);
            for (int i = 0; i < this.deletedDocs.size(); ++i) {
                XMLDocument doc = (XMLDocument)this.deletedDocs.get(i);
                String sdxoaiid = doc.getId();
                this.m_docsdeletedids.add(sdxoaiid);
                FieldQuery fq = new FieldQuery();
                fq.setUp(slocs, sdxoaiid, "sdxoaiid");
                cq.addComponent(fq);
            }
            cq.prepare();
            Results res = cq.execute();
            if (res != null && res.count() > 0) {
                String[] ids = res.getDocIds();
                Document[] docs = new XMLDocument[ids.length];
                for (int j = 0; j < docs.length; ++j) {
                    docs[j] = new XMLDocument(ids[j]);
                }
                OAIUtilities.logDebug(this.logger, "Founds " + docs.length + " OAI document(s) to delete...");
                this.docbase.delete(docs, null);
            }
        }
    }

    protected void handleResumptionToken() {
        if (Utilities.checkString(this.resumptionToken) && Utilities.checkString(this.repoUrl)) {
            String verb = "";
            if (this.requestParams != null) {
                verb = this.requestParams.getParameter("verb", "");
            } else if (this.storedRequests.size() > 0) {
                verb = ((OAIRequest)this.storedRequests.get(this.requestUrl)).getVerbString();
            }
            OAIUtilities.logDebug(this.logger, "Handle resumption token " + this.resumptionToken + " for the harvester of the document base " + this.docbase.getId() + "...");
            if (Utilities.checkString(verb)) {
                this.newRequestUrl = this.repoUrl + "?" + "verb" + "=" + verb + "&" + "resumptionToken" + "=" + this.resumptionToken;
                this.resetAllFields();
            }
            super.resetResumptionToken();
        }
    }

    protected void prepareResourceFromUrlIdentifierCapture() {
        if (Utilities.checkString(this.currentMetadtaUrlIdentifier)) {
            try {
                URL resourceUrl = new URL(this.currentMetadtaUrlIdentifier);
                XMLDocument resource = new XMLDocument();
                resource.setId(this.currentMetadtaUrlIdentifier);
                resource.setContent(resourceUrl);
                this.urlResource = resource;
            }
            catch (MalformedURLException e) {
                OAIUtilities.logException(this.logger, e);
            }
            catch (SDXException e) {
                OAIUtilities.logException(this.logger, (Exception)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureResourceFromUrlIdentifier() {
        if (this.urlResource != null) {
            try {
                IncludeXMLConsumer include;
                block8: {
                    include = new IncludeXMLConsumer((ContentHandler)((Object)this.synchronizedXmlConsumer));
                    this.urlResource.setConsumer((XMLConsumer)include);
                    include.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "urlResource", "sdx:urlResource", (Attributes)new AttributesImpl());
                    SAXParser parser = null;
                    try {
                        parser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
                        this.urlResource.parse(parser);
                        Object var4_6 = null;
                        if (parser == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        if (parser != null) {
                            this.manager.release((Object)parser);
                        }
                        this.urlResource = null;
                        include.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "urlResource", "sdx:urlResource");
                        throw throwable;
                    }
                    this.manager.release((Object)parser);
                }
                this.urlResource = null;
                include.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "urlResource", "sdx:urlResource");
                {
                }
            }
            catch (SAXException e) {
                OAIUtilities.logException(this.logger, e);
            }
            catch (ServiceException e) {
                OAIUtilities.logException(this.logger, (Exception)((Object)e));
            }
            catch (SDXException e) {
                OAIUtilities.logException(this.logger, (Exception)((Object)e));
            }
        }
    }

    protected void resetAllFields() {
        this.deletedDocs = null;
        this.urlResource = null;
        this.resetRecordCaptureFields(false);
        this.deleteTempDirBatch();
        this.tempDirBatch = null;
        super.resetAllFields();
    }

    protected void endHarvest() {
        this.noDocsDeleted = 0;
        this.noHarvestedDocs = 0;
        this.deleteTempDir();
        this.tempDir = null;
    }

    protected IndexParameters getIndexParameters() {
        IndexParameters params = new IndexParameters();
        params.setSendIndexationEvents(5);
        params.setBatchMax(this.noRecordsPerBatch);
        if (this.pipe != null) {
            params.setPipeline(this.pipe);
        } else if (this.docbase != null) {
            params.setPipeline(this.docbase.getIndexationPipeline());
        }
        params.setPipelineParams(super.getHarvestParameters());
        return params;
    }

    public void sendStoredHarvestingRequests() throws SAXException {
        try {
            block6: {
                try {
                    if (this.storedRequests == null || this.storedRequests.size() <= 0) break block6;
                    this.acquire();
                    super.acquireSynchronizedXMLConsumer();
                    super.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "storedHarvestRequests", "sdx:storedHarvestRequests", null);
                    Enumeration requests = this.storedRequests.elements();
                    if (requests != null) {
                        while (requests.hasMoreElements()) {
                            OAIRequest request = (OAIRequest)requests.nextElement();
                            if (request == null) continue;
                            request.toSAX((ContentHandler)((Object)this));
                        }
                    }
                    super.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "storedHarvestRequests", "sdx:storedHarvestRequests");
                }
                catch (InterruptedException e) {
                    throw new SAXException(e.getMessage(), e);
                }
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            super.releaseSynchronizedXMLConsumer();
            this.release();
            throw throwable;
        }
        super.releaseSynchronizedXMLConsumer();
        this.release();
    }

    public synchronized void targetTriggered(String triggerName) {
        String[] args = new String[]{triggerName};
        if (this.logger.isInfoEnabled()) {
            OAIUtilities.logInfo(this.logger, 10022, args);
        }
        if (this.docbase == null) {
            if (this.logger.isErrorEnabled()) {
                OAIUtilities.logError(this.logger, 10023, args);
            }
            return;
        }
        OAIRequest request = (OAIRequest)this.storedRequests.get(triggerName);
        if (request != null) {
            boolean useLastHarvestDate = request.getUseLastHarvestDate();
            if (useLastHarvestDate) {
                try {
                    DatabaseEntity dbe = this._database.getEntity(request.getVerbId());
                    if (dbe != null) {
                        String lastHarvestDate = dbe.getProperty(OAI_HARVESTER_LAST_UPDATED);
                        request.setFrom(lastHarvestDate);
                    }
                }
                catch (SDXException e) {
                    OAIUtilities.logException(this.logger, (Exception)((Object)e));
                }
            }
            String requestUrl = request.getRequestURL();
            String[] args2 = new String[]{requestUrl};
            if (this.logger.isInfoEnabled()) {
                OAIUtilities.logDebug(this.logger, 10025, args2);
            }
            this.receiveSynchronizedRequest(requestUrl, triggerName);
            this.endHarvest();
            if (this.logger.isInfoEnabled()) {
                OAIUtilities.logInfo(this.logger, 10026, args2);
            }
        }
    }

    public void startElement(String s, String s1, String s2, Attributes attributes) throws SAXException {
        if (Utilities.checkString(this.identifierName) && attributes != null && this.identifierName.equals(attributes.getValue("name"))) {
            this.captureElemContent = true;
        }
        super.startElement(s, s1, s2, attributes);
    }

    public void endElement(String s, String s1, String s2) throws SAXException {
        if (this.sBuff != null && this.sBuff.length() > 0) {
            String content = this.sBuff.toString();
            if (!"http://www.openarchives.org/OAI/2.0/".equals(s) && "field".equals(s1)) {
                this.currentMetadtaUrlIdentifier = content;
                try {
                    this.prepareResourceFromUrlIdentifierCapture();
                }
                catch (Exception e) {
                    OAIUtilities.logException(this.logger, e);
                }
            }
        }
        super.endElement(s, s1, s2);
    }

    protected boolean shouldHarvestDocument() {
        boolean ret;
        block6: {
            ret = true;
            try {
                OAIRequest request = (OAIRequest)this.storedRequests.get(this.requestUrl);
                if (request != null && request.getVerbId() != null && !request.getVerbId().equals("") && this._database.entityExists(request.getVerbId())) {
                    DatabaseEntity dbe = this._database.getEntity(request.getVerbId());
                    String formattedDate = dbe.getProperty(OAI_HARVESTER_LAST_UPDATED);
                    java.util.Date lastUpdatedDate = Date.parseDate(formattedDate);
                    java.util.Date currentDocumentDate = Date.parseDate(this.currentDatestamp);
                    if (currentDocumentDate.getTime() > lastUpdatedDate.getTime()) {
                        return ret;
                    }
                    break block6;
                }
                if (!Utilities.checkString(this.currentOaiIdentifier)) break block6;
                ComplexQuery cq = new ComplexQuery();
                SearchLocations slocs = new SearchLocations();
                slocs.enableLogging(this.logger);
                slocs.addDocumentBase(this.docbase);
                cq.enableLogging(this.logger);
                cq.setUp(slocs, 1);
                FieldQuery fq = new FieldQuery();
                fq.setUp(slocs, this.currentOaiIdentifier, "sdxoaiid");
                cq.addComponent(fq);
                DateIntervalQuery dq = new DateIntervalQuery();
                java.util.Date currentOaiDocumentDate = Date.parseDate(this.currentDatestamp);
                dq.setUp(slocs, "sdxoaidate", currentOaiDocumentDate, null, true);
                cq.addComponent(dq);
                cq.prepare();
                Results res = cq.execute();
                if (res != null && res.count() == 1) {
                    ret = false;
                    break block6;
                }
                if (res != null && res.count() > 1) {
                    OAIUtilities.logError(this.logger, "A problem occured during harvesting: " + res.count() + " documents correspond to the OAI identifier: " + this.currentOaiIdentifier, null);
                    break block6;
                }
                return ret;
            }
            catch (SDXException e) {
                OAIUtilities.logException(this.logger, (Exception)((Object)e));
            }
        }
        return ret;
    }

    protected void saveCriticalFields(boolean dataHarvested) throws SAXException {
        try {
            OAIRequest request = (OAIRequest)this.storedRequests.get(this.requestUrl);
            String verbId = request.getVerbId();
            String[] args = new String[13];
            args[0] = this.requestUrl;
            args[1] = this.repoUrl;
            if (request != null && Utilities.checkString(verbId)) {
                Iterator m_it;
                String verb;
                String granularity;
                Property[] props;
                DatabaseEntity dbe = this._database.getEntity(verbId);
                if (dbe == null) {
                    dbe = new DatabaseEntity(verbId);
                }
                if (!Utilities.checkString(dbe.getId())) {
                    dbe.setId(verbId);
                }
                if ((props = dbe.getProperties()).length > 0) {
                    for (int i = 0; i < props.length; ++i) {
                        dbe.deleteProperty(props[i].getName());
                    }
                }
                if (Utilities.checkString(this.requestUrl)) {
                    dbe.addProperty("oaiRequestUrl", this.requestUrl);
                }
                if (Utilities.checkString(this.repoUrl)) {
                    dbe.addProperty("oaiRepositoryUrl", this.repoUrl);
                }
                if (Utilities.checkString(granularity = request.getGranularity()) && Utilities.checkString(this.responseDate)) {
                    String resd = "";
                    if (granularity.equals("YYYY-MM-DDThh:mm:ssZ")) {
                        resd = this.responseDate;
                    } else if (granularity.equals("YYYY-MM-DD")) {
                        resd = this.responseDate.substring(0, this.responseDate.indexOf("T"));
                    }
                    dbe.addProperty(OAI_HARVESTER_LAST_UPDATED, resd);
                    String string = args[2] = Utilities.checkString(resd) ? resd : "";
                }
                if (Utilities.checkString(verb = request.getVerbString())) {
                    String mdPrefix;
                    dbe.addProperty(OAI_VERB, verb);
                    args[3] = Utilities.checkString(verb) ? verb : "";
                    args[4] = mdPrefix = request.getMetadataPrefix();
                    if (Utilities.checkString(mdPrefix)) {
                        dbe.addProperty(OAI_METADATA_PREFIX, mdPrefix);
                    }
                    String id = "";
                    if (verb.equals("GetRecord") && Utilities.checkString(id = this.requestParams.getParameter("identifier", null))) {
                        dbe.addProperty(OAI_IDENTIFIER, id);
                    }
                    String string = args[5] = Utilities.checkString(id) ? id : "";
                    if (verb.equals("ListRecords")) {
                        String from = request.getFrom();
                        if (Utilities.checkString(from)) {
                            dbe.addProperty(OAI_FROM, from);
                        }
                        args[6] = Utilities.checkString(from) ? from : "";
                        String until = request.getUntil();
                        if (Utilities.checkString(until)) {
                            dbe.addProperty(OAI_UNTIL, until);
                        }
                        args[7] = Utilities.checkString(until) ? until : "";
                        String set = request.getSetIdentifier();
                        if (Utilities.checkString(set)) {
                            dbe.addProperty(OAI_SET, set);
                        }
                        String string2 = args[8] = Utilities.checkString(set) ? set : "";
                    }
                }
                if (Utilities.checkString(this.resumptionToken)) {
                    dbe.addProperty(OAI_HARVESTER_RESUMPTION_TOKEN, this.resumptionToken);
                }
                dbe.addProperty(NO_DOCS_DELETED, Integer.toString(this.noDocsDeleted));
                dbe.addProperty(NO_DOCS_HARVESTED, Integer.toString(this.noHarvestedDocs));
                args[9] = this.noDocsDeleted > 0 ? this.noDocsDeleted + "" : "0";
                args[10] = this.noHarvestedDocs > 0 ? this.noHarvestedDocs + "" : "0";
                StringBuffer m_sb = null;
                if (null != this.m_docsaddedIds && !this.m_docsaddedIds.isEmpty()) {
                    m_sb = new StringBuffer(this.m_docsaddedIds.size());
                    m_it = this.m_docsaddedIds.iterator();
                    int i = 0;
                    while (m_it.hasNext()) {
                        m_sb.append("\n\t" + ++i + " : " + (String)m_it.next());
                    }
                    m_it = null;
                    m_sb.trimToSize();
                }
                args[11] = null != m_sb && m_sb.length() > 0 ? m_sb.toString() : "";
                m_sb = null;
                if (null != this.m_docsdeletedids && !this.m_docsdeletedids.isEmpty()) {
                    m_sb = new StringBuffer(this.m_docsdeletedids.size());
                    m_it = this.m_docsdeletedids.iterator();
                    int i = 0;
                    while (m_it.hasNext()) {
                        m_sb.append("\n\t" + ++i + " : " + (String)m_it.next());
                    }
                    m_it = null;
                    m_sb.trimToSize();
                }
                args[12] = null != m_sb && m_sb.length() > 0 ? m_sb.toString() : "";
                this._database.update(dbe);
                this._database.optimize();
                OAIUtilities.logInfo(this.logger, 10027, args);
            }
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    protected String generateNewHarvestId() {
        return this.harvesterIdGen.generate();
    }

    public void sendPastHarvestsSummary() throws SAXException {
        try {
            block8: {
                try {
                    DatabaseEntity[] dbes = this._database.getEntities();
                    if (dbes == null || dbes.length <= 0) break block8;
                    this.acquire();
                    this.acquireSynchronizedXMLConsumer();
                    super.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "previousHarvests", "sdx:previousHarvests", null);
                    for (int i = 0; i < dbes.length; ++i) {
                        Property[] props;
                        DatabaseEntity dbe = dbes[i];
                        AttributesImpl atts = new AttributesImpl();
                        String repoUrl = null;
                        if (dbe != null && (props = dbe.getProperties()) != null) {
                            for (int j = 0; j < props.length; ++j) {
                                String propName;
                                Property prop = props[j];
                                if (prop == null || !Utilities.checkString(propName = prop.getName()) || OAI_HARVEST_ID.equals(propName)) continue;
                                String propVal = prop.getValue();
                                if (propName.equals("oaiRepositoryUrl")) {
                                    repoUrl = propVal;
                                    continue;
                                }
                                if (!Utilities.checkString(propVal)) continue;
                                atts.addAttribute("", propName, propName, "CDATA", propVal);
                            }
                        }
                        this.sendElement("http://www.openarchives.org/OAI/2.0/", "request", "request", atts, repoUrl);
                    }
                    super.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "previousHarvests", "sdx:previousHarvests");
                }
                catch (Exception e) {
                    throw new SAXException(e.getMessage(), e);
                }
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.releaseSynchronizedXMLConsumer();
            this.release();
            throw throwable;
        }
        this.releaseSynchronizedXMLConsumer();
        this.release();
    }

    public java.util.Date lastUpdated() {
        return this.docbase.lastModificationDate();
    }

    public void purgePastHarvestsData() {
        try {
            DatabaseEntity[] dbes = this._database.getEntities();
            for (int i = 0; i < dbes.length; ++i) {
                DatabaseEntity dbe = dbes[i];
                this._database.delete(dbe);
            }
            this._database.optimize();
        }
        catch (SDXException e) {
            OAIUtilities.logException(this.logger, (Exception)((Object)e));
        }
    }

    protected void storeFailedHarvestData(Exception e) {
        try {
            DatabaseEntity dbe = new DatabaseEntity(this.generateNewHarvestId());
            String message = "noMessage";
            if (e != null) {
                message = e.getMessage();
            }
            dbe.addProperty(OAI_FAILED_HARVEST, message);
            dbe.addProperty("oaiRequestUrl", this.requestUrl);
            this._database.update(dbe);
            this._database.optimize();
        }
        catch (SDXException e1) {
            OAIUtilities.logException(this.logger, (Exception)((Object)e1));
        }
    }

    public void backup(SaveParameters save_config) throws SDXException {
        if (save_config != null && save_config.getAttributeAsBoolean("all", false)) {
            String oai_path = "oai-harvester";
            File oai_dir = new File(save_config.getStoreCompletePath() + File.separator + oai_path);
            if (!oai_dir.exists()) {
                oai_dir.mkdir();
            }
        }
    }

    public void restore(SaveParameters save_config) throws SDXException {
    }

    public void close() {
        if (this.scheduler != null && this.storedRequests != null) {
            String tn = null;
            Enumeration e = this.storedRequests.elements();
            while (e.hasMoreElements()) {
                tn = (String)e.nextElement();
                if (!Utilities.checkString(tn)) continue;
                this.scheduler.removeTrigger(tn);
            }
            this.storedRequests = new Hashtable();
            this.scheduler = null;
        }
    }
}

