/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.query.AbstractQuery;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.search.lucene.query.TermInfo;
import fr.gouv.culture.sdx.search.lucene.query.Terms;
import fr.gouv.culture.sdx.search.lucene.queryparser.ParseException;
import fr.gouv.culture.sdx.search.lucene.queryparser.QueryParser;
import fr.gouv.culture.sdx.utils.Utilities;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LinearQuery
extends AbstractQuery {
    private Vector components = new Vector();

    public void setUp(SearchLocations sLocs, String[] queryTerms, String[] fields, int[] connectors, int operator) throws SDXException {
        super.setSearchLocations(sLocs);
        if (queryTerms == null) {
            throw new SDXException(super.getLog(), 4108, null, null);
        }
        String currentField = null;
        int currentConnector = -1;
        TermQuery currentQuery = null;
        BooleanQuery myQuery = Utilities.newBooleanQuery();
        try {
            for (int i = 0; i < queryTerms.length; ++i) {
                if (!Utilities.checkString(queryTerms[i]) || queryTerms[i].equals(" ")) continue;
                String currentTerm = queryTerms[i];
                if (fields != null && i < fields.length && Utilities.checkString(fields[i]) && !fields[i].equals(" ")) {
                    currentField = fields[i];
                } else if (currentField == null) {
                    currentField = this.searchLocations.getDefaultField().getCode();
                }
                if (connectors != null && i < connectors.length) {
                    currentConnector = connectors[i];
                }
                if (currentConnector == -1) {
                    currentConnector = 1;
                }
                this.components.add(new LinearQueryComponent(currentField, currentTerm, currentConnector));
                Field theField = this.searchLocations.getField(currentField);
                if (theField == null) {
                    String[] args = new String[]{currentField};
                    throw new SDXException(super.getLog(), 4001, args, null);
                }
                int fieldType = this.searchLocations.getFieldType(currentField);
                switch (fieldType) {
                    case 0: {
                        QueryParser qp = this.searchLocations.getQueryParser();
                        if (qp == null) {
                            throw new SDXException(super.getLog(), 4109, null, null);
                        }
                        qp.setUp(theField.getCode(), theField.getAnalyzer());
                        qp.setOperator(operator);
                        currentQuery = qp.parse(currentTerm);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        if (currentTerm.indexOf("*") != -1 || currentTerm.indexOf("?") != -1) {
                            Terms terms = new Terms();
                            terms.enableLogging(super.getLog());
                            terms.setUp(this.searchLocations, theField.getCode(), currentTerm);
                            TreeMap termList = terms.getList();
                            Iterator it = termList.values().iterator();
                            if (termList.size() < 1) {
                                currentQuery = new TermQuery(new Term(theField.getCode(), currentTerm));
                                break;
                            }
                            currentQuery = Utilities.newBooleanQuery();
                            while (it.hasNext()) {
                                ((BooleanQuery)currentQuery).add((Query)new TermQuery(((TermInfo)it.next()).getTerm()), BooleanClause.Occur.SHOULD);
                            }
                            break;
                        }
                        currentQuery = new TermQuery(new Term(theField.getCode(), currentTerm));
                        break;
                    }
                    case 2: {
                        Date date = fr.gouv.culture.sdx.utils.Date.parseDate(currentTerm);
                        currentQuery = date == null ? new TermQuery(new Term(theField.getCode(), currentTerm)) : new TermQuery(new Term(theField.getCode(), DateField.dateToString(date)));
                    }
                }
                boolean prohibited = false;
                if (currentConnector == 2) {
                    prohibited = true;
                }
                boolean required = false;
                if (currentConnector == 1) {
                    required = true;
                }
                if (currentQuery == null) continue;
                if (required) {
                    myQuery.add((Query)currentQuery, BooleanClause.Occur.MUST);
                }
                if (prohibited) {
                    myQuery.add((Query)currentQuery, BooleanClause.Occur.MUST_NOT);
                    continue;
                }
                myQuery.add((Query)currentQuery, BooleanClause.Occur.SHOULD);
            }
            this.luceneQuery = myQuery;
        }
        catch (ParseException e) {
            String[] args = new String[]{myQuery.toString()};
            throw new SDXException(super.getLog(), 4101, args, e);
        }
    }

    public void toSAX(ContentHandler hdl) throws SAXException {
        String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
        String sdxNsPrefix = "sdx";
        String localName = "query";
        String qName = sdxNsPrefix + ":" + localName;
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "type", "type", "CDATA", "linear");
        atts = super.addAttributesLucene(atts);
        hdl.startElement(sdxNsUri, localName, qName, atts);
        this.getSearchLocations().toSAX(hdl);
        if (this.filter != null) {
            this.filter.toSAX(hdl);
        }
        if (this.baseQuery != null) {
            String bqLocalName = "baseQuery";
            String bqQName = sdxNsPrefix + ":" + bqLocalName;
            AttributesImpl emptyAtts = new AttributesImpl();
            hdl.startElement(sdxNsUri, bqLocalName, bqQName, emptyAtts);
            this.baseQuery.toSAX(hdl);
            hdl.endElement(sdxNsUri, bqLocalName, bqQName);
        }
        for (int i = 0; i < this.components.size(); ++i) {
            LinearQueryComponent c = (LinearQueryComponent)this.components.get(i);
            c.toSAX(hdl);
        }
        hdl.endElement(sdxNsUri, localName, qName);
    }

    private class LinearQueryComponent {
        private String fieldname;
        private String text;
        private int operator;

        public LinearQueryComponent(String f, String t, int op) {
            this.fieldname = f;
            this.text = t;
            this.operator = op;
        }

        public void toSAX(ContentHandler hdl) throws SAXException {
            String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
            String sdxNsPrefix = "sdx";
            String localName = "component";
            String qName = sdxNsPrefix + ":" + localName;
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "field", "field", "CDATA", this.fieldname);
            atts.addAttribute("", "text", "text", "CDATA", this.text);
            switch (this.operator) {
                case 1: {
                    atts.addAttribute("", "operator", "operator", "CDATA", "and");
                    break;
                }
                case 0: {
                    atts.addAttribute("", "operator", "operator", "CDATA", "or");
                    break;
                }
                case 2: {
                    atts.addAttribute("", "operator", "operator", "CDATA", "not");
                }
            }
            hdl.startElement(sdxNsUri, localName, qName, atts);
            hdl.endElement(sdxNsUri, localName, qName);
        }
    }
}

