/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.documentbase.DocumentBase;
import fr.gouv.culture.sdx.documentbase.LuceneDocumentBase;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.Searchable;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.query.Index;
import fr.gouv.culture.sdx.search.lucene.query.LuceneIndex;
import fr.gouv.culture.sdx.search.lucene.queryparser.DefaultQueryParser;
import fr.gouv.culture.sdx.search.lucene.queryparser.QueryParser;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Vector;
import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.ParallelMultiSearcher;
import org.apache.lucene.search.Searcher;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SearchLocations
extends AbstractSdxObject
implements fr.gouv.culture.sdx.search.SearchLocations {
    private Vector dbs = new Vector();
    private Vector indices = new Vector();
    private QueryParser queryParser = null;

    public void setUp(Index index) {
        this.addIndex(index);
    }

    public void setUp(DocumentBase db) {
        this.addDocumentBase(db);
    }

    public void addIndex(Index index) {
        if (index == null) {
            return;
        }
        if (!this.contains(index)) {
            this.indices.add(index);
        }
    }

    public void addDocumentBase(DocumentBase db) {
        if (db == null) {
            return;
        }
        if (!this.contains(db)) {
            this.dbs.add(db);
        }
    }

    public Field getDefaultField() throws SDXException {
        try {
            if (this.size() > 0) {
                return ((LuceneDocumentBase)this.dbs.get(0)).getIndex().getDefaultField();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public DocumentBase getFirstDocumentBase() {
        return this.size() > 0 ? (DocumentBase)this.dbs.get(0) : null;
    }

    public Field getField(String name) throws SDXException {
        return this.getFirstField(name);
    }

    public int getFieldType(String name) throws SDXException {
        Field f = this.getFirstField(name);
        if (f == null) {
            return 0;
        }
        return f.getFieldType();
    }

    public String getTypeName(String name) throws SDXException {
        Field f = this.getFirstField(name);
        if (f != null) {
            return f.getTypeName();
        }
        return null;
    }

    private Field getFirstField(String name) {
        if (name == null) {
            return null;
        }
        try {
            if (this.size() > 0) {
                return ((LuceneDocumentBase)this.dbs.get(0)).getIndex().getField(name);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public Vector getDocumentBases() {
        return this.dbs;
    }

    public HashSet getDocumentBasesNames() {
        HashSet<String> _return = new HashSet<String>(this.size());
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            _return.add(((DocumentBase)this.dbs.get(i)).getId());
        }
        return _return;
    }

    public int size() {
        return this.dbs.size();
    }

    public boolean contains(DocumentBase db) {
        if (this.dbs == null) {
            return false;
        }
        return this.dbs.contains(db);
    }

    public boolean contains(Index index) {
        if (index == null) {
            return false;
        }
        return this.indices.contains(index);
    }

    public Locale getLocale(String name) throws SDXException {
        Field f = this.getFirstField(name);
        if (f == null) {
            return null;
        }
        return f.getLocale();
    }

    public IndexReader _getReader(int idx) throws SDXException {
        if (idx >= 0 && idx <= this.indices.size()) {
            LuceneIndex lIndex = null;
            Index index = (Index)this.indices.elementAt(idx);
            if (index instanceof LuceneIndex) {
                lIndex = (LuceneIndex)index;
            }
            if (lIndex != null) {
                return lIndex.getReader();
            }
            return null;
        }
        return null;
    }

    public IndexReader _getReader() throws SDXException {
        try {
            IndexReader[] readers = new IndexReader[this.indices.size()];
            for (int i = 0; i < this.indices.size(); ++i) {
                readers[i] = ((LuceneIndex)this.indices.get(i)).getReader();
            }
            return new MultiReader(readers);
        }
        catch (IOException e) {
            String[] args = new String[]{e.getMessage()};
            throw new SDXException(super.getLog(), 4503, args, e);
        }
    }

    public IndexReader getReader(int idb) throws SDXException {
        if (idb >= 0 && idb <= this.size()) {
            LuceneDocumentBase lDb = null;
            DocumentBase db = (DocumentBase)this.dbs.elementAt(idb);
            if (db instanceof LuceneDocumentBase) {
                lDb = (LuceneDocumentBase)db;
            }
            if (lDb != null) {
                return lDb.getIndexReader();
            }
            return null;
        }
        return null;
    }

    public IndexReader getReader() throws SDXException {
        try {
            IndexReader[] readers = new IndexReader[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                readers[i] = ((LuceneDocumentBase)this.dbs.get(i)).getIndexReader();
            }
            return new MultiReader(readers);
        }
        catch (IOException e) {
            String[] args = new String[]{e.getMessage()};
            throw new SDXException(super.getLog(), 4503, args, e);
        }
    }

    public Searcher _getSearcher(int idx) throws SDXException {
        try {
            if (idx >= 0 && idx <= this.indices.size()) {
                LuceneIndex lIndex = null;
                Index index = (Index)this.indices.elementAt(idx);
                if (index instanceof LuceneIndex) {
                    lIndex = (LuceneIndex)index;
                }
                if (lIndex != null) {
                    return new ParallelMultiSearcher(new org.apache.lucene.search.Searchable[]{lIndex.getSearcher()});
                }
                return null;
            }
            return null;
        }
        catch (IOException e) {
            String[] args = new String[]{e.getMessage()};
            throw new SDXException(super.getLog(), 4500, args, e);
        }
    }

    public Searcher _getSearcher() throws SDXException {
        try {
            Searcher[] searchers = new Searcher[this.indices.size()];
            for (int i = 0; i < this.indices.size(); ++i) {
                LuceneIndex index = (LuceneIndex)this.indices.elementAt(i);
                searchers[i] = index.getSearcher();
            }
            return new ParallelMultiSearcher((org.apache.lucene.search.Searchable[])searchers);
        }
        catch (IOException e) {
            String[] args = new String[]{e.getMessage()};
            throw new SDXException(super.getLog(), 4500, args, e);
        }
    }

    public Searcher getSearcher(int idb) throws SDXException {
        try {
            if (idb >= 0 && idb <= this.size()) {
                LuceneDocumentBase lDb = null;
                DocumentBase db = (DocumentBase)this.dbs.elementAt(idb);
                if (db instanceof LuceneDocumentBase) {
                    lDb = (LuceneDocumentBase)db;
                }
                if (lDb != null) {
                    return new ParallelMultiSearcher(new org.apache.lucene.search.Searchable[]{lDb.getSearcher()});
                }
                return null;
            }
            return null;
        }
        catch (IOException e) {
            String[] args = new String[]{e.getMessage()};
            throw new SDXException(super.getLog(), 4500, args, e);
        }
    }

    public Searcher getSearcher() throws SDXException {
        try {
            Searcher[] searchers = new Searcher[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                LuceneDocumentBase db = (LuceneDocumentBase)this.dbs.elementAt(i);
                searchers[i] = db.getSearcher();
            }
            return new ParallelMultiSearcher((org.apache.lucene.search.Searchable[])searchers);
        }
        catch (IOException e) {
            String[] args = new String[]{e.getMessage()};
            throw new SDXException(super.getLog(), 4500, args, e);
        }
    }

    public QueryParser getQueryParser() {
        if (this.queryParser != null) {
            return this.queryParser;
        }
        if (this.size() > 0) {
            try {
                return ((LuceneDocumentBase)this.dbs.get(0)).getIndex().getQueryParser();
            }
            catch (SDXException e) {
                return new DefaultQueryParser();
            }
            catch (IOException e) {
                return new DefaultQueryParser();
            }
        }
        return new DefaultQueryParser();
    }

    public void setQueryParser(QueryParser qParser) {
        this.queryParser = qParser;
    }

    public void toSAX(ContentHandler hdl) throws SAXException {
        String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
        String sdxNsPrefix = "sdx";
        String localName = "searchLocations";
        String qName = sdxNsPrefix + ":" + localName;
        AttributesImpl atts = new AttributesImpl();
        hdl.startElement(sdxNsUri, localName, qName, atts);
        for (int i = 0; i < this.size(); ++i) {
            Index index;
            if (!(this.dbs.get(i) instanceof org.apache.lucene.search.Searchable) || !((index = ((Searchable)this.dbs.get(i)).getIndex()) instanceof XMLizable)) continue;
            ((XMLizable)index).toSAX(hdl);
        }
        hdl.endElement(sdxNsUri, localName, qName);
    }

    protected String getClassNameSuffix() {
        return "SearchLocations";
    }

    protected boolean initToSax() {
        return true;
    }

    protected void initVolatileObjectsToSax() {
    }
}

