/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.database.DatabaseConnection;
import fr.gouv.culture.sdx.utils.database.DatabaseEntity;
import fr.gouv.culture.sdx.utils.database.JDBCDatabase;
import fr.gouv.culture.sdx.utils.database.Property;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ORACLEDatabase
extends JDBCDatabase {
    protected String getTableCreationQuery() {
        return "CREATE TABLE " + this.getTableName() + " ( " + "id" + " VARCHAR(255) NOT NULL, " + "propertyName" + " VARCHAR(255) NOT NULL, " + "propertyValue" + " VARCHAR(255) NOT NULL, " + "PRIMARY KEY (" + "id" + ", " + "propertyName" + ", " + "propertyValue" + "))";
    }

    protected String getCreateIndiciesQuery(String fieldName) {
        return "CREATE INDEX " + this.getTableName() + "_" + fieldName + " ON " + this.getTableName() + " (" + fieldName + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws SDXException {
        DatabaseConnection sqlDbConn;
        block12: {
            sqlDbConn = this.getConnection();
            Connection conn = null;
            ResultSet rs = null;
            try {
                try {
                    conn = sqlDbConn.getConnection();
                    Statement st = conn.createStatement();
                    rs = st.executeQuery("SELECT * FROM " + this.getTableName() + " WHERE " + "id" + " = '_____'");
                }
                catch (SQLException e) {
                    this.createTable(conn);
                    Object var6_7 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e2) {
                            String[] args = new String[]{this.getId(), e2.getMessage()};
                            throw new SDXException(super.getLog(), 3200, args, e2);
                        }
                    }
                    if (sqlDbConn == null) return;
                    sqlDbConn.commit();
                    this.releaseConnection(sqlDbConn);
                    return;
                }
                Object var6_6 = null;
                if (rs == null) break block12;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (rs != null) {
                    try {}
                    catch (SQLException e2) {
                        String[] args = new String[]{this.getId(), e2.getMessage()};
                        throw new SDXException(super.getLog(), 3200, args, e2);
                    }
                    rs.close();
                }
                if (sqlDbConn == null) throw throwable;
                sqlDbConn.commit();
                this.releaseConnection(sqlDbConn);
                throw throwable;
            }
            try {}
            catch (SQLException e2) {
                String[] args = new String[]{this.getId(), e2.getMessage()};
                throw new SDXException(super.getLog(), 3200, args, e2);
            }
            rs.close();
        }
        if (sqlDbConn == null) return;
        sqlDbConn.commit();
        this.releaseConnection(sqlDbConn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createIndicies(Connection conn) throws SDXException {
        PreparedStatement st = null;
        try {
            try {
                st = conn.prepareStatement(this.getCreateIndiciesQuery("id"));
                st.clearParameters();
                st.execute();
            }
            catch (SQLException e) {
                String[] args = new String[]{this.getTableName(), this.getId()};
                throw new SDXException(super.getLog(), 310, args, e);
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            try {
                if (st == null) throw throwable;
                st.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        if (st == null) return;
        st.close();
        return;
    }

    public synchronized void save(DatabaseEntity ent) throws SDXException {
        if (ent == null) {
            super.save(ent);
        } else {
            Property[] props = ent.getProperties();
            if (props == null || props.length == 0) {
                ent.addProperty("_", "_");
            }
            super.save(ent);
        }
    }
}

