/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline.impl;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CachedResponse;
import org.apache.cocoon.caching.CachingOutputStream;
import org.apache.cocoon.caching.ComponentCacheKey;
import org.apache.cocoon.components.pipeline.impl.AbstractCachingProcessingPipeline;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.apache.cocoon.components.sax.XMLTeePipe;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLProducer;

public class CachingProcessingPipeline
extends AbstractCachingProcessingPipeline {
    protected void cacheResults(Environment environment, OutputStream os) throws Exception {
        if (this.toCacheKey != null) {
            CachedResponse response;
            Long expiresObj = (Long)environment.getObjectModel().get("expires");
            if (this.cacheCompleteResponse) {
                response = new CachedResponse(this.toCacheSourceValidities, ((CachingOutputStream)os).getContent(), expiresObj);
                response.setContentType(environment.getContentType());
            } else {
                response = new CachedResponse(this.toCacheSourceValidities, (byte[])this.xmlSerializer.getSAXFragment(), expiresObj);
            }
            this.cache.store(this.toCacheKey, response);
        }
    }

    protected ComponentCacheKey newComponentCacheKey(int type, String role, Serializable key) {
        return new ComponentCacheKey(type, role, key);
    }

    protected void connectCachingPipeline(Environment environment) throws ProcessingException {
        try {
            XMLSerializer localXMLSerializer = null;
            if (!this.cacheCompleteResponse) {
                localXMLSerializer = this.xmlSerializer = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
            }
            if (this.cachedResponse == null) {
                XMLConsumer next;
                XMLProducer prev = this.generator;
                int cacheableTransformerCount = this.firstNotCacheableTransformerIndex;
                Iterator itt = this.transformers.iterator();
                while (itt.hasNext()) {
                    next = (XMLConsumer)itt.next();
                    if (localXMLSerializer != null) {
                        if (cacheableTransformerCount == 0) {
                            next = new XMLTeePipe(next, localXMLSerializer);
                            localXMLSerializer = null;
                        } else {
                            --cacheableTransformerCount;
                        }
                    }
                    this.connect(environment, prev, next);
                    prev = (XMLProducer)((Object)next);
                }
                next = this.lastConsumer;
                if (localXMLSerializer != null) {
                    next = new XMLTeePipe(next, localXMLSerializer);
                    localXMLSerializer = null;
                }
                this.connect(environment, prev, next);
            } else {
                XMLConsumer next;
                XMLProducer prev = this.xmlDeserializer = (XMLDeserializer)this.manager.lookup(XMLDeserializer.ROLE);
                int cacheableTransformerCount = 0;
                Iterator itt = this.transformers.iterator();
                while (itt.hasNext()) {
                    next = (XMLConsumer)itt.next();
                    if (cacheableTransformerCount >= this.firstProcessedTransformerIndex) {
                        if (localXMLSerializer != null && cacheableTransformerCount == this.firstNotCacheableTransformerIndex) {
                            next = new XMLTeePipe(next, localXMLSerializer);
                            localXMLSerializer = null;
                        }
                        this.connect(environment, prev, next);
                        prev = (XMLProducer)((Object)next);
                    }
                    ++cacheableTransformerCount;
                }
                next = this.lastConsumer;
                if (localXMLSerializer != null) {
                    next = new XMLTeePipe(next, localXMLSerializer);
                    localXMLSerializer = null;
                }
                this.connect(environment, prev, next);
            }
        }
        catch (ComponentException e) {
            throw new ProcessingException("Could not connect pipeline.", e);
        }
    }
}

