/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.store.impl;

import java.io.File;
import java.io.IOException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.util.IOUtils;
import org.apache.excalibur.store.impl.AbstractFilesystemStore;

public final class FilesystemStore
extends AbstractFilesystemStore
implements Contextualizable,
Parameterizable {
    protected File workDir;
    protected File cacheDir;

    public void contextualize(Context context) throws ContextException {
        this.workDir = (File)context.get((Object)"work-directory");
        this.cacheDir = (File)context.get((Object)"cache-directory");
    }

    public void parameterize(Parameters params) throws ParameterException {
        try {
            if (params.getParameterAsBoolean("use-cache-directory", false)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using cache directory: " + this.cacheDir);
                }
                this.setDirectory(this.cacheDir);
            } else if (params.getParameterAsBoolean("use-work-directory", false)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using work directory: " + this.workDir);
                }
                this.setDirectory(this.workDir);
            } else if (params.getParameter("directory", null) != null) {
                String dir = params.getParameter("directory");
                dir = IOUtils.getContextFilePath(this.workDir.getPath(), dir);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using directory: " + dir);
                }
                this.setDirectory(new File(dir));
            } else {
                try {
                    this.setDirectory(this.workDir);
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
            throw new ParameterException("Unable to set directory", (Throwable)e);
        }
    }
}

