/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.matching;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.matching.Matcher;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;

public class MountTableMatcher
extends AbstractLogEnabled
implements Matcher,
ThreadSafe,
Serviceable,
Parameterizable {
    private ServiceManager manager;
    private SourceResolver resolver;
    private Map mountTables = Collections.synchronizedMap(new HashMap());
    private boolean ignoreMissingTables;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.ignoreMissingTables = params.getParameterAsBoolean("ignore-missing-tables", false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map getMountTable(String src) throws Exception {
        HashMap<String, String> hashMap;
        Source source;
        block15: {
            Map map;
            block14: {
                Map map2;
                block13: {
                    Map map3;
                    block12: {
                        source = null;
                        try {
                            try {
                                source = this.resolver.resolveURI(src);
                                String uri = source.getURI();
                                if (!source.exists()) {
                                    if (!this.ignoreMissingTables) throw new PatternException("Mount table does not exist: '" + uri + "'");
                                    map3 = Collections.EMPTY_MAP;
                                    Object var13_8 = null;
                                    if (source == null) return map3;
                                    break block12;
                                }
                                Object[] values = (Object[])this.mountTables.get(uri);
                                if (values != null) {
                                    int valid;
                                    SourceValidity oldValidity = (SourceValidity)values[1];
                                    int n = valid = oldValidity != null ? oldValidity.isValid() : -1;
                                    if (valid == 1) {
                                        map2 = (Map)values[0];
                                        break block13;
                                    }
                                    if (valid == 0 && oldValidity.isValid(source.getValidity()) == 1) {
                                        map = (Map)values[0];
                                        break block14;
                                    }
                                } else {
                                    values = new Object[2];
                                }
                                HashMap<String, String> mounts = new HashMap<String, String>();
                                DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
                                Configuration config = builder.build(SourceUtil.getInputSource(source));
                                Configuration[] children = config.getChildren();
                                for (int i = 0; i < children.length; ++i) {
                                    Configuration child = children[i];
                                    if (!"mount".equals(child.getName())) throw new PatternException("Unexpected element '" + child.getName() + "' (awaiting 'mount'), at " + child.getLocation());
                                    String prefix = children[i].getAttribute("uri-prefix");
                                    if (!prefix.endsWith("/") && prefix.length() != 0) {
                                        prefix = prefix + '/';
                                    }
                                    mounts.put(prefix, children[i].getAttribute("src"));
                                }
                                values[0] = mounts;
                                values[1] = source.getValidity();
                                this.mountTables.put(uri, values);
                                hashMap = mounts;
                                break block15;
                            }
                            catch (SecurityException e) {
                                if (!this.ignoreMissingTables) throw new PatternException("Mount table is not accessible: '" + src + "' (" + e + ")");
                                Map map4 = Collections.EMPTY_MAP;
                                Object var13_12 = null;
                                if (source == null) return map4;
                                this.resolver.release(source);
                                return map4;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var13_13 = null;
                            if (source == null) throw throwable;
                            this.resolver.release(source);
                            throw throwable;
                        }
                    }
                    this.resolver.release(source);
                    return map3;
                }
                Object var13_9 = null;
                if (source == null) return map2;
                this.resolver.release(source);
                return map2;
            }
            Object var13_10 = null;
            if (source == null) return map;
            this.resolver.release(source);
            return map;
        }
        Object var13_11 = null;
        if (source == null) return hashMap;
        this.resolver.release(source);
        return hashMap;
    }

    public Map match(String pattern, Map objectModel, Parameters parameters) throws PatternException {
        Map mounts;
        try {
            mounts = this.getMountTable(pattern);
        }
        catch (PatternException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PatternException(e);
        }
        Request request = ObjectModelHelper.getRequest(objectModel);
        String uri = request.getSitemapURI();
        Iterator iter = mounts.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String prefix = (String)entry.getKey();
            if (!uri.startsWith(prefix)) continue;
            HashMap<String, String> result = new HashMap<String, String>(2);
            result.put("uri-prefix", prefix);
            result.put("src", (String)entry.getValue());
            return result;
        }
        return null;
    }
}

