/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.pattern;

import java.io.Serializable;
import net.sourceforge.chaperon.model.Violations;

public abstract class Pattern
implements Serializable,
Cloneable {
    private int minOccurs = 1;
    private int maxOccurs = 1;
    private String location = null;

    public void setMinOccurs(int minOccurs) {
        if (minOccurs >= 0) {
            this.minOccurs = minOccurs;
        }
    }

    public void setMinOccursAsString(String value) {
        this.minOccurs = 1;
        if (value != null && value.length() > 0) {
            try {
                this.minOccurs = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.minOccurs = 1;
            }
            if (this.minOccurs < 0) {
                this.minOccurs = 0;
            }
        }
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public String getMinOccursAsString() {
        return String.valueOf(this.minOccurs);
    }

    public void setMaxOccurs(int maxOccurs) {
        if (maxOccurs >= this.minOccurs) {
            this.maxOccurs = maxOccurs;
        }
    }

    public void setMaxOccursAsString(String value) {
        this.maxOccurs = 1;
        if (value != null && value.length() > 0) {
            if (value.equals("*")) {
                this.maxOccurs = Integer.MAX_VALUE;
            } else {
                try {
                    this.maxOccurs = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    this.maxOccurs = 1;
                }
                if (this.maxOccurs < 1) {
                    this.maxOccurs = 1;
                }
            }
        }
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public String getMaxOccursAsString() {
        if (this.maxOccurs == Integer.MAX_VALUE) {
            return "*";
        }
        return String.valueOf(this.maxOccurs);
    }

    public abstract Object clone() throws CloneNotSupportedException;

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public abstract Violations validate();
}

