/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.process;

import java.util.HashSet;
import net.sourceforge.chaperon.common.Decoder;
import net.sourceforge.chaperon.process.LexicalAutomaton;
import net.sourceforge.chaperon.process.PatternProcessor;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class LexicalProcessor
implements ContentHandler,
LexicalHandler {
    public static final String NS = "http://chaperon.sourceforge.net/schema/text/1.0";
    public static final String TEXT = "text";
    public static final String NS_OUTPUT = "http://chaperon.sourceforge.net/schema/lexer/2.0";
    public static final String OUTPUT = "output";
    public static final String LEXEME = "lexeme";
    public static final String GROUP = "group";
    public static final String ERROR = "error";
    private ContentHandler contentHandler = null;
    private LexicalHandler lexicalHandler = null;
    private static final int STATE_OUTSIDE = 0;
    private static final int STATE_TEXT = 1;
    private int state = 0;
    private Locator locator = null;
    private LocatorImpl locatorImpl = null;
    private LexicalAutomaton automaton = null;
    private Log log = null;
    private boolean grouping = false;
    private boolean localizable = false;
    private String source;
    private int lineNumber;
    private int columnNumber;
    private StringBuffer buffer = null;
    private char[] text = null;
    private HashSet prefixes = new HashSet();

    public LexicalProcessor() {
    }

    public LexicalProcessor(LexicalAutomaton automaton) {
        this.automaton = automaton;
    }

    public void setLexicalAutomaton(LexicalAutomaton automaton) {
        this.automaton = automaton;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setGrouping(boolean grouping) {
        this.grouping = grouping;
    }

    public void setLocalizable(boolean localizable) {
        this.localizable = localizable;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        this.locatorImpl = null;
        if (locator != null) {
            this.locatorImpl = new LocatorImpl(locator);
            this.contentHandler.setDocumentLocator(this.locatorImpl);
        }
    }

    public void startDocument() throws SAXException {
        if (this.locatorImpl != null) {
            this.locatorImpl.setLineNumber(this.locator.getLineNumber());
            this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        }
        this.contentHandler.startDocument();
        this.state = 0;
        this.buffer = new StringBuffer();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.state == 0) {
            if (namespaceURI != null && namespaceURI.equals(NS) && localName.equals(TEXT)) {
                this.state = 1;
                this.buffer = new StringBuffer();
                this.source = atts.getValue("source") != null ? atts.getValue("source") : (this.locator != null ? this.locator.getSystemId() : "unknown");
                this.columnNumber = atts.getValue("column") != null ? Integer.parseInt(atts.getValue("column")) : (this.locator != null ? this.locator.getColumnNumber() : 1);
                this.lineNumber = atts.getValue("line") != null ? Integer.parseInt(atts.getValue("line")) : (this.locator != null ? this.locator.getLineNumber() : 1);
            } else {
                this.contentHandler.startElement(namespaceURI, localName, qName, atts);
            }
        } else if (this.state == 1) {
            throw new SAXException("Unexpected start element '" + qName + "'.");
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.state == 0) {
            this.contentHandler.characters(ch, start, length);
        } else if (this.state == 1) {
            this.buffer.append(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.state == 0) {
            this.contentHandler.characters(ch, start, length);
        } else if (this.state == 1) {
            this.buffer.append(ch, start, length);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.state == 0) {
            this.contentHandler.endElement(namespaceURI, localName, qName);
        } else if (this.state == 1) {
            if (namespaceURI != null && namespaceURI.equals(NS) && localName.equals(TEXT)) {
                this.state = 0;
                this.handleEndDocument();
            } else {
                throw new SAXException("Unexpected end element '" + qName + "'.");
            }
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.locatorImpl != null) {
            this.locatorImpl.setLineNumber(this.locator.getLineNumber());
            this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        }
        if (!uri.equals(NS)) {
            this.contentHandler.startPrefixMapping(prefix, uri);
        } else {
            this.prefixes.add(prefix);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.locatorImpl != null) {
            this.locatorImpl.setLineNumber(this.locator.getLineNumber());
            this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        }
        if (this.prefixes.contains(prefix)) {
            this.prefixes.remove(prefix);
        } else {
            this.contentHandler.endPrefixMapping(prefix);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.locatorImpl != null) {
            this.locatorImpl.setLineNumber(this.locator.getLineNumber());
            this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        }
        if (this.state == 0) {
            this.contentHandler.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.locatorImpl != null) {
            this.locatorImpl.setLineNumber(this.locator.getLineNumber());
            this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        }
        if (this.state == 0) {
            this.contentHandler.skippedEntity(name);
        }
    }

    public void endDocument() throws SAXException {
        if (this.locatorImpl != null) {
            this.locatorImpl.setLineNumber(this.locator.getLineNumber());
            this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        }
        if (this.state == 0) {
            this.contentHandler.endDocument();
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    public void endDTD() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    public void startEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, len);
        }
    }

    public void handleEndDocument() throws SAXException {
        PatternProcessor processor = new PatternProcessor();
        this.text = this.buffer.toString().toCharArray();
        int position = 0;
        if (this.locatorImpl != null) {
            this.locatorImpl.setSystemId(this.source);
            this.locatorImpl.setLineNumber(this.lineNumber);
            this.locatorImpl.setColumnNumber(this.columnNumber);
        }
        this.contentHandler.startPrefixMapping("", NS_OUTPUT);
        AttributesImpl atts = new AttributesImpl();
        if (this.localizable) {
            atts.addAttribute("", "source", "source", "CDATA", this.source);
        }
        this.contentHandler.startElement(NS_OUTPUT, OUTPUT, OUTPUT, atts);
        StringBuffer unrecognized = new StringBuffer();
        while (position < this.text.length) {
            String tokensymbol = null;
            String tokentext = null;
            int lexemeindex = this.automaton.getLexemeCount() - 1;
            while (lexemeindex >= 0) {
                processor.setPatternAutomaton(this.automaton.getLexemeDefinition(lexemeindex));
                if (processor.match(this.text, position) && (tokentext == null || processor.getGroup().length() >= tokentext.length())) {
                    tokensymbol = this.automaton.getLexemeSymbol(lexemeindex);
                    tokentext = processor.getGroup();
                }
                --lexemeindex;
            }
            if (tokentext != null && tokentext.length() == 0) {
                this.log.warn((Object)("Lexical processor recognized empty lexeme '" + tokensymbol + "'"));
            }
            if (tokentext != null && tokentext.length() > 0) {
                if (unrecognized.length() > 0) {
                    if (this.log != null) {
                        this.log.debug((Object)("Text was not recognized " + Decoder.toString(unrecognized.toString())));
                    }
                    atts = new AttributesImpl();
                    atts.addAttribute("", TEXT, TEXT, "CDATA", unrecognized.toString());
                    if (this.localizable) {
                        atts.addAttribute("", "line", "line", "CDATA", String.valueOf(this.lineNumber));
                        atts.addAttribute("", "column", "column", "CDATA", String.valueOf(this.columnNumber));
                    }
                    this.contentHandler.startElement(NS_OUTPUT, ERROR, ERROR, atts);
                    this.contentHandler.endElement(NS_OUTPUT, ERROR, ERROR);
                    this.increasePosition(position - unrecognized.length(), unrecognized.length());
                    unrecognized = new StringBuffer();
                }
                if (tokensymbol != null) {
                    if (this.log != null) {
                        this.log.debug((Object)("Recognize token " + tokensymbol + " with " + Decoder.toString(tokentext)));
                    }
                    if (this.locatorImpl != null) {
                        this.locatorImpl.setLineNumber(this.locator.getLineNumber());
                        this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
                    }
                    atts = new AttributesImpl();
                    atts.addAttribute("", "symbol", "symbol", "CDATA", tokensymbol);
                    atts.addAttribute("", TEXT, TEXT, "CDATA", tokentext);
                    if (this.localizable) {
                        atts.addAttribute("", "line", "line", "CDATA", String.valueOf(this.lineNumber));
                        atts.addAttribute("", "column", "column", "CDATA", String.valueOf(this.columnNumber));
                    }
                    this.contentHandler.startElement(NS_OUTPUT, LEXEME, LEXEME, atts);
                    if (this.grouping) {
                        int i = 1;
                        while (i < processor.getGroupCount()) {
                            AttributesImpl groupatts = new AttributesImpl();
                            groupatts.addAttribute("", TEXT, TEXT, "CDATA", processor.getGroup(i));
                            this.contentHandler.startElement(NS_OUTPUT, GROUP, GROUP, groupatts);
                            this.contentHandler.endElement(NS_OUTPUT, GROUP, GROUP);
                            ++i;
                        }
                    }
                    this.contentHandler.endElement(NS_OUTPUT, LEXEME, LEXEME);
                } else if (this.log != null) {
                    this.log.debug((Object)("Ignore lexeme with " + Decoder.toString(tokentext)));
                }
                if (this.locatorImpl != null) {
                    this.locatorImpl.setColumnNumber(this.columnNumber);
                    this.locatorImpl.setLineNumber(this.lineNumber);
                }
                this.increasePosition((position += tokentext.length()) - tokentext.length(), tokentext.length());
                continue;
            }
            if (this.locatorImpl != null) {
                this.locatorImpl.setColumnNumber(this.columnNumber);
                this.locatorImpl.setLineNumber(this.lineNumber);
            }
            unrecognized.append(this.text[position]);
            ++position;
        }
        if (unrecognized.length() > 0) {
            if (this.log != null) {
                this.log.debug((Object)("Text was not recognized " + Decoder.toString(unrecognized.toString())));
            }
            atts = new AttributesImpl();
            atts.addAttribute("", TEXT, TEXT, "CDATA", unrecognized.toString());
            if (this.localizable) {
                atts.addAttribute("", "line", "line", "CDATA", String.valueOf(this.lineNumber));
                atts.addAttribute("", "column", "column", "CDATA", String.valueOf(this.columnNumber));
            }
            this.contentHandler.startElement(NS_OUTPUT, ERROR, ERROR, atts);
            this.contentHandler.endElement(NS_OUTPUT, ERROR, ERROR);
            this.increasePosition(position - unrecognized.length(), unrecognized.length());
        }
        if (this.locatorImpl != null) {
            this.locatorImpl.setLineNumber(this.locator.getLineNumber());
            this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        }
        this.contentHandler.endElement(NS_OUTPUT, OUTPUT, OUTPUT);
        this.contentHandler.endPrefixMapping("");
    }

    private void increasePosition(int position, int length) {
        int i = position;
        while (i < position + length) {
            if (this.text[i] == '\n') {
                this.columnNumber = 1;
                ++this.lineNumber;
            } else if (this.text[i] == '\r' && (i == this.text.length - 1 || this.text[i + 1] != '\n')) {
                this.columnNumber = 1;
                ++this.lineNumber;
            } else {
                ++this.columnNumber;
            }
            ++i;
        }
    }
}

