/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.process;

import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ParseException
extends SAXException {
    private boolean location = false;
    private String source;
    private int lineNumber;
    private int columnNumber;

    public ParseException(String message) {
        super(message);
    }

    public ParseException(String message, String source, int lineNumber, int columnNumber) {
        super(message);
        this.source = source;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.location = true;
    }

    public ParseException(String message, Locator locator) {
        super(message);
        if (locator != null) {
            this.source = locator.getSystemId();
            this.lineNumber = locator.getLineNumber();
            this.columnNumber = locator.getColumnNumber();
            this.location = true;
        }
    }

    public boolean isLocalized() {
        return this.location;
    }

    public String getSource() {
        return this.source;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String toString() {
        if (this.location) {
            return this.getMessage() + "[" + this.lineNumber + ":" + this.columnNumber + "]";
        }
        return this.getMessage();
    }

    public void toXML(ContentHandler contentHandler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (this.getMessage() != null) {
            atts.addAttribute("", "message", "message", "CDATA", this.getMessage());
        }
        if (this.isLocalized()) {
            if (this.getSource() != null && this.getSource().length() > 0) {
                atts.addAttribute("", "source", "source", "CDATA", String.valueOf(this.getSource()));
            }
            atts.addAttribute("", "line", "line", "CDATA", String.valueOf(this.getLineNumber()));
            atts.addAttribute("", "column", "column", "CDATA", String.valueOf(this.getColumnNumber()));
        }
        contentHandler.startElement("http://chaperon.sourceforge.net/schema/syntaxtree/2.0", "error", "error", atts);
        contentHandler.endElement("http://chaperon.sourceforge.net/schema/syntaxtree/2.0", "error", "error");
    }
}

