/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.process.extended;

import java.util.EmptyStackException;
import net.sourceforge.chaperon.process.extended.StackNode;

public class StackNodeSet {
    private StackNode[] nodes = new StackNode[10];
    private int position = 0;
    private int count = 0;
    public int watchdog = 0;

    public void push(StackNode stackNode) {
        ++this.watchdog;
        int i = 0;
        while (i < this.count) {
            if (this.nodes[i].pattern == stackNode.pattern) {
                StackNode node = this.nodes[i];
                while (node != null) {
                    if (node.ancestor == stackNode.ancestor) {
                        return;
                    }
                    if (node.sibling == null) {
                        node.sibling = stackNode;
                        break;
                    }
                    node = node.sibling;
                }
                if (i < this.position) {
                    this.position = 0;
                }
                return;
            }
            ++i;
        }
        if (this.nodes.length == this.count + 1) {
            StackNode[] newNodes = new StackNode[this.nodes.length + 10];
            System.arraycopy(this.nodes, 0, newNodes, 0, this.nodes.length);
            this.nodes = newNodes;
        }
        this.nodes[this.count++] = stackNode;
    }

    public StackNode pop() {
        if (this.position >= this.count) {
            throw new EmptyStackException();
        }
        return this.nodes[this.position++];
    }

    public void clear() {
        this.position = 0;
        this.count = 0;
        this.watchdog = 0;
    }

    public boolean isEmpty() {
        return this.position >= this.count;
    }

    public int size() {
        return this.count - this.position;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        int i = 0;
        while (i < this.count) {
            if (i == this.position) {
                buffer.append("|");
            }
            buffer.append(this.nodes[i].toString());
            if (i + 1 != this.position && i < this.count - 1) {
                buffer.append(",");
            }
            ++i;
        }
        if (this.count == this.position) {
            buffer.append("|");
        }
        buffer.append("}\n");
        return buffer.toString();
    }

    public String dump() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.count) {
            buffer.append(this.nodes[i].dump());
            ++i;
        }
        return buffer.toString();
    }
}

