/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import net.sf.pizzacompiler.compiler.AST;
import net.sf.pizzacompiler.compiler.ASTgen;
import net.sf.pizzacompiler.compiler.ASTmake;
import net.sf.pizzacompiler.compiler.Basic;
import net.sf.pizzacompiler.compiler.Constants;
import net.sf.pizzacompiler.compiler.DoubleConst;
import net.sf.pizzacompiler.compiler.FloatConst;
import net.sf.pizzacompiler.compiler.IntConst;
import net.sf.pizzacompiler.compiler.LongConst;
import net.sf.pizzacompiler.compiler.Name;
import net.sf.pizzacompiler.compiler.Position;
import net.sf.pizzacompiler.compiler.Report;
import net.sf.pizzacompiler.compiler.Scanner;
import net.sf.pizzacompiler.compiler.StringConst;
import net.sf.pizzacompiler.compiler.Switches;
import net.sf.pizzacompiler.lang.List;
import pizza.support.ObjectArray;
import pizza.support.array;

class Parser
implements Constants {
    private static final int TYPE = 1;
    private static final int EXPR = 2;
    private static final int PATT = 4;
    private static final int STAT = 8;
    private static final int infixPrecedenceLevels = 10;
    private Scanner S;
    private static Name byteS = Name.fromString("byte");
    private static Name booleanS = Name.fromString("boolean");
    private static Name charS = Name.fromString("char");
    private static Name doubleS = Name.fromString("double");
    private static Name floatS = Name.fromString("float");
    private static Name intS = Name.fromString("int");
    private static Name longS = Name.fromString("long");
    private static Name shortS = Name.fromString("short");
    private static Name voidS = Name.fromString("void");
    private static int[] prec = new int[117];

    Parser(Scanner scanner) {
        this.S = scanner;
    }

    private void skip() {
        int n = 0;
        int n2 = 0;
        while (true) {
            switch (this.S.token) {
                case 64: 
                case 77: 
                case 114: {
                    return;
                }
                case 12: {
                    if (n != 0 || n2 != 0) break;
                    return;
                }
                case 18: {
                    if (n == 0) {
                        return;
                    }
                    --n;
                    break;
                }
                case 14: {
                    if (n2 <= 0) break;
                    --n2;
                    break;
                }
                case 17: {
                    ++n;
                    break;
                }
                case 13: {
                    ++n2;
                    break;
                }
            }
            this.S.nexttoken();
        }
    }

    private void syntaxError(int n, String string) {
        if (this.S.pos != this.S.errPos) {
            Report.error(n, string);
        }
        this.skip();
        this.S.errPos = this.S.pos;
    }

    private void syntaxError(String string) {
        this.syntaxError(this.S.pos, string);
    }

    private void accept(int n) {
        if (this.S.token == n) {
            this.S.nexttoken();
        } else {
            int n2 = Position.line(this.S.pos) > Position.line(this.S.lastpos) ? this.S.lastpos : this.S.pos;
            this.syntaxError(n2, String.valueOf(this.S.token2string(n)).concat(String.valueOf(" expected")));
            if (this.S.token == n) {
                this.S.nexttoken();
            }
        }
    }

    private AST illegal(int n, int n2) {
        this.syntaxError(n, String.valueOf("illegal start of ").concat(String.valueOf((n2 & 2) != 0 ? "expression" : ((n2 & 1) != 0 ? "type" : "identifier"))));
        return ASTgen.at(n).Ident(Basic.errorS);
    }

    private Name ident() {
        if (this.S.token == 1) {
            Name name = this.S.name;
            this.S.nexttoken();
            return name;
        }
        this.accept(1);
        return Basic.errorS;
    }

    private AST qualident(int n) {
        AST aST;
        int n2 = this.S.pos;
        if (this.S.token == 1) {
            aST = ASTgen.at(n2).Ident(this.ident());
        } else {
            int n3 = this.typeTag(this.S.token);
            if (n3 >= 0) {
                this.S.nexttoken();
                aST = ASTgen.at(n2).TypeIdent(n3);
            } else {
                aST = this.illegal(n2, n);
            }
        }
        while (this.S.token == 10) {
            this.S.nexttoken();
            if ((n & 2) != 0) {
                if (this.S.token == 64) {
                    aST = ASTgen.at(this.S.pos).Select(aST, Basic.classS);
                    ASTmake.lastkind = 4;
                    this.S.nexttoken();
                    break;
                }
                if (this.S.token == 89) {
                    aST = ASTgen.at(this.S.pos).Self(aST, Basic.thisS);
                    this.S.nexttoken();
                    break;
                }
                if (this.S.token == 86) {
                    aST = ASTgen.at(this.S.pos).Self(aST, Basic.superS);
                    this.S.nexttoken();
                    if (this.S.token == 13) break;
                    Report.error(n2, "illegal qualifier for super");
                    break;
                }
                if (this.S.token == 79) {
                    this.S.nexttoken();
                    aST = this.innerConstructor(aST);
                    break;
                }
            }
            if (ASTmake.lastkind != 8) {
                aST = ASTgen.at(this.S.pos).Select(aST, this.ident());
                continue;
            }
            this.syntaxError(n2, "basic type cannot be dereferenced");
        }
        if (!this.isExpr() && (n & 5) == 0 || !this.isType() && (n & 2) == 0) {
            aST = this.illegal(n2, n);
        }
        return aST;
    }

    private int typeTag(int n) {
        switch (n) {
            case 98: {
                return 1;
            }
            case 97: {
                return 8;
            }
            case 99: {
                return 2;
            }
            case 100: {
                return 7;
            }
            case 101: {
                return 6;
            }
            case 102: {
                return 4;
            }
            case 103: {
                return 5;
            }
            case 104: {
                return 3;
            }
            case 105: {
                return 9;
            }
        }
        return -1;
    }

    private int modifiers() {
        int n = 0;
        if (this.S.deprecatedFlag) {
            n = 131072;
            this.S.deprecatedFlag = false;
        }
        while (true) {
            int n2;
            switch (this.S.token) {
                case 81: {
                    n2 = 2;
                    break;
                }
                case 82: {
                    n2 = 4;
                    break;
                }
                case 83: {
                    n2 = 1;
                    break;
                }
                case 85: {
                    n2 = 8;
                    break;
                }
                case 93: {
                    n2 = 128;
                    break;
                }
                case 71: {
                    n2 = 16;
                    break;
                }
                case 60: {
                    n2 = 1024;
                    break;
                }
                case 78: {
                    n2 = 256;
                    break;
                }
                case 90: {
                    n2 = 64;
                    break;
                }
                case 88: {
                    n2 = 32;
                    break;
                }
                case 115: {
                    n2 = 2048;
                    break;
                }
                case 66: {
                    if (!Switches.pizza) {
                        return n;
                    }
                    n2 = 0x200000;
                    break;
                }
                default: {
                    return n;
                }
            }
            if ((n & n2) != 0) {
                Report.error(this.S.pos, "repeated modifier");
            }
            n |= n2;
            this.S.nexttoken();
        }
    }

    private int optFinal() {
        if (this.S.token == 71) {
            this.S.nexttoken();
            return 16;
        }
        return 0;
    }

    private AST term(int n) {
        AST aST;
        if (this.S.token == 111 && (n & 4) != 0) {
            aST = ASTgen.at(this.S.pos).VarDef(null, 0, null, null);
            this.S.nexttoken();
            ASTmake.lastkind = 4;
        } else if (this.S.token == 71 && (n & 4) != 0) {
            this.S.nexttoken();
            int n2 = this.S.pos;
            Name name = this.S.name;
            aST = this.type();
            if (this.S.token == 1) {
                aST = ASTgen.at(this.S.pos).VarDef(this.ident(), 16, aST, null);
            } else if (this.isIdent()) {
                aST = ASTgen.at(n2).VarDef(name, 16, null, null);
            }
        } else {
            aST = this.term1(n);
            if ((this.S.token == 34 || 44 <= this.S.token && this.S.token <= 54) && (n & 2) != 0 && this.isExpr()) {
                int n3 = this.S.pos;
                int n4 = this.S.token;
                this.S.nexttoken();
                aST = this.makeAssignment(n3, n4, aST, this.term(2));
            } else if (this.S.token == 1 && (n & 4) != 0 && this.isType()) {
                aST = ASTgen.at(this.S.pos).VarDef(this.ident(), 0, aST, null);
            }
        }
        return aST;
    }

    private AST term1(int n) {
        AST aST = this.term2(n);
        if (this.S.token == 32 && (n & 2) != 0 && this.isExpr()) {
            int n2 = this.S.pos;
            this.S.nexttoken();
            AST aST2 = this.term1(2);
            this.accept(33);
            AST aST3 = this.term1(2);
            aST = ASTgen.at(n2).Conditional(aST, aST2, aST3);
            ASTmake.lastkind = 4;
        }
        return aST;
    }

    private AST term2(int n) {
        AST aST = this.term3(n);
        if (prec[this.S.token] >= 0 && (n & 2) != 0 && this.isExpr()) {
            AST[] aSTArray = new AST[11];
            int[] nArray = new int[10];
            int n2 = 0;
            aSTArray[n2] = aST;
            while (prec[this.S.token] >= 0) {
                nArray[n2] = this.S.token;
                int n3 = this.S.pos;
                this.S.nexttoken();
                aSTArray[++n2] = this.term3(2);
                while (n2 > 0 && prec[nArray[n2 - 1]] >= prec[this.S.token]) {
                    aSTArray[n2 - 1] = this.makeBinop(n3, nArray[n2 - 1], aSTArray[n2 - 1], aSTArray[n2]);
                    --n2;
                }
            }
            aST = aSTArray[n2];
        }
        return aST;
    }

    private AST term3(int n) {
        AST aST = this.term4(n);
        if (this.S.token == 96 && (n & 2) != 0 && this.isExpr()) {
            int n2 = this.S.pos;
            this.S.nexttoken();
            aST = ASTgen.at(n2).Typeop(30, aST, this.type());
        }
        return aST;
    }

    private AST term4(int n) {
        AST aST;
        if ((n & 2) != 0) {
            switch (this.S.token) {
                case 20: 
                case 21: 
                case 22: 
                case 28: 
                case 35: 
                case 36: {
                    int n2 = this.S.token;
                    int n3 = this.S.pos;
                    if (n2 == 21) {
                        this.S.token = 107;
                    }
                    this.S.nexttoken();
                    return this.makePreop(n3, n2, this.term4(2));
                }
            }
        }
        int n4 = this.S.pos;
        if (this.S.token == 13 && (n & 2) != 0 | Switches.pizza) {
            aST = this.parTerm(n);
        } else if (this.S.token == 108) {
            n4 = this.S.pos;
            aST = this.lambda(n4);
        } else if (this.S.token == 1 || this.typeTag(this.S.token) >= 0) {
            aST = this.qualident(n);
        } else if ((n & 2) != 0) {
            switch (this.S.token) {
                case 79: {
                    this.S.nexttoken();
                    aST = this.constructor();
                    break;
                }
                case 89: {
                    aST = ASTgen.at(this.S.pos).Self(null, Basic.thisS);
                    this.S.nexttoken();
                    break;
                }
                case 86: {
                    aST = ASTgen.at(this.S.pos).Self(null, Basic.superS);
                    this.S.nexttoken();
                    break;
                }
                case 3: {
                    aST = ASTgen.at(this.S.pos).Literal(new StringConst(this.S.name));
                    this.S.nexttoken();
                    break;
                }
                case 2: {
                    aST = ASTgen.at(this.S.pos).Literal(new IntConst(2, (int)this.S.intVal));
                    this.S.nexttoken();
                    break;
                }
                case 4: {
                    aST = Integer.MIN_VALUE <= this.S.intVal && this.S.intVal <= Integer.MAX_VALUE ? ASTgen.at(this.S.pos).Literal(new IntConst((int)this.S.intVal)) : ASTgen.at(this.S.pos).Literal(new LongConst(this.S.intVal));
                    this.S.nexttoken();
                    break;
                }
                case 5: {
                    aST = ASTgen.at(this.S.pos).Literal(new LongConst(this.S.intVal));
                    this.S.nexttoken();
                    break;
                }
                case 6: {
                    aST = ASTgen.at(this.S.pos).Literal(new FloatConst((float)this.S.floatVal));
                    this.S.nexttoken();
                    break;
                }
                case 7: {
                    aST = ASTgen.at(this.S.pos).Literal(new DoubleConst(this.S.floatVal));
                    this.S.nexttoken();
                    break;
                }
                case 106: {
                    aST = ASTgen.at(this.S.pos).Ident(Basic.nullS);
                    this.S.nexttoken();
                    break;
                }
                default: {
                    if (Switches.experimental && this.S.token == 109) {
                        this.S.nexttoken();
                        aST = ASTgen.at(n4).Seq(this.block());
                        break;
                    }
                    aST = this.illegal(this.S.pos, n);
                    break;
                }
            }
        } else {
            aST = this.illegal(this.S.pos, n);
        }
        block22: while (true) {
            switch (this.S.token) {
                case 10: {
                    if ((n & 2) != 0 && this.isExpr()) {
                        this.S.nexttoken();
                        if (this.S.token == 79) {
                            this.S.nexttoken();
                            aST = this.innerConstructor(aST);
                            break;
                        }
                        if (this.S.token == 86) {
                            aST = ASTgen.at(this.S.pos).Self(aST, Basic.superS);
                            this.S.nexttoken();
                            if (this.S.token == 13) continue block22;
                            Report.error(n4, "illegal qualifier for super");
                            break;
                        }
                        aST = ASTgen.at(this.S.pos).Select(aST, this.ident());
                        break;
                    }
                    if ((n & 1) == 0 || !this.isType()) break block22;
                    this.S.nexttoken();
                    aST = ASTgen.at(this.S.pos).Select(aST, this.ident());
                    break;
                }
                case 15: {
                    this.S.nexttoken();
                    if (this.S.token == 16 && this.isType()) {
                        int n5 = this.S.pos;
                        this.S.nexttoken();
                        aST = this.brackets(ASTgen.at(aST.pos).ArrayTypeTerm(aST));
                        if (this.S.token == 10 && (n & 2) != 0) {
                            this.S.nexttoken();
                            aST = ASTgen.at(this.S.pos).Select(aST, Basic.classS);
                            ASTmake.lastkind = 4;
                            this.accept(64);
                            break block22;
                        }
                        if ((n & 5) != 0) break block22;
                        Report.error(n5, "missing index");
                        break block22;
                    }
                    if ((n & 2) != 0 && this.isExpr()) {
                        aST = ASTgen.at(aST.pos).Index(aST, this.expr());
                    }
                    this.accept(16);
                    break;
                }
                case 13: {
                    if ((n & 4) != 0 && this.isQualId()) {
                        aST = ASTgen.at(this.S.pos).Apply(aST, this.argList(6));
                        break block22;
                    }
                    if ((n & 2) == 0 || !this.isExpr()) break block22;
                    aST = ASTgen.at(this.S.pos).Apply(aST, this.argList(2));
                    break;
                }
                case 35: 
                case 36: {
                    if ((n & 2) == 0 || !this.isExpr()) break block22;
                    aST = this.makePostop(this.S.pos, this.S.token, aST);
                    this.S.nexttoken();
                    break;
                }
                case 31: {
                    if ((n & 4) == 0 && ((n & 1) == 0 || (n & 2) != 0 && (n & 8) == 0 || !Switches.pizza || !this.isQualId())) break block22;
                    aST = this.typeargs(aST);
                    break;
                }
                default: {
                    break block22;
                }
            }
        }
        return aST;
    }

    public AST gotoexpr() {
        int n = this.S.pos;
        this.accept(112);
        return ASTgen.at(n).Goto(this.expr());
    }

    public AST expr() {
        return this.term(2);
    }

    private AST type() {
        return this.term(1);
    }

    private AST pattern() {
        int n = this.S.pos;
        AST.TypeFormal[] typeFormalArray = this.typeFormals();
        AST aST = this.term(Switches.pizza ? 6 : 2);
        if (typeFormalArray.length > 0) {
            aST = ASTgen.at(n).Poly(typeFormalArray, aST);
        }
        return aST;
    }

    private AST parExpr() {
        this.accept(13);
        AST aST = this.expr();
        this.accept(14);
        return aST;
    }

    private AST[] argList(int n) {
        int n2 = this.S.pos;
        this.accept(13);
        List list = ASTgen.emptyASTList;
        if (this.S.token != 14) {
            list = List.Cons(this.term(n), list);
            while (this.S.token == 11) {
                this.S.nexttoken();
                list = List.Cons(this.term(n), list);
            }
        }
        this.accept(14);
        return ASTgen.reverseArray(list);
    }

    private AST typeargs(AST aST) {
        this.S.nexttoken();
        List list = List.Cons(this.type(), ASTgen.emptyASTList);
        while (this.S.token == 11) {
            this.S.nexttoken();
            list = List.Cons(this.type(), list);
        }
        switch (this.S.token) {
            case 54: {
                this.S.token = 53;
                break;
            }
            case 53: {
                this.S.token = 39;
                break;
            }
            case 39: {
                this.S.token = 34;
                break;
            }
            case 43: {
                this.S.token = 42;
                break;
            }
            case 42: {
                this.S.token = 30;
                break;
            }
            default: {
                this.accept(30);
            }
        }
        return ASTgen.at(aST.pos).ParTypeTerm(aST, ASTgen.reverseArray(list));
    }

    private AST constructor() {
        int n = this.S.pos;
        AST aST = this.qualident(1);
        if (Switches.pizzadoc && this.S.token == 31) {
            this.typeargs(aST);
        }
        if (this.S.token == 15) {
            int n2 = this.S.pos;
            this.S.nexttoken();
            if (this.S.token == 16) {
                this.S.nexttoken();
                aST = this.brackets(ASTgen.at(n2).ArrayTypeTerm(aST));
                if (this.S.token == 17) {
                    return this.aggregate(aST);
                }
                this.syntaxError("'{' expected");
                return AST.ErrorAST;
            }
            List list = List.Cons(this.expr(), ASTgen.emptyASTList);
            this.accept(16);
            while (this.S.token == 15) {
                n2 = this.S.pos;
                this.S.nexttoken();
                if (this.S.token == 16) {
                    this.S.nexttoken();
                    aST = this.brackets(ASTgen.at(n2).ArrayTypeTerm(aST));
                    continue;
                }
                list = List.Cons(this.expr(), list);
                this.accept(16);
            }
            return ASTgen.at(n).NewArray(aST, ASTgen.reverseArray(list));
        }
        if (this.S.token == 13) {
            return ASTgen.at(n).NewClass(null, aST, this.argList(2), this.optClassBlock());
        }
        if (this.S.token == 31) {
            AST aST2 = aST;
            aST = this.typeargs(aST);
            int n3 = this.S.pos;
            AST[] aSTArray = this.argList(2);
            if (this.S.token != 17) {
                if (Switches.pizzadoc) {
                    aST = aST2;
                } else {
                    Report.error(n3, "no type arguments allowed for new");
                }
            }
            return ASTgen.at(n).NewClass(null, aST, aSTArray, this.optClassBlock());
        }
        this.syntaxError("'(' or '[' expected");
        return AST.ErrorAST;
    }

    private AST innerConstructor(AST aST) {
        return ASTgen.at(this.S.pos).NewClass(aST, ASTgen.at(this.S.pos).Ident(this.ident()), this.argList(2), this.optClassBlock());
    }

    private AST parTerm(int n) {
        int n2 = this.S.pos;
        this.accept(13);
        if (this.S.token == 14) {
            this.S.nexttoken();
            return this.arrowtype(ASTgen.emptyASTs, this.throwsDcl());
        }
        AST aST = this.term(n | 1);
        if (Switches.pizza && this.S.token == 11 && (n & 5) != 0 && this.isType()) {
            List list = List.Cons(aST, ASTgen.emptyASTList);
            while (this.S.token == 11) {
                this.S.nexttoken();
                list = List.Cons(this.type(), list);
            }
            this.accept(14);
            return this.arrowtype(ASTgen.reverseArray(list), this.throwsDcl());
        }
        this.accept(14);
        if (Switches.pizza && (n & 5) != 0 && this.isType()) {
            if (this.S.token == 92) {
                return this.arrowtype(new AST[]{aST}, this.throwsDcl());
            }
            if (this.S.token == 110) {
                return this.arrowtype(new AST[]{aST}, ASTgen.emptyASTs);
            }
        }
        if (this.isType() && (n & 2) != 0) {
            switch (this.S.token) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 13: 
                case 22: 
                case 28: 
                case 79: 
                case 86: 
                case 89: 
                case 106: 
                case 108: {
                    aST = ASTgen.at(n2).Typeop(31, this.term4(2), aST);
                    break;
                }
                case 20: 
                case 21: 
                case 35: 
                case 36: {
                    if (this.isExpr()) break;
                    aST = ASTgen.at(n2).Typeop(31, this.term4(2), aST);
                    break;
                }
            }
        }
        return aST;
    }

    private AST arrowtype(AST[] aSTArray, AST[] aSTArray2) {
        int n = this.S.pos;
        this.accept(110);
        return ASTgen.at(n).FunTypeTerm(this.type(), aSTArray, aSTArray2);
    }

    private AST aggregate(AST aST) {
        int n = this.S.pos;
        this.S.nexttoken();
        List list = ASTgen.emptyASTList;
        if (this.S.token != 18) {
            list = List.Cons(this.initializer(), list);
            while (this.S.token == 11) {
                this.S.nexttoken();
                if (this.S.token == 18) break;
                list = List.Cons(this.initializer(), list);
            }
        }
        this.accept(18);
        return ASTgen.at(n).Aggregate(ASTgen.reverseArray(list), aST);
    }

    private AST initializer() {
        if (this.S.token == 17) {
            return this.aggregate(null);
        }
        return this.expr();
    }

    private AST.Case[] cases() {
        List list = List.Nil;
        while (this.S.token == 62 || this.S.token == 67) {
            int n = this.S.pos;
            int n2 = this.S.token;
            this.S.nexttoken();
            AST aST = null;
            if (n2 == 62) {
                aST = this.pattern();
            }
            this.accept(33);
            list = List.Cons(ASTgen.at(n).Case(aST, this.stats()), list);
        }
        return (AST.Case[])array.asObject(ASTgen.reverseArray(list, ObjectArray.make(new AST.Case[list.length()])).ObjectElems());
    }

    private AST[] exprstats(AST aST) {
        List list = ASTgen.emptyASTList;
        if (this.checkExprStat(aST.pos)) {
            list = List.Cons(ASTgen.at(aST.pos).Exec(aST), list);
            while (this.S.token == 11) {
                this.S.nexttoken();
                aST = this.expr();
                if (!this.checkExprStat(aST.pos)) continue;
                list = List.Cons(ASTgen.at(aST.pos).Exec(aST), list);
            }
        }
        return ASTgen.reverseArray(list);
    }

    private AST[] forInit() {
        if (this.S.token != 12) {
            int n = this.S.pos;
            if (this.S.token == 71) {
                this.S.nexttoken();
                return this.varDefs(16, this.type());
            }
            AST aST = this.term(11);
            if (this.S.token == 1 && this.isType()) {
                return this.varDefs(0, aST);
            }
            return this.exprstats(aST);
        }
        return ASTgen.emptyASTs;
    }

    private AST[] forIncr() {
        if (this.S.token != 14) {
            return this.exprstats(this.expr());
        }
        return ASTgen.emptyASTs;
    }

    private List addStat(List list) {
        int n = this.S.pos;
        switch (this.S.token) {
            case 17: {
                list = List.Cons(this.block(), list);
                break;
            }
            case 74: {
                this.S.nexttoken();
                AST aST = this.parExpr();
                AST aST2 = this.substat();
                AST aST3 = null;
                if (this.S.token == 69) {
                    this.S.nexttoken();
                    aST3 = this.substat();
                }
                list = List.Cons(ASTgen.at(n).Conditional(aST, aST2, aST3), list);
                ASTmake.lastkind = 16;
                break;
            }
            case 73: {
                this.S.nexttoken();
                this.accept(13);
                AST[] aSTArray = this.forInit();
                this.accept(12);
                AST aST = null;
                if (this.S.token != 12) {
                    aST = this.expr();
                }
                this.accept(12);
                AST[] aSTArray2 = this.forIncr();
                this.accept(14);
                list = List.Cons(ASTgen.at(n).ForLoop(aSTArray, aST, aSTArray2, this.substat()), list);
                break;
            }
            case 95: {
                this.S.nexttoken();
                AST aST = this.parExpr();
                list = List.Cons(ASTgen.at(n).WhileLoop(aST, this.substat()), list);
                break;
            }
            case 68: {
                this.S.nexttoken();
                AST aST = this.substat();
                this.accept(95);
                list = List.Cons(ASTgen.at(n).DoLoop(this.parExpr(), aST), list);
                this.accept(12);
                break;
            }
            case 94: {
                boolean bl = true;
                this.S.nexttoken();
                AST aST = this.stat();
                List list2 = List.Nil;
                while (this.S.token == 63) {
                    bl = false;
                    int n2 = this.S.pos;
                    this.S.nexttoken();
                    this.accept(13);
                    AST.VarDef varDef = this.varDcl(this.optFinal(), this.type());
                    this.accept(14);
                    AST.Block block = this.block();
                    list2 = List.Cons(ASTgen.at(n2).Catch(varDef, block.stats), list2);
                }
                AST.Block block = null;
                if (this.S.token == 72) {
                    bl = false;
                    this.S.nexttoken();
                    block = this.block();
                }
                list = List.Cons(ASTgen.at(n).Try(aST, (AST.Catch[])array.asObject(ASTgen.reverseArray(list2, ObjectArray.make(new AST.Catch[list2.length()])).ObjectElems()), block), list);
                if (!bl) break;
                Report.error(n, "'try' without 'catch' or 'finally'");
                break;
            }
            case 87: {
                this.S.nexttoken();
                AST aST = this.parExpr();
                this.accept(17);
                list = List.Cons(ASTgen.at(n).Switch(aST, this.cases()), list);
                this.accept(18);
                break;
            }
            case 88: {
                this.S.nexttoken();
                AST aST = this.parExpr();
                list = List.Cons(ASTgen.at(n).Synchronized(aST, this.substat()), list);
                break;
            }
            case 84: {
                this.S.nexttoken();
                AST aST = null;
                if (Switches.pizza && this.S.token == 112) {
                    aST = this.gotoexpr();
                } else if (this.S.token != 12) {
                    aST = this.expr();
                }
                list = List.Cons(ASTgen.at(n).Return(aST), list);
                this.accept(12);
                break;
            }
            case 112: {
                list = List.Cons(ASTgen.at(n).Exec(this.gotoexpr()), list);
                this.accept(12);
                break;
            }
            case 91: {
                this.S.nexttoken();
                list = List.Cons(ASTgen.at(n).Throw(this.expr()), list);
                this.accept(12);
                break;
            }
            case 61: {
                this.S.nexttoken();
                if (this.S.token == 1) {
                    list = List.Cons(ASTgen.at(n).Break(this.S.name), list);
                    this.S.nexttoken();
                } else {
                    list = List.Cons(ASTgen.at(n).Break(null), list);
                }
                this.accept(12);
                break;
            }
            case 66: {
                this.S.nexttoken();
                if (this.S.token == 1) {
                    list = List.Cons(ASTgen.at(n).Continue(this.S.name), list);
                    this.S.nexttoken();
                } else {
                    list = List.Cons(ASTgen.at(n).Continue(null), list);
                }
                this.accept(12);
                break;
            }
            case 71: {
                int n3 = this.modifiers();
                if (this.S.token == 77 || this.S.token == 64) {
                    list = this.addClassOrInterfaceDef(n3, list);
                    break;
                }
                n = this.S.pos;
                Name name = this.S.name;
                AST aST = this.type();
                list = this.addVarDefiners(list, n, this.ident(), n3, aST, false);
                this.accept(12);
                break;
            }
            case 60: {
                int n4 = this.modifiers();
                if (this.S.token == 77 || this.S.token == 64) {
                    list = this.addClassOrInterfaceDef(n4, list);
                    break;
                }
                this.syntaxError("'interface' or 'class' expected");
                break;
            }
            case 64: 
            case 77: {
                list = this.addClassOrInterfaceDef(0, list);
                break;
            }
            case 12: {
                this.S.nexttoken();
                break;
            }
            case 69: {
                this.syntaxError("'else' without 'if'");
                break;
            }
            case 72: {
                this.syntaxError("'finally' without 'try'");
                break;
            }
            case 63: {
                this.syntaxError("'catch' without 'try'");
                break;
            }
            case 116: {
                if (Switches.source14) {
                    this.S.nexttoken();
                    AST aST = this.expr();
                    AST aST4 = null;
                    if (this.S.token == 33) {
                        this.S.nexttoken();
                        aST4 = this.expr();
                    }
                    list = List.Cons(ASTgen.at(n).Assert(aST, aST4), list);
                    this.accept(12);
                    break;
                }
            }
            default: {
                Name name = this.S.name;
                AST aST = this.term(11);
                if (this.S.token == 33 && this.isIdent()) {
                    this.S.nexttoken();
                    list = List.Cons(ASTgen.at(n).Labelled(name, this.stat()), list);
                    break;
                }
                if (this.S.token == 1 && this.isType()) {
                    n = this.S.pos;
                    name = this.ident();
                    list = this.addVarDefiners(list, n, name, 0, aST, false);
                    this.accept(12);
                    break;
                }
                if (this.checkExprStat(n)) {
                    list = List.Cons(ASTgen.at(n).Exec(aST), list);
                }
                this.accept(12);
            }
        }
        return list;
    }

    private AST stat() {
        int n = this.S.pos;
        List list = this.addStat(ASTgen.emptyASTList);
        switch (list.net$sf$pizzacompiler$lang$List$$tag) {
            case 2: {
                List.Cons cons = (List.Cons)list;
                switch (cons.tail.net$sf$pizzacompiler$lang$List$$tag) {
                    case 1: {
                        AST aST = (AST)cons.head;
                        return aST;
                    }
                }
            }
        }
        return ASTgen.at(n).Block(ASTgen.reverseArray(list), 0);
    }

    private AST substat() {
        int n = this.S.pos;
        List list = this.addStat(ASTgen.emptyASTList);
        if (!this.isDef()) {
            switch (list.net$sf$pizzacompiler$lang$List$$tag) {
                case 2: {
                    List.Cons cons = (List.Cons)list;
                    switch (cons.tail.net$sf$pizzacompiler$lang$List$$tag) {
                        case 1: {
                            AST aST = (AST)cons.head;
                            return aST;
                        }
                    }
                }
            }
        }
        return ASTgen.at(n).Block(ASTgen.reverseArray(list), 0);
    }

    private AST[] stats() {
        List list = ASTgen.emptyASTList;
        while (true) {
            switch (this.S.token) {
                case 18: 
                case 62: 
                case 67: 
                case 114: {
                    return ASTgen.reverseArray(list);
                }
            }
            list = this.addStat(list);
        }
    }

    private AST.Block block(int n) {
        int n2 = this.S.pos;
        this.accept(17);
        AST[] aSTArray = this.stats();
        AST.Block block = ASTgen.at(n2).Block(aSTArray, n);
        if (this.S.token == 62 || this.S.token == 67) {
            this.syntaxError(String.valueOf("orphaned ").concat(String.valueOf(this.S.token2string(this.S.token))));
        }
        this.accept(18);
        return block;
    }

    private AST.Block block() {
        return this.block(0);
    }

    private AST brackets(AST aST) {
        while (this.S.token == 15) {
            int n = this.S.pos;
            this.S.nexttoken();
            this.accept(16);
            aST = ASTgen.at(n).ArrayTypeTerm(aST);
        }
        return aST;
    }

    private AST.VarDef varDcl(int n, AST aST) {
        int n2 = this.S.pos;
        Name name = this.ident();
        return ASTgen.at(n2).VarDef(name, n, this.brackets(aST), null);
    }

    private AST varDefiner(int n, Name name, int n2, AST aST, boolean bl) {
        if (aST != null) {
            aST = this.brackets(aST);
        }
        AST aST2 = null;
        if (this.S.token == 34) {
            this.S.nexttoken();
            aST2 = this.initializer();
        } else if (bl) {
            this.syntaxError("missing initializer");
        }
        return ASTgen.at(n).VarDef(name, n2, aST, aST2);
    }

    private List addVarDefiners(List list, int n, Name name, int n2, AST aST, boolean bl) {
        list = List.Cons(this.varDefiner(n, name, n2, aST, bl), list);
        while (this.S.token == 11) {
            this.S.nexttoken();
            int n3 = this.S.pos;
            Name name2 = this.ident();
            list = List.Cons(this.varDefiner(n3, name2, n2, aST, bl), list);
        }
        return list;
    }

    private AST[] varDefs(int n, AST aST) {
        return ASTgen.reverseArray(this.addVarDefiners(ASTgen.emptyASTList, this.S.pos, this.ident(), n, aST, false));
    }

    private AST.VarDef[] formals() {
        List list = List.Nil;
        this.accept(13);
        if (this.S.token != 14) {
            list = List.Cons(this.varDcl(this.optFinal(), this.type()), list);
            while (this.S.token == 11) {
                this.S.nexttoken();
                list = List.Cons(this.varDcl(this.optFinal(), this.type()), list);
            }
        }
        this.accept(14);
        return (AST.VarDef[])array.asObject(ASTgen.reverseArray(list, ObjectArray.make(new AST.VarDef[list.length()])).ObjectElems());
    }

    private AST[] throwsDcl() {
        List list = ASTgen.emptyASTList;
        if (this.S.token == 92) {
            this.S.nexttoken();
            list = List.Cons(this.qualident(0), list);
            while (this.S.token == 11) {
                this.S.nexttoken();
                list = List.Cons(this.qualident(0), list);
            }
        }
        return ASTgen.reverseArray(list);
    }

    private AST lambda(int n) {
        this.S.nexttoken();
        AST.VarDef[] varDefArray = this.formals();
        AST[] aSTArray = this.throwsDcl();
        AST aST = null;
        if (this.S.token == 110) {
            this.S.nexttoken();
            aST = this.type();
        } else if (!Switches.experimental) {
            this.accept(110);
            aST = this.type();
        }
        return ASTgen.at(n).Lambda(aST, varDefArray, aSTArray, this.block().stats);
    }

    private AST.Block optionalBlock() {
        AST.Block block;
        if (this.S.token == 12) {
            block = null;
            this.S.nexttoken();
        } else {
            block = this.block();
        }
        return block;
    }

    private AST funDefiner(int n, Name name, int n2, AST aST, AST.TypeFormal[] typeFormalArray) {
        AST.VarDef[] varDefArray = this.formals();
        if (aST != null) {
            aST = this.brackets(aST);
        }
        AST[] aSTArray = this.throwsDcl();
        AST.Block block = this.optionalBlock();
        AST aST2 = ASTgen.at(n).FunDef(name, n2, aST, varDefArray, aSTArray, block == null ? null : block.stats);
        if (typeFormalArray.length > 0) {
            aST2 = ASTgen.at(n).Poly(typeFormalArray, aST2);
        }
        return aST2;
    }

    private List addDef(List list, Name name, boolean bl) {
        if (this.S.token == 12) {
            this.S.nexttoken();
        } else {
            int n = this.modifiers();
            if (this.S.token == 17 && !bl) {
                list = List.Cons(this.block(n), list);
            } else if (this.S.token == 64 || this.S.token == 77) {
                list = this.addClassOrInterfaceDef(n, list);
            } else if (Switches.pizza && this.S.token == 62 && !bl) {
                this.S.nexttoken();
                AST.TypeFormal[] typeFormalArray = this.typeFormals();
                int n2 = this.S.pos;
                Name name2 = this.ident();
                if (this.S.token == 13) {
                    list = List.Cons(this.funDefiner(n2, name2, n | 0x40000, null, typeFormalArray), list);
                } else {
                    if (typeFormalArray.length != 0) {
                        Report.error(n2, "polymorphic variables not supported");
                    }
                    list = List.Cons(ASTgen.at(n2).VarDef(name2, n | 0x40000, null, this.optionalBlock()), list);
                }
            } else {
                AST.TypeFormal[] typeFormalArray = this.typeFormals();
                int n3 = this.S.pos;
                Name name3 = this.S.name;
                AST aST = this.type();
                if (this.S.token == 13 && !bl && this.isIdent() && name3.equals(name)) {
                    list = List.Cons(this.funDefiner(n3, Basic.initS, n, null, typeFormalArray), list);
                } else {
                    n3 = this.S.pos;
                    name3 = this.ident();
                    if (this.S.token == 13) {
                        list = List.Cons(this.funDefiner(n3, name3, n, aST, typeFormalArray), list);
                    } else {
                        if (typeFormalArray.length != 0) {
                            Report.error(n3, "polymorphic variables not supported");
                        }
                        list = this.addVarDefiners(list, n3, name3, n, aST, bl);
                        this.accept(12);
                    }
                }
            }
        }
        return list;
    }

    private AST[] classBlock(Name name, boolean bl) {
        int n = this.S.pos;
        this.accept(17);
        List list = ASTgen.emptyASTList;
        while (this.S.token != 18 && this.S.token != 114) {
            list = this.addDef(list, name, bl);
        }
        this.accept(18);
        return ASTgen.reverseArray(list);
    }

    private AST optClassBlock() {
        if (this.S.token == 17) {
            return ASTgen.at(this.S.pos).ClassDef(null, 0, ASTgen.emptyTypeFormals, null, ASTgen.emptyASTs, this.classBlock(null, false));
        }
        return null;
    }

    private AST.TypeFormal typevarDcl() {
        AST[] aSTArray;
        int n = this.S.pos;
        Name name = this.ident();
        if (this.S.token == 75 || this.S.token == 70) {
            this.S.nexttoken();
            aSTArray = new AST[]{this.type()};
        } else {
            aSTArray = ASTgen.emptyASTs;
        }
        return ASTgen.at(n).TypeFormal(name, aSTArray);
    }

    private AST.TypeFormal[] typevarDcls() {
        List list = List.Cons(this.typevarDcl(), List.Nil);
        while (this.S.token == 11) {
            this.S.nexttoken();
            list = List.Cons(this.typevarDcl(), list);
        }
        return (AST.TypeFormal[])array.asObject(ASTgen.reverseArray(list, ObjectArray.make(new AST.TypeFormal[list.length()])).ObjectElems());
    }

    private AST.TypeFormal[] typeFormals() {
        if (Switches.pizza && this.S.token == 31) {
            this.S.nexttoken();
            AST.TypeFormal[] typeFormalArray = this.typevarDcls();
            this.accept(30);
            return typeFormalArray;
        }
        return ASTgen.emptyTypeFormals;
    }

    private AST classDef(int n) {
        int n2 = this.S.pos;
        this.S.nexttoken();
        Name name = this.ident();
        AST.TypeFormal[] typeFormalArray = this.typeFormals();
        AST aST = null;
        if (this.S.token == 70) {
            this.S.nexttoken();
            aST = this.type();
        }
        List list = ASTgen.emptyASTList;
        if (this.S.token == 75) {
            this.S.nexttoken();
            list = List.Cons(this.type(), list);
            while (this.S.token == 11) {
                this.S.nexttoken();
                list = List.Cons(this.type(), list);
            }
        }
        AST[] aSTArray = this.classBlock(name, false);
        return ASTgen.at(n2).ClassDef(name, n, typeFormalArray, aST, ASTgen.reverseArray(list), aSTArray);
    }

    private AST interfaceDef(int n) {
        int n2 = this.S.pos;
        this.S.nexttoken();
        Name name = this.ident();
        AST.TypeFormal[] typeFormalArray = this.typeFormals();
        List list = ASTgen.emptyASTList;
        if (this.S.token == 70) {
            this.S.nexttoken();
            list = List.Cons(this.type(), list);
            while (this.S.token == 11) {
                this.S.nexttoken();
                list = List.Cons(this.type(), list);
            }
        }
        AST[] aSTArray = this.classBlock(name, true);
        return ASTgen.at(n2).ClassDef(name, n | 0x200, typeFormalArray, null, ASTgen.reverseArray(list), aSTArray);
    }

    private List addClassOrInterfaceDef(int n, List list) {
        n |= this.modifiers();
        if (this.S.token == 64) {
            list = List.Cons(this.classDef(n), list);
        } else if (this.S.token == 77) {
            list = List.Cons(this.interfaceDef(n), list);
        }
        return list;
    }

    private List addTopDef(List list) {
        if (this.S.pos == this.S.errPos) {
            while (this.S.token != 64 && this.S.token != 77 && this.S.token != 114) {
                this.S.nexttoken();
            }
        }
        if (this.S.token == 12) {
            this.S.nexttoken();
        } else {
            int n = this.modifiers();
            if (this.S.token == 64 || this.S.token == 77) {
                list = this.addClassOrInterfaceDef(n, list);
            } else {
                this.syntaxError("'class' or 'interface' expected");
                while (this.S.token == 18) {
                    this.S.nexttoken();
                }
            }
        }
        return list;
    }

    private AST importClause() {
        int n = this.S.pos;
        this.S.nexttoken();
        int n2 = this.S.pos;
        AST aST = ASTgen.at(n2).Ident(this.ident());
        boolean bl = false;
        while (this.S.token == 10 && !bl) {
            this.S.nexttoken();
            if (this.S.token == 26) {
                aST = ASTgen.at(this.S.pos).Select(aST, Basic.starS);
                this.S.nexttoken();
                bl = true;
                continue;
            }
            aST = ASTgen.at(this.S.pos).Select(aST, this.ident());
        }
        this.accept(12);
        return ASTgen.at(n).Import(aST);
    }

    AST[] compilationUnit() {
        int n = this.S.pos;
        List list = ASTgen.emptyASTList;
        if (this.S.token == 80) {
            this.S.nexttoken();
            AST aST = this.qualident(0);
            this.accept(12);
            list = List.Cons(ASTgen.at(n).Package(aST), list);
        }
        while (this.S.token == 76) {
            list = List.Cons(this.importClause(), list);
        }
        while (this.S.token != 114) {
            list = this.addTopDef(list);
        }
        return ASTgen.reverseArray(list);
    }

    private boolean isIdent() {
        return (ASTmake.lastkind & 1) != 0;
    }

    private boolean isQualId() {
        return (ASTmake.lastkind & 2) != 0;
    }

    private boolean isExpr() {
        return (ASTmake.lastkind & 4) != 0;
    }

    private boolean isType() {
        return (ASTmake.lastkind & 8) != 0;
    }

    private boolean isStat() {
        return (ASTmake.lastkind & 0x10) != 0;
    }

    private boolean isDef() {
        return (ASTmake.lastkind & 0x20) != 0;
    }

    private boolean checkExpr(int n) {
        if (this.isExpr()) {
            return true;
        }
        if (this.isType()) {
            Report.error(n, "malformed declaration");
        } else {
            Report.error(n, "malformed expression");
        }
        return false;
    }

    private boolean checkExprStat(int n) {
        if (this.checkExpr(n)) {
            if (this.isStat()) {
                return true;
            }
            Report.error(n, "not a statement");
        }
        return false;
    }

    private AST makeBinop(int n, int n2, AST aST, AST aST2) {
        int n3;
        switch (n2) {
            case 55: {
                n3 = 10;
                break;
            }
            case 56: {
                n3 = 11;
                break;
            }
            case 27: {
                n3 = 18;
                break;
            }
            case 24: {
                n3 = 19;
                break;
            }
            case 25: {
                n3 = 20;
                break;
            }
            case 37: {
                n3 = 12;
                break;
            }
            case 40: {
                n3 = 13;
                break;
            }
            case 31: {
                n3 = 14;
                break;
            }
            case 30: {
                n3 = 15;
                break;
            }
            case 38: {
                n3 = 16;
                break;
            }
            case 39: {
                n3 = 17;
                break;
            }
            case 41: {
                n3 = 21;
                break;
            }
            case 42: {
                n3 = 22;
                break;
            }
            case 43: {
                n3 = 23;
                break;
            }
            case 20: {
                n3 = 24;
                break;
            }
            case 21: {
                n3 = 25;
                break;
            }
            case 26: {
                n3 = 26;
                break;
            }
            case 29: {
                n3 = 27;
                break;
            }
            case 23: {
                n3 = 28;
                break;
            }
            default: {
                throw new InternalError("makeBinop");
            }
        }
        return ASTgen.at(n).Binop(n3, aST, aST2);
    }

    private AST makeAssignment(int n, int n2, AST aST, AST aST2) {
        int n3;
        switch (n2) {
            case 34: {
                return ASTgen.at(n).Assign(aST, aST2);
            }
            case 49: {
                n3 = 18;
                break;
            }
            case 50: {
                n3 = 19;
                break;
            }
            case 48: {
                n3 = 20;
                break;
            }
            case 52: {
                n3 = 21;
                break;
            }
            case 53: {
                n3 = 22;
                break;
            }
            case 54: {
                n3 = 23;
                break;
            }
            case 44: {
                n3 = 24;
                break;
            }
            case 45: {
                n3 = 25;
                break;
            }
            case 46: {
                n3 = 26;
                break;
            }
            case 47: {
                n3 = 27;
                break;
            }
            case 51: {
                n3 = 28;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        return ASTgen.at(n).Assignop(n3, aST, aST2);
    }

    private AST makePreop(int n, int n2, AST aST) {
        int n3;
        switch (n2) {
            case 20: {
                n3 = 2;
                break;
            }
            case 21: {
                n3 = 3;
                break;
            }
            case 22: {
                n3 = 4;
                break;
            }
            case 28: {
                n3 = 5;
                break;
            }
            case 35: {
                n3 = 6;
                break;
            }
            case 36: {
                n3 = 7;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        return ASTgen.at(n).Unop(n3, aST);
    }

    private AST makePostop(int n, int n2, AST aST) {
        int n3;
        switch (n2) {
            case 35: {
                n3 = 8;
                break;
            }
            case 36: {
                n3 = 9;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        return ASTgen.at(n).Unop(n3, aST);
    }

    static {
        for (int i = 0; i < 117; ++i) {
            Parser.prec[i] = -1;
        }
        Parser.prec[55] = 0;
        Parser.prec[56] = 1;
        Parser.prec[27] = 2;
        Parser.prec[24] = 3;
        Parser.prec[25] = 4;
        Parser.prec[37] = 5;
        Parser.prec[40] = 5;
        Parser.prec[31] = 6;
        Parser.prec[30] = 6;
        Parser.prec[38] = 6;
        Parser.prec[39] = 6;
        Parser.prec[41] = 7;
        Parser.prec[42] = 7;
        Parser.prec[43] = 7;
        Parser.prec[20] = 8;
        Parser.prec[21] = 8;
        Parser.prec[26] = 9;
        Parser.prec[29] = 9;
        Parser.prec[23] = 9;
    }
}

