/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.JCO;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.web3.Web3Client;
import org.apache.cocoon.components.web3.Web3DataSource;
import org.apache.cocoon.components.web3.Web3Streamer;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Web3RfcTransformer
extends AbstractTransformer
implements Serviceable,
Disposable,
Configurable,
Poolable,
Recyclable {
    protected ServiceManager manager = null;
    protected Web3DataSource web3source = null;
    protected Web3Client connection = null;
    protected JCO.Repository repository = null;
    protected IFunctionTemplate functionT = null;
    protected JCO.Function function = null;
    protected JCO.ParameterList importParameterList = null;
    protected JCO.ParameterList tablesParameterList = null;
    protected JCO.Record theRecord = null;
    protected JCO.Field fillMe = null;
    protected AttributesImpl attributes = new AttributesImpl();
    protected int startcount = 0;
    protected boolean error = false;
    protected String backend = null;
    protected String default_backend = null;
    protected String streamer = null;
    protected HashMap tags = new HashMap();
    protected static final int INCLUDE_ELEM = 1;
    protected static final int IMPORT_ELEM = 2;
    protected static final int EXPORT_ELEM = 3;
    protected static final int TABLES_ELEM = 4;
    protected static final int FIELD_ELEM = 5;
    protected static final int ROW_ELEM = 6;
    protected static final int STRUCTURE_ELEM = 7;
    protected static final int TABLE_ELEM = 8;

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws SAXException {
        block2: {
            try {
                this.backend = parameters.getParameter("system");
            }
            catch (Exception x) {
                if (null != this.backend) break block2;
                this.getLogger().warn("No backend configured! Try to use configuration");
                this.backend = this.default_backend;
            }
        }
    }

    public void service(ServiceManager manager) {
        this.manager = manager;
        this.initTags();
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.default_backend = configuration.getChild("system").getValue(null);
    }

    public void recycle() {
        this.connection = null;
        this.repository = null;
        this.functionT = null;
        this.function = null;
        this.importParameterList = null;
        this.tablesParameterList = null;
        this.theRecord = null;
        this.backend = null;
        this.streamer = null;
        this.error = false;
        this.startcount = 0;
        super.recycle();
    }

    public void dispose() {
        this.manager = null;
        this.attributes = null;
        this.web3source = null;
        this.tags = null;
    }

    public void startDocument() throws SAXException {
        if (null != this.contentHandler) {
            this.contentHandler.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        if (null != this.contentHandler) {
            this.contentHandler.endDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        if ("http://apache.org/cocoon/Web3-Rfc/1.0".equals(uri) && !this.error) {
            switch (Integer.parseInt((String)this.tags.get(loc))) {
                case 1: {
                    ServiceSelector r3sc = null;
                    try {
                        try {
                            r3sc = (ServiceSelector)this.manager.lookup("org.apache.cocoon.components.web3.Web3DataSourceSelector");
                            this.web3source = (Web3DataSource)r3sc.select((Object)this.backend);
                            this.connection = this.web3source.getWeb3Client();
                            this.repository = (JCO.Repository)this.connection.getRepository();
                            this.functionT = this.repository.getFunctionTemplate(a.getValue("name"));
                            this.streamer = null == a.getValue("streamer") ? "default" : a.getValue("streamer");
                            this.function = this.functionT.getFunction();
                        }
                        catch (Exception ex) {
                            String error = "Problems getting client for backend: '" + this.backend + "'";
                            this.getLogger().error(error, (Throwable)ex);
                            error = ex.getMessage();
                            this.attributes.clear();
                            this.contentHandler.startElement(uri, loc, raw, a);
                            this.contentHandler.startElement(uri, "processing-exception", "processing-exception", this.attributes);
                            this.contentHandler.characters(error.toCharArray(), 0, error.length());
                            this.contentHandler.endElement(uri, "processing-exception", "processing-exception");
                            this.error = true;
                            Object var9_7 = null;
                            this.manager.release((Object)r3sc);
                            return;
                        }
                        Object var9_6 = null;
                        this.manager.release((Object)r3sc);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var9_8 = null;
                        this.manager.release((Object)r3sc);
                        throw throwable;
                    }
                }
                case 2: {
                    this.importParameterList = this.function.getImportParameterList();
                    this.theRecord = this.importParameterList;
                    return;
                }
                case 5: {
                    this.fillMe = this.theRecord.getField(a.getValue("name"));
                    return;
                }
                case 7: {
                    this.theRecord = this.importParameterList.getStructure(a.getValue("name"));
                    return;
                }
                case 4: {
                    this.tablesParameterList = this.function.getTableParameterList();
                    return;
                }
                case 8: {
                    this.theRecord = this.tablesParameterList.getTable(a.getValue("name"));
                    return;
                }
                case 6: {
                    if (null == this.theRecord) return;
                    try {
                        JCO.Table tmpTable = (JCO.Table)this.theRecord;
                        tmpTable.appendRow();
                        return;
                    }
                    catch (ClassCastException x) {
                        this.getLogger().error("Not a table! " + x.getMessage(), (Throwable)x);
                        return;
                    }
                }
            }
            this.getLogger().error("Invalid element " + loc);
            return;
        }
        if (this.contentHandler == null) return;
        this.contentHandler.startElement(uri, loc, raw, a);
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        String theValue = new String(c, start, len).trim();
        if (null != this.fillMe) {
            if ("".equals(theValue)) {
                theValue = null;
            }
            try {
                this.fillMe.setValue(theValue);
                this.fillMe = null;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("set value = " + theValue);
                }
            }
            catch (JCO.ConversionException x) {
                this.getLogger().error(x.getMessage(), (Throwable)x);
            }
        } else if (this.contentHandler != null) {
            this.contentHandler.characters(c, start, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void endElement(String uri, String loc, String raw) throws SAXException {
        block11: {
            block10: {
                if (!"http://apache.org/cocoon/Web3-Rfc/1.0".equals(uri) || this.error) break block10;
                switch (Integer.parseInt((String)this.tags.get(loc))) {
                    case 1: {
                        w3s = null;
                        streamerSelector = null;
                        try {
                            this.connection.execute(this.function);
                            streamerSelector = (ServiceSelector)this.manager.lookup("org.apache.cocoon.components.web3.Web3StreamerSelector");
                            w3s = (Web3Streamer)streamerSelector.select((Object)this.streamer);
                            w3s.stream(this.function, this.contentHandler);
                            this.web3source.releaseWeb3Client(this.connection);
                            if (null == streamerSelector) ** GOTO lbl14
                        }
                        catch (Exception x) {
                            try {
                                this.attributes.clear();
                                this.contentHandler.startElement(uri, "abap-exception", "abap-exception", this.attributes);
                                this.contentHandler.characters(x.getMessage().toCharArray(), 0, x.getMessage().length());
                                this.contentHandler.endElement(uri, "abap-exception", "abap-exception");
                                this.getLogger().error(x.getMessage(), (Throwable)x);
                                this.web3source.releaseWeb3Client(this.connection);
                                if (null == streamerSelector) ** GOTO lbl32
                            }
                            catch (Throwable var7_7) {
                                this.web3source.releaseWeb3Client(this.connection);
                                if (null != streamerSelector) {
                                    streamerSelector.release(w3s);
                                }
                                this.manager.release((Object)streamerSelector);
                                throw var7_7;
                            }
                            streamerSelector.release((Object)w3s);
lbl32:
                            // 2 sources

                            this.manager.release((Object)streamerSelector);
                        }
                        streamerSelector.release((Object)w3s);
lbl14:
                        // 2 sources

                        this.manager.release((Object)streamerSelector);
                        this.connection = null;
                        this.repository = null;
                        this.functionT = null;
                        this.function = null;
                        this.importParameterList = null;
                        this.tablesParameterList = null;
                        this.theRecord = null;
                        break;
                    }
                    case 7: {
                        this.theRecord = this.importParameterList;
                    }
                }
                break block11;
            }
            if (this.contentHandler != null) {
                this.contentHandler.endElement(uri, loc, raw);
            }
        }
    }

    protected void initTags() {
        this.tags.put("include", "1");
        this.tags.put("import", "2");
        this.tags.put("export", "3");
        this.tags.put("tables", "4");
        this.tags.put("field", "5");
        this.tags.put("row", "6");
        this.tags.put("structure", "7");
        this.tags.put("table", "8");
    }
}

