/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.admin;

import java.util.Iterator;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.wc.SVNAdminHelper;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNSynchronizeEditor;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReplayHandler;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNReplayHandler
implements ISVNReplayHandler {
    private SVNRepository myTargetRepository;
    private boolean myHasCommitRevPropsCapability;
    private ISVNLogEntryHandler myLogEntryHandler;
    private ISVNDebugLog myDebugLog;
    private ISVNEventHandler myCanceller;
    private SVNSynchronizeEditor mySyncEditor;
    private SVNAdminClient myAdminClient;

    public SVNReplayHandler(SVNRepository targetRepository, boolean hasCommitRevPropsCapability, ISVNLogEntryHandler logEntryHandler, ISVNDebugLog debugLog, ISVNEventHandler canceller, SVNAdminClient adminClient) {
        this.myTargetRepository = targetRepository;
        this.myHasCommitRevPropsCapability = hasCommitRevPropsCapability;
        this.myLogEntryHandler = logEntryHandler;
        this.myDebugLog = debugLog;
        this.myCanceller = canceller;
        this.myAdminClient = adminClient;
    }

    public ISVNEditor handleStartRevision(long revision, SVNProperties revisionProperties) throws SVNException {
        this.myTargetRepository.setRevisionPropertyValue(0L, "svn:sync-currently-copying", SVNPropertyValue.create(SVNProperty.toString(revision)));
        SVNProperties filtered = new SVNProperties();
        this.filterProperties(revisionProperties, filtered, true);
        if (!filtered.containsName("svn:log")) {
            filtered.put("svn:log", "");
        }
        if (this.mySyncEditor == null) {
            this.mySyncEditor = new SVNSynchronizeEditor(this.myTargetRepository, this.myLogEntryHandler, revision - 1L);
        } else {
            this.mySyncEditor.reset(revision - 1L);
        }
        ISVNEditor cancellableEditor = SVNCancellableEditor.newInstance(this.mySyncEditor, this.myCanceller, this.myDebugLog);
        return cancellableEditor;
    }

    public void handleEndRevision(long revision, SVNProperties revisionProperties, ISVNEditor editor) throws SVNException {
        editor.closeEdit();
        if (this.mySyncEditor.getCommitInfo().getNewRevision() != revision) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Commit created rev {0} but should have created {1}", new Object[]{String.valueOf(this.mySyncEditor.getCommitInfo().getNewRevision()), String.valueOf(revision)});
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        SVNProperties existingProperties = this.myTargetRepository.getRevisionProperties(revision, null);
        SVNProperties filtered = new SVNProperties();
        this.filterProperties(revisionProperties, filtered, false);
        int filteredCount = SVNAdminHelper.writeRevisionProperties(this.myTargetRepository, revision, filtered);
        SVNAdminHelper.removePropertiesNotInSource(this.myTargetRepository, revision, revisionProperties, existingProperties);
        this.myTargetRepository.setRevisionPropertyValue(0L, "svn:sync-last-merged-rev", SVNPropertyValue.create(SVNProperty.toString(revision)));
        this.myTargetRepository.setRevisionPropertyValue(0L, "svn:sync-currently-copying", null);
        this.myAdminClient.handlePropertesCopied(filteredCount > 0, revision);
    }

    private int filterProperties(SVNProperties revProps, SVNProperties filteredProps, boolean isStart) {
        int filteredCount = 0;
        Iterator propNamesIter = revProps.nameSet().iterator();
        while (propNamesIter.hasNext()) {
            String propName = (String)propNamesIter.next();
            SVNPropertyValue propValue = revProps.getSVNPropertyValue(propName);
            boolean filter = false;
            if (this.myHasCommitRevPropsCapability) {
                filter = "svn:author".equals(propName) || "svn:date".equals(propName) || propName.startsWith("svn:sync-");
            } else {
                boolean bl = filter = !"svn:log".equals(propName);
            }
            if (!isStart) {
                boolean bl = filter = !filter;
            }
            if (filter) {
                ++filteredCount;
                continue;
            }
            filteredProps.put(propName, propValue);
        }
        return filteredCount;
    }
}

