/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Cat
extends SvnCommand {
    private SVNUrl url = null;
    private File destFile = null;
    private SVNRevision revision = SVNRevision.HEAD;

    public void execute() throws SvnAntException {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(this.destFile);
            inputStream = this.svnClient.getContent(this.url, this.revision);
            byte[] byArray = new byte[5000];
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            throw new SvnAntException("Can't get the content of the specified file", exception);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void validateAttributes() throws SvnAntValidationException {
        if (this.url == null) {
            throw new SvnAntValidationException("you must set url attr");
        }
        if (this.destFile == null) {
            this.destFile = new File(this.getProject().getBaseDir(), this.url.getLastPathSegment());
        }
        if (this.revision == null) {
            throw SvnAntValidationException.createInvalidRevisionException();
        }
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }

    public void setDestFile(File file) {
        this.destFile = file;
    }

    public void setRevision(String string) {
        this.revision = this.getRevisionFrom(string);
    }
}

