/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.application;

import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PortalApplicationConfig {
    private HashMap data = new HashMap();
    private String name = "";
    private String id = "";

    public static PortalApplicationConfig create(Document doc, String copletId) throws Exception {
        Element app = null;
        NodeList apps = doc.getDocumentElement().getElementsByTagName("application");
        int i = 0;
        while (i < apps.getLength() && app == null) {
            if (PortalApplicationConfig.isCoplet((Element)apps.item(i), copletId)) {
                app = (Element)apps.item(i);
            }
            ++i;
        }
        if (app == null) {
            throw new Exception("Application with copletId " + copletId + " not found.");
        }
        PortalApplicationConfig cfg = new PortalApplicationConfig();
        PortalApplicationConfig.setConfiguration(app, cfg);
        return cfg;
    }

    private static void setConfiguration(Element application, PortalApplicationConfig cfg) {
        cfg.name = application.getAttribute("name");
        cfg.id = application.getAttribute("id");
        NodeList settings = application.getChildNodes();
        int i = 0;
        while (i < settings.getLength()) {
            Node current = settings.item(i);
            if (current.getNodeType() == 1) {
                cfg.data.put(((Element)current).getNodeName(), ((Element)current).getNodeValue());
            }
            ++i;
        }
    }

    private static boolean isCoplet(Element elem, String id) {
        String nameAttr = elem.getAttribute("copletId");
        return nameAttr != null && nameAttr.equals(id);
    }

    private PortalApplicationConfig() {
    }

    protected PortalApplicationConfig(Element app) {
        this.name = app.getAttribute("name");
        this.id = app.getAttribute("id");
        NodeList settings = app.getChildNodes();
        int i = 0;
        while (i < settings.getLength()) {
            Node current = settings.item(i);
            if (current.getNodeType() == 1) {
                NodeList content = current.getChildNodes();
                int j = 0;
                while (j < content.getLength()) {
                    Node text = content.item(j);
                    if (text.getNodeType() == 3) {
                        this.data.put(((Element)current).getNodeName(), ((Text)text).getNodeValue());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public String getAttribute(String name) {
        return (String)this.data.get(name);
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }
}

