/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.portal.LinkService;
import org.apache.cocoon.portal.PortalComponentManager;
import org.apache.cocoon.portal.coplet.CopletFactory;
import org.apache.cocoon.portal.layout.LayoutFactory;
import org.apache.cocoon.portal.layout.renderer.Renderer;
import org.apache.cocoon.portal.profile.ProfileManager;

public class DefaultPortalComponentManager
extends AbstractLogEnabled
implements PortalComponentManager,
Serviceable,
Disposable,
ThreadSafe,
Configurable {
    protected ServiceManager manager;
    protected LinkService linkService;
    protected ProfileManager profileManager;
    protected String profileManagerRole;
    protected String linkServiceRole;
    protected String rendererSelectorRole;
    protected ServiceSelector rendererSelector;
    protected Map renderers;
    protected String copletFactoryRole;
    protected String layoutFactoryRole;
    protected CopletFactory copletFactory;
    protected LayoutFactory layoutFactory;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public LinkService getLinkService() {
        if (null == this.linkService) {
            try {
                this.linkService = (LinkService)this.manager.lookup(this.linkServiceRole);
            }
            catch (ServiceException e) {
                throw new CascadingRuntimeException("Unable to lookup link service with role " + this.linkServiceRole, (Throwable)e);
            }
        }
        return this.linkService;
    }

    public ProfileManager getProfileManager() {
        if (null == this.profileManager) {
            try {
                this.profileManager = (ProfileManager)this.manager.lookup(this.profileManagerRole);
            }
            catch (ServiceException e) {
                throw new CascadingRuntimeException("Unable to lookup profile manager with role " + this.profileManagerRole, (Throwable)e);
            }
        }
        return this.profileManager;
    }

    public void dispose() {
        if (this.manager != null) {
            if (this.rendererSelector != null) {
                Iterator i = this.renderers.values().iterator();
                while (i.hasNext()) {
                    this.rendererSelector.release(i.next());
                }
                this.manager.release((Object)this.rendererSelector);
                this.rendererSelector = null;
                this.renderers = null;
            }
            this.manager.release((Object)this.profileManager);
            this.manager.release((Object)this.linkService);
            this.profileManager = null;
            this.linkService = null;
            this.manager.release((Object)this.copletFactory);
            this.manager.release((Object)this.layoutFactory);
            this.copletFactory = null;
            this.layoutFactory = null;
            this.manager = null;
        }
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.profileManagerRole = config.getChild("profile-manager").getValue(ProfileManager.ROLE);
        this.linkServiceRole = config.getChild("link-service").getValue(LinkService.ROLE);
        this.rendererSelectorRole = config.getChild("renderer-selector").getValue(Renderer.ROLE + "Selector");
        this.copletFactoryRole = config.getChild("coplet-factory").getValue(CopletFactory.ROLE);
        this.layoutFactoryRole = config.getChild("layout-factory").getValue(LayoutFactory.ROLE);
    }

    public Renderer getRenderer(String hint) {
        Renderer o;
        if (this.rendererSelector == null) {
            try {
                this.rendererSelector = (ServiceSelector)this.manager.lookup(this.rendererSelectorRole);
            }
            catch (ServiceException e) {
                throw new CascadingRuntimeException("Unable to lookup renderer selector with role " + this.rendererSelectorRole, (Throwable)e);
            }
            this.renderers = new HashMap();
        }
        if ((o = (Renderer)this.renderers.get(hint)) == null) {
            try {
                o = (Renderer)this.rendererSelector.select((Object)hint);
                this.renderers.put(hint, o);
            }
            catch (ServiceException e) {
                throw new CascadingRuntimeException("Unable to lookup renderer with hint " + hint, (Throwable)e);
            }
        }
        return o;
    }

    public CopletFactory getCopletFactory() {
        if (null == this.copletFactory) {
            try {
                this.copletFactory = (CopletFactory)this.manager.lookup(this.copletFactoryRole);
            }
            catch (ServiceException e) {
                throw new CascadingRuntimeException("Unable to lookup coplet factory with role " + this.copletFactoryRole, (Throwable)e);
            }
        }
        return this.copletFactory;
    }

    public LayoutFactory getLayoutFactory() {
        if (null == this.layoutFactory) {
            try {
                this.layoutFactory = (LayoutFactory)this.manager.lookup(this.layoutFactoryRole);
            }
            catch (ServiceException e) {
                throw new CascadingRuntimeException("Unable to lookup layout factory with role " + this.copletFactoryRole, (Throwable)e);
            }
        }
        return this.layoutFactory;
    }
}

