/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.layout.renderer.aspect.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.layout.Layout;
import org.apache.cocoon.portal.layout.renderer.aspect.RendererAspect;
import org.apache.cocoon.portal.layout.renderer.aspect.RendererAspectContext;
import org.apache.cocoon.portal.layout.renderer.aspect.impl.RendererAspectChain;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class DefaultRendererContext
implements RendererAspectContext {
    private Iterator iterator;
    private Iterator configIterator;
    private Object config;
    private Map attributes;
    private Map objectModel;

    public DefaultRendererContext(RendererAspectChain chain) {
        this.iterator = chain.getIterator();
        this.configIterator = chain.getConfigIterator();
    }

    public void invokeNext(Layout layout, PortalService service, ContentHandler handler) throws SAXException {
        if (this.iterator.hasNext()) {
            this.config = this.configIterator.next();
            RendererAspect aspect = (RendererAspect)this.iterator.next();
            aspect.toSAX(this, layout, service, handler);
        }
    }

    public Object getAspectConfiguration() {
        return this.config;
    }

    public void setAttribute(String key, Object attribute) {
        if (key != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap(10);
            }
            this.attributes.put(key, attribute);
        }
    }

    public Object getAttribute(String key) {
        if (key != null && this.attributes != null) {
            return this.attributes.get(key);
        }
        return null;
    }

    public void removeAttribute(String key) {
        if (this.attributes != null && key != null) {
            this.attributes.remove(key);
        }
    }

    public Map getObjectModel() {
        return this.objectModel;
    }

    public void setObjectModel(Map map) {
        this.objectModel = map;
    }
}

