/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.serialization;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.serialization.AbstractSerializer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.xml.sax.ContentHandler;

public class FOPNGSerializer
extends AbstractSerializer
implements Configurable,
CacheableProcessingComponent,
Serviceable,
URIResolver,
Disposable {
    protected SourceResolver resolver;
    protected FopFactory fopfactory = FopFactory.newInstance();
    protected Fop fop;
    protected String mimetype;
    protected boolean setContentLength = true;
    private static boolean configured = false;
    protected ServiceManager manager;
    private Map rendererOptions;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure(Configuration conf) throws ConfigurationException {
        Configuration[] parameters;
        block9: {
            this.setContentLength = conf.getChild("set-content-length").getValueAsBoolean(true);
            String configUrl = conf.getChild("user-config").getValue(null);
            if (configUrl != null) {
                Source configSource = null;
                SourceResolver resolver = null;
                try {
                    try {
                        resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                        configSource = resolver.resolveURI(configUrl);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Loading configuration from " + configSource.getURI());
                        }
                        SAXConfigurationHandler configHandler = new SAXConfigurationHandler();
                        SourceUtil.toSAX((Source)configSource, (ContentHandler)configHandler);
                        this.fopfactory.setUserConfig(configHandler.getConfiguration());
                    }
                    catch (Exception e) {
                        this.getLogger().warn("Cannot load configuration from " + configUrl);
                        throw new ConfigurationException("Cannot load configuration from " + configUrl, (Throwable)e);
                    }
                    Object var7_8 = null;
                    if (resolver == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (resolver != null) {
                        resolver.release(configSource);
                        this.manager.release((Object)resolver);
                    }
                    throw throwable;
                }
                resolver.release(configSource);
                this.manager.release((Object)resolver);
            }
        }
        this.fopfactory.setURIResolver((URIResolver)this);
        this.mimetype = conf.getAttribute("mime-type");
        Configuration confRenderer = conf.getChild("renderer-config");
        if (confRenderer != null && (parameters = confRenderer.getChildren("parameter")).length > 0) {
            this.rendererOptions = new HashMap();
            for (int i = 0; i < parameters.length; ++i) {
                String name = parameters[i].getAttribute("name");
                String value = parameters[i].getAttribute("value");
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("renderer " + String.valueOf(name) + " = " + String.valueOf(value));
            }
        }
    }

    public String getMimeType() {
        return this.mimetype;
    }

    public void setOutputStream(OutputStream out) throws IOException {
        FOUserAgent userAgent = this.fopfactory.newFOUserAgent();
        if (this.rendererOptions != null) {
            userAgent.getRendererOptions().putAll(this.rendererOptions);
        }
        try {
            this.fop = this.fopfactory.newFop(this.getMimeType(), userAgent, out);
            this.setContentHandler(this.fop.getDefaultHandler());
        }
        catch (FOPException e) {
            this.getLogger().error("FOP setup failed", (Throwable)e);
            throw new IOException("Unable to setup fop: " + e.getLocalizedMessage());
        }
    }

    public Serializable getKey() {
        return "1";
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void recycle() {
        super.recycle();
        this.fop = null;
    }

    public boolean shouldSetContentLength() {
        return this.setContentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public javax.xml.transform.Source resolve(String href, String base) throws TransformerException {
        Source source;
        StreamSource streamSource;
        block20: {
            javax.xml.transform.Source source2;
            block19: {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("resolve(href = " + href + ", base = " + base + "); resolver = " + this.resolver);
                }
                streamSource = null;
                source = null;
                try {
                    try {
                        if (base == null || href.indexOf(":") > 1) {
                            source = this.resolver.resolveURI(href);
                        } else if (href.length() == 0) {
                            source = this.resolver.resolveURI(base);
                        } else if (!base.startsWith("file:")) {
                            int lastPathElementPos = base.lastIndexOf(47);
                            if (lastPathElementPos == -1) {
                                source2 = null;
                                Object var8_15 = null;
                                if (streamSource != null) return source2;
                                break block19;
                            }
                            source = this.resolver.resolveURI(base.substring(0, lastPathElementPos) + "/" + href);
                        } else {
                            File parent = new File(base.substring(5));
                            File parent2 = new File(parent.getParentFile(), href);
                            source = this.resolver.resolveURI(parent2.toURL().toExternalForm());
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("source = " + source + ", system id = " + source.getURI());
                        }
                        streamSource = new StreamSource(new ReleaseSourceInputStream(source.getInputStream(), source, this.resolver), source.getURI());
                        break block20;
                    }
                    catch (SourceException e) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Failed to resolve " + href + "(base = " + base + "), return null", (Throwable)e);
                        }
                        javax.xml.transform.Source source3 = null;
                        Object var8_17 = null;
                        if (streamSource != null) return source3;
                        this.resolver.release(source);
                        return source3;
                    }
                    catch (MalformedURLException mue) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Failed to resolve " + href + "(base = " + base + "), return null", (Throwable)mue);
                        }
                        javax.xml.transform.Source source4 = null;
                        Object var8_18 = null;
                        if (streamSource != null) return source4;
                        this.resolver.release(source);
                        return source4;
                    }
                    catch (IOException ioe) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Failed to resolve " + href + "(base = " + base + "), return null", (Throwable)ioe);
                        }
                        javax.xml.transform.Source source5 = null;
                        Object var8_19 = null;
                        if (streamSource != null) return source5;
                        this.resolver.release(source);
                        return source5;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_20 = null;
                    if (streamSource != null) throw throwable;
                    this.resolver.release(source);
                    throw throwable;
                }
            }
            this.resolver.release(source);
            return source2;
        }
        Object var8_16 = null;
        if (streamSource != null) return streamSource;
        this.resolver.release(source);
        return streamSource;
    }

    public void dispose() {
        if (null != this.manager) {
            this.manager.release((Object)this.resolver);
            this.manager = null;
        }
        this.resolver = null;
    }

    public static class ReleaseSourceInputStream
    extends InputStream {
        private InputStream delegate;
        private Source source;
        private SourceResolver sourceResolver;

        private ReleaseSourceInputStream(InputStream delegate, Source source, SourceResolver sourceResolver) {
            this.delegate = delegate;
            this.source = source;
            this.sourceResolver = sourceResolver;
        }

        public void close() throws IOException {
            this.delegate.close();
            this.sourceResolver.release(this.source);
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        public int available() throws IOException {
            return this.delegate.available();
        }

        public synchronized void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        public synchronized void reset() throws IOException {
            this.delegate.reset();
        }

        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }
}

