/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.List;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.PayloadUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MulticastKeepaliveHeartbeatSender {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$distribution$MulticastKeepaliveHeartbeatSender == null ? (class$net$sf$ehcache$distribution$MulticastKeepaliveHeartbeatSender = MulticastKeepaliveHeartbeatSender.class$("net.sf.ehcache.distribution.MulticastKeepaliveHeartbeatSender")) : class$net$sf$ehcache$distribution$MulticastKeepaliveHeartbeatSender).getName());
    private static final int DEFAULT_HEARTBEAT_INTERVAL = 5000;
    private static final int MINIMUM_HEARTBEAT_INTERVAL = 1000;
    private static long heartBeatInterval = 5000L;
    private final InetAddress groupMulticastAddress;
    private final Integer groupMulticastPort;
    private MulticastServerThread serverThread;
    private boolean stopped;
    private final CacheManager cacheManager;
    static /* synthetic */ Class class$net$sf$ehcache$distribution$MulticastKeepaliveHeartbeatSender;

    public MulticastKeepaliveHeartbeatSender(CacheManager cacheManager, InetAddress multicastAddress, Integer multicastPort) {
        this.cacheManager = cacheManager;
        this.groupMulticastAddress = multicastAddress;
        this.groupMulticastPort = multicastPort;
    }

    public final void init() {
        this.serverThread = new MulticastServerThread();
        this.serverThread.start();
    }

    public final synchronized void dispose() {
        this.stopped = true;
        this.notifyAll();
        this.serverThread.interrupt();
    }

    static void setHeartBeatInterval(long heartBeatInterval) {
        if (heartBeatInterval < 1000L) {
            LOG.warn((Object)"Trying to set heartbeat interval too low. Using MINIMUM_HEARTBEAT_INTERVAL instead.");
            MulticastKeepaliveHeartbeatSender.heartBeatInterval = 1000L;
        } else {
            MulticastKeepaliveHeartbeatSender.heartBeatInterval = heartBeatInterval;
        }
    }

    public static long getHeartBeatInterval() {
        return heartBeatInterval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class MulticastServerThread
    extends Thread {
        private MulticastSocket socket;
        private byte[] compressedUrlList;
        private int cachePeersHash;

        public MulticastServerThread() {
            super("Multicast Server Thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                this.socket = new MulticastSocket(MulticastKeepaliveHeartbeatSender.this.groupMulticastPort);
                this.socket.joinGroup(MulticastKeepaliveHeartbeatSender.this.groupMulticastAddress);
                while (!MulticastKeepaliveHeartbeatSender.this.stopped) {
                    byte[] buffer = this.createCachePeersPayload();
                    DatagramPacket packet = new DatagramPacket(buffer, buffer.length, MulticastKeepaliveHeartbeatSender.this.groupMulticastAddress, MulticastKeepaliveHeartbeatSender.this.groupMulticastPort);
                    this.socket.send(packet);
                    try {
                        MulticastServerThread multicastServerThread = this;
                        synchronized (multicastServerThread) {
                            this.wait(heartBeatInterval);
                        }
                    }
                    catch (InterruptedException e) {
                        if (MulticastKeepaliveHeartbeatSender.this.stopped) continue;
                        LOG.error((Object)("Error receiving heartbeat. Initial cause was " + e.getMessage()), (Throwable)e);
                    }
                }
                this.closeSocket();
            }
            catch (IOException e) {
                LOG.debug((Object)e);
            }
        }

        private byte[] createCachePeersPayload() {
            List localCachePeers = MulticastKeepaliveHeartbeatSender.this.cacheManager.getCachePeerListener().getBoundCachePeers();
            int newCachePeersHash = ((Object)localCachePeers).hashCode();
            if (this.cachePeersHash != newCachePeersHash) {
                this.cachePeersHash = newCachePeersHash;
                byte[] uncompressedUrlList = PayloadUtil.assembleUrlList(localCachePeers);
                this.compressedUrlList = PayloadUtil.gzip(uncompressedUrlList);
                if (this.compressedUrlList.length > 1500) {
                    LOG.fatal((Object)("Heartbeat is not working. Configure fewer caches for replication. Size is " + this.compressedUrlList.length + " but should be no greater than" + 1500));
                }
            }
            return this.compressedUrlList;
        }

        public final void interrupt() {
            this.closeSocket();
            super.interrupt();
        }

        private void closeSocket() {
            block6: {
                try {
                    if (this.socket == null || this.socket.isClosed()) break block6;
                    try {
                        this.socket.leaveGroup(MulticastKeepaliveHeartbeatSender.this.groupMulticastAddress);
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Error leaving mutlicast group. Message was " + e.getMessage()));
                    }
                    this.socket.close();
                }
                catch (NoSuchMethodError e) {
                    LOG.debug((Object)"socket.isClosed is not supported by JDK1.3");
                    try {
                        this.socket.leaveGroup(MulticastKeepaliveHeartbeatSender.this.groupMulticastAddress);
                    }
                    catch (IOException ex) {
                        LOG.error((Object)("Error leaving multicast group. Message was " + ex.getMessage()));
                    }
                    this.socket.close();
                }
            }
        }
    }
}

