/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.util;

import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.logger.NullLogger;

public class LoggerSwitch {
    protected static final Logger SHARED_NULL = new NullLogger();
    private SwitchingLogger m_switch;

    public Logger get() {
        return this.m_switch;
    }

    public LoggerSwitch(Logger fallback) {
        this(fallback, null);
    }

    public LoggerSwitch(Logger fallback, Logger preferred) {
        this.m_switch = new SwitchingLogger(fallback, preferred);
    }

    public void setFallback(Logger fallback) {
        this.m_switch.setFallback(fallback);
    }

    public void setPreferred(Logger preferred) {
        this.m_switch.setPreferred(preferred);
    }

    private static class SwitchingLogger
    implements Logger {
        Logger m_fallback;
        Logger m_preferred;
        BooleanThreadLocal m_recursionOnPreferred = new BooleanThreadLocal();
        BooleanThreadLocal m_recursionOnFallback = new BooleanThreadLocal();

        SwitchingLogger(Logger fallback, Logger preferred) {
            this.m_fallback = fallback != null ? fallback : SHARED_NULL;
            this.m_preferred = preferred;
        }

        void setFallback(Logger fallback) {
            this.m_fallback = fallback != null ? fallback : SHARED_NULL;
        }

        void setPreferred(Logger preferred) {
            this.m_preferred = preferred;
        }

        private Logger getLogger() {
            if (this.m_recursionOnFallback.value()) {
                throw new IllegalStateException("infinite recursion");
            }
            if (this.m_recursionOnPreferred.value() || this.m_preferred == null) {
                this.m_recursionOnFallback.set(Boolean.TRUE);
                return this.m_fallback;
            }
            this.m_recursionOnPreferred.set(Boolean.TRUE);
            return this.m_preferred;
        }

        private Logger getLoggerLight() {
            return this.m_preferred != null ? this.m_preferred : this.m_fallback;
        }

        private void releaseLogger() {
            if (this.m_recursionOnFallback.value()) {
                this.m_recursionOnFallback.set(Boolean.FALSE);
            } else if (this.m_recursionOnPreferred.value()) {
                this.m_recursionOnPreferred.set(Boolean.FALSE);
            } else {
                throw new IllegalStateException("no recursion");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void debug(String message) {
            Logger logger = this.getLogger();
            try {
                logger.debug(message);
            }
            finally {
                this.releaseLogger();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void debug(String message, Throwable throwable) {
            Logger logger = this.getLogger();
            try {
                logger.debug(message, throwable);
            }
            finally {
                this.releaseLogger();
            }
        }

        public boolean isDebugEnabled() {
            Logger logger = this.getLoggerLight();
            return logger.isDebugEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void info(String message) {
            Logger logger = this.getLogger();
            try {
                logger.info(message);
            }
            finally {
                this.releaseLogger();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void info(String message, Throwable throwable) {
            Logger logger = this.getLogger();
            try {
                logger.info(message, throwable);
            }
            finally {
                this.releaseLogger();
            }
        }

        public boolean isInfoEnabled() {
            Logger logger = this.getLoggerLight();
            return logger.isInfoEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void warn(String message) {
            Logger logger = this.getLogger();
            try {
                logger.warn(message);
            }
            finally {
                this.releaseLogger();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void warn(String message, Throwable throwable) {
            Logger logger = this.getLogger();
            try {
                logger.warn(message, throwable);
            }
            finally {
                this.releaseLogger();
            }
        }

        public boolean isWarnEnabled() {
            Logger logger = this.getLoggerLight();
            return logger.isWarnEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void error(String message) {
            Logger logger = this.getLogger();
            try {
                logger.error(message);
            }
            finally {
                this.releaseLogger();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void error(String message, Throwable throwable) {
            Logger logger = this.getLogger();
            try {
                logger.error(message, throwable);
            }
            finally {
                this.releaseLogger();
            }
        }

        public boolean isErrorEnabled() {
            Logger logger = this.getLoggerLight();
            return logger.isErrorEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fatalError(String message) {
            Logger logger = this.getLogger();
            try {
                logger.fatalError(message);
            }
            finally {
                this.releaseLogger();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fatalError(String message, Throwable throwable) {
            Logger logger = this.getLogger();
            try {
                logger.fatalError(message, throwable);
            }
            finally {
                this.releaseLogger();
            }
        }

        public boolean isFatalErrorEnabled() {
            Logger logger = this.getLoggerLight();
            return logger.isFatalErrorEnabled();
        }

        public Logger getChildLogger(String name) {
            return this;
        }
    }

    private static final class BooleanThreadLocal
    extends ThreadLocal {
        private BooleanThreadLocal() {
        }

        public Object initialValue() {
            return Boolean.FALSE;
        }

        public boolean value() {
            return (Boolean)this.get();
        }
    }
}

