/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.jisp;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheManager;
import org.apache.jcs.auxiliary.disk.jisp.JISPCache;
import org.apache.jcs.auxiliary.disk.jisp.JISPCacheAttributes;

public class JISPCacheManager
implements AuxiliaryCacheManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$jisp$JISPCacheManager == null ? (class$org$apache$jcs$auxiliary$disk$jisp$JISPCacheManager = JISPCacheManager.class$("org.apache.jcs.auxiliary.disk.jisp.JISPCacheManager")) : class$org$apache$jcs$auxiliary$disk$jisp$JISPCacheManager));
    private static int clients;
    private static Hashtable caches;
    private static JISPCacheManager instance;
    private static JISPCacheAttributes defaultCattr;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$jisp$JISPCacheManager;

    private JISPCacheManager(JISPCacheAttributes cattr) {
        defaultCattr = cattr;
    }

    public JISPCacheAttributes getDefaultCattr() {
        return defaultCattr;
    }

    public static JISPCacheManager getInstance(JISPCacheAttributes cattr) {
        Class clazz = class$org$apache$jcs$auxiliary$disk$jisp$JISPCacheManager == null ? (class$org$apache$jcs$auxiliary$disk$jisp$JISPCacheManager = JISPCacheManager.class$("org.apache.jcs.auxiliary.disk.jisp.JISPCacheManager")) : class$org$apache$jcs$auxiliary$disk$jisp$JISPCacheManager;
        synchronized (clazz) {
            if (instance == null) {
                instance = new JISPCacheManager(cattr);
            }
        }
        ++clients;
        return instance;
    }

    public AuxiliaryCache getCache(String cacheName) {
        JISPCacheAttributes cattr = (JISPCacheAttributes)defaultCattr.copy();
        cattr.setCacheName(cacheName);
        return this.getCache(cattr);
    }

    public AuxiliaryCache getCache(JISPCacheAttributes cattr) {
        AuxiliaryCache raf = null;
        log.debug((Object)("cacheName = " + cattr.getCacheName()));
        Hashtable hashtable = caches;
        synchronized (hashtable) {
            raf = (AuxiliaryCache)caches.get(cattr.getCacheName());
            if (raf == null) {
                raf = new JISPCache(cattr);
                caches.put(cattr.getCacheName(), raf);
            }
        }
        return raf;
    }

    public void freeCache(String name) {
        JISPCache raf = (JISPCache)caches.get(name);
        if (raf != null) {
            raf.dispose();
        }
    }

    public int getCacheType() {
        return 2;
    }

    public void release() {
        if (--clients != 0) {
            return;
        }
        Hashtable hashtable = caches;
        synchronized (hashtable) {
            Enumeration allCaches = caches.elements();
            while (allCaches.hasMoreElements()) {
                JISPCache raf = (JISPCache)allCaches.nextElement();
                if (raf == null) continue;
                raf.dispose();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        caches = new Hashtable();
    }
}

